/*
 * Decompiled with CFR 0.152.
 */
package com.szhtxx.etcloud.smser.service;

import com.szhtxx.etcloud.smser.constant.SmserConstant;
import com.szhtxx.etcloud.smser.dto.BillDetailDto;
import com.szhtxx.etcloud.smser.dto.BillDetailIdDto;
import com.szhtxx.etcloud.smser.dto.SmruleConfigDto;
import com.szhtxx.etcloud.smser.enums.EnumType;
import com.szhtxx.etcloud.smser.methods.smser.BackCalcUtilMethods;
import com.szhtxx.etcloud.smser.service.InvoiceCoreService;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InvoiceSplitCoreService {
    private static Logger LOG = LoggerFactory.getLogger(InvoiceSplitCoreService.class);
    private static BackCalcUtilMethods calcUtilMethods = new BackCalcUtilMethods();

    public static void dealDetailByRule(BillDetailDto curDto, SmruleConfigDto configDto, List<BillDetailDto> billDetailDtos, int curIndex) {
        BillDetailDto disDto;
        Map<String, Integer> decimalMap = InvoiceSplitCoreService.getDigitByRuleConfig(configDto);
        int amtNumber = decimalMap.get("amtNumber");
        int priceNumber = decimalMap.get("priceNumber");
        BigDecimal amounts = curDto.getAmounts();
        BigDecimal amountsInc = curDto.getAmountsIncTax();
        BigDecimal taxAmt = curDto.getTaxAmt();
        BigDecimal amts = curDto.getAmts();
        BigDecimal price = curDto.getPrice();
        BigDecimal priceInc = curDto.getPriceIncTax();
        int includeTax = curDto.getIncludeTax();
        BigDecimal tmpAmountsInc = curDto.getAmountsIncTax();
        BigDecimal lineAmountErr = configDto.getLineAmountErr();
        if (price != null && price.compareTo(BigDecimal.ZERO) > 0) {
            amts = amts.setScale(amtNumber, 4);
            amountsInc = amountsInc.setScale(2, 4);
            amounts = amounts.setScale(2, 4);
            if (EnumType.YOrNEnum.YES.getValue() == includeTax) {
                if (amts.multiply(priceInc = priceInc.setScale(priceNumber, 4)).subtract(amountsInc).abs().compareTo(lineAmountErr) > 0) {
                    priceInc = calcUtilMethods.recursionPrice(amountsInc, amts, priceNumber, configDto);
                }
                if (amts.multiply(price).subtract(amounts).abs().compareTo(lineAmountErr) > 0) {
                    price = calcUtilMethods.recursionPrice(amounts, amts, priceNumber, configDto);
                }
            } else {
                if (amts.multiply(price = price.setScale(priceNumber, 4)).subtract(amounts).abs().compareTo(lineAmountErr) > 0) {
                    price = calcUtilMethods.recursionPrice(amounts, amts, 0, configDto);
                }
                if (amts.multiply(priceInc).subtract(amountsInc).abs().compareTo(lineAmountErr) > 0) {
                    priceInc = calcUtilMethods.recursionPrice(amountsInc, amts, 0, configDto);
                }
            }
            curDto.setAmts(amts);
            curDto.setPrice(price);
            curDto.setPriceIncTax(priceInc);
        } else {
            amountsInc = amountsInc.setScale(2, 4);
            amounts = tmpAmountsInc.subtract(taxAmt).setScale(2, 4);
        }
        curDto.setTaxAmt(taxAmt);
        curDto.setAmounts(amounts);
        curDto.setAmountsIncTax(amountsInc);
        int j = curIndex + 1;
        if (j < billDetailDtos.size() && InvoiceCoreService.isDisLine(disDto = billDetailDtos.get(j)).booleanValue()) {
            BigDecimal disAmt = disDto.getAmounts();
            BigDecimal disAmtInc = disDto.getAmountsIncTax();
            BigDecimal oDisAmtInc = disDto.getAmountsIncTax();
            BigDecimal disTaxAmt = disDto.getTaxAmt();
            disAmtInc = disAmtInc.setScale(2, 4);
            disAmt = disAmt.setScale(2, 4);
            disTaxAmt = oDisAmtInc.subtract(disAmt).setScale(2, 4);
            disDto.setAmountsIncTax(disAmtInc);
            disDto.setAmounts(disAmt);
            disDto.setTaxAmt(disTaxAmt);
            billDetailDtos.set(j, disDto);
        }
    }

    public static List<BillDetailDto> goodsLineSplit(List<BillDetailDto> detailDtos, SmruleConfigDto configDto, BigDecimal aggrAmt, boolean hasDisLine, BigDecimal allAmount, List<BigDecimal> splitAmounts) throws IllegalAccessException, InvocationTargetException {
        BillDetailDto lastBillDteailDis;
        BigDecimal disErr;
        BigDecimal err;
        BillDetailDto originDto;
        BigDecimal billDetailAmount;
        int splitGoodsType = configDto.getSplitGoodsWithNumber();
        BigDecimal invLimitAmt = configDto.getFinalLimitAmt();
        BigDecimal lineTaxAmtErr = configDto.getLineTaxAmtErr();
        BigDecimal lineAmtErr = configDto.getLineAmountErr();
        ArrayList<BillDetailDto> originDetailDtos = new ArrayList();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(detailDtos);
            oos.flush();
            ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(bos.toByteArray()));
            originDetailDtos = (List)ois.readObject();
        }
        catch (IOException | ClassNotFoundException e) {
            LOG.error("\u5546\u54c1\u62c6\u5206\u65f6\uff0c\u5907\u4efd\u6570\u636e\u5f02\u5e38 e={}", (Throwable)e);
        }
        BigDecimal originAggrAmt = aggrAmt;
        int index = 0;
        int splitAmountIndex = 0;
        if (splitAmounts != null && !splitAmounts.isEmpty()) {
            invLimitAmt = splitAmounts.get(splitAmountIndex);
        }
        allAmount = allAmount.subtract(aggrAmt);
        while ((billDetailAmount = (originDto = detailDtos.get(index)).getAmounts().add(aggrAmt)).compareTo(invLimitAmt) > 0) {
            BillDetailDto productDto = new BillDetailDto();
            BillDetailDto newProductDto = new BillDetailDto();
            if (originDto.getOriginalAmts() == null) {
                originDto.setOriginalAmts(originDto.getAmts());
                productDto.setOriginalAmts(originDto.getAmts());
                newProductDto.setOriginalAmts(originDto.getAmts());
            }
            if (hasDisLine) {
                int disLineIndex = index + 1;
                BillDetailDto orginDisDto = detailDtos.get(disLineIndex);
                BillDetailDto disDto = new BillDetailDto();
                BillDetailDto newDisDto = new BillDetailDto();
                InvoiceSplitCoreService.splitLineByDis(configDto, originDto, productDto, newProductDto, orginDisDto, disDto, newDisDto, aggrAmt, invLimitAmt);
                detailDtos.set(index, productDto);
                BigDecimal disAmount = disDto.getAmounts();
                if (disAmount.compareTo(BigDecimal.ZERO) == 0) {
                    if (newProductDto.getAmounts().compareTo(BigDecimal.ZERO) == 0) break;
                    detailDtos.set(index + 1, newProductDto);
                    ++index;
                    if (newDisDto.getAmounts().compareTo(BigDecimal.ZERO) != 0) {
                        detailDtos.add(index + 1, newDisDto);
                        ++index;
                    }
                } else {
                    detailDtos.set(index + 1, disDto);
                    ++index;
                    if (newProductDto.getAmounts().compareTo(BigDecimal.ZERO) == 0) break;
                    detailDtos.add(index + 1, newProductDto);
                    ++index;
                    if (newDisDto.getAmounts().compareTo(BigDecimal.ZERO) != 0) {
                        detailDtos.add(index + 1, newDisDto);
                    }
                }
                allAmount = allAmount.subtract(productDto.getAmounts());
                allAmount = allAmount.subtract(disDto.getAmounts());
            } else {
                InvoiceSplitCoreService.splitLine(configDto, originDto, productDto, newProductDto, aggrAmt, invLimitAmt);
                detailDtos.set(index, productDto);
                if (newProductDto.getAmounts().compareTo(BigDecimal.ZERO) == 0) break;
                detailDtos.add(index + 1, newProductDto);
                ++index;
                allAmount = allAmount.subtract(productDto.getAmounts());
            }
            aggrAmt = BigDecimal.ZERO;
            invLimitAmt = splitAmounts != null && !splitAmounts.isEmpty() && splitAmounts.size() > splitAmountIndex ? splitAmounts.get(++splitAmountIndex) : configDto.getFinalLimitAmt();
            if (InvoiceSplitCoreService.addNextProLineIsExpeed(detailDtos, index, invLimitAmt).booleanValue()) continue;
        }
        BillDetailDto lastBillDetail = detailDtos.get(detailDtos.size() - 1);
        if (hasDisLine) {
            lastBillDetail = detailDtos.get(detailDtos.size() - 2);
        }
        Map<String, Integer> decimalMap = InvoiceSplitCoreService.getDigitByRuleConfig(configDto);
        int amtNumber = decimalMap.get("amtNumber");
        int priceNumber = decimalMap.get("priceNumber");
        int includeTax = lastBillDetail.getIncludeTax();
        BigDecimal price = lastBillDetail.getPrice();
        BigDecimal amts = lastBillDetail.getAmts();
        BigDecimal amounts = lastBillDetail.getAmounts();
        BigDecimal priceInc = lastBillDetail.getPriceIncTax();
        BigDecimal amountsInc = lastBillDetail.getAmountsIncTax();
        if (price != null && price.compareTo(BigDecimal.ZERO) > 0) {
            splitAmountIndex = 0;
            if (EnumType.YOrNEnum.YES.getValue() == includeTax && priceInc.multiply(amts).subtract(amountsInc).abs().compareTo(lineAmtErr) > 0) {
                if (splitGoodsType == EnumType.SplitGoodsTypeEnum.TWO.getValue()) {
                    amts = calcUtilMethods.recursionAmtsCut(amountsInc, priceInc, amtNumber, configDto);
                    lastBillDetail.setAmts(amts);
                } else if (splitGoodsType == EnumType.SplitGoodsTypeEnum.THREE.getValue()) {
                    priceInc = calcUtilMethods.recursionPrice(amountsInc, amts, priceNumber, configDto);
                    lastBillDetail.setPriceIncTax(priceInc);
                }
            }
            price = lastBillDetail.getPrice();
            amts = lastBillDetail.getAmts();
            amounts = lastBillDetail.getAmounts();
            splitAmountIndex = 0;
            if (price.multiply(amts).subtract(amounts).abs().compareTo(lineAmtErr) > 0) {
                if (splitGoodsType == EnumType.SplitGoodsTypeEnum.TWO.getValue()) {
                    amts = calcUtilMethods.recursionAmtsCut(amounts, price, amtNumber, configDto);
                    lastBillDetail.setAmts(amts);
                } else if (splitGoodsType == EnumType.SplitGoodsTypeEnum.THREE.getValue()) {
                    price = calcUtilMethods.recursionPrice(amounts, amts, priceNumber, configDto);
                    lastBillDetail.setPrice(price);
                }
            }
        }
        if ((err = lastBillDetail.getAmounts().multiply(lastBillDetail.getTaxRate()).subtract(lastBillDetail.getTaxAmt())).abs().compareTo(lineTaxAmtErr) > 0) {
            BigDecimal adjustAmount = err.divide(new BigDecimal(String.valueOf(detailDtos.size())), 2, 0);
            for (BillDetailDto billDetailDto : detailDtos) {
                if (InvoiceSplitCoreService.isDisLine(billDetailDto).booleanValue()) continue;
                if (err.abs().compareTo(lineAmtErr) <= 0) break;
                BigDecimal allowAdjust = billDetailDto.getAmounts().multiply(billDetailDto.getTaxRate()).subtract(billDetailDto.getTaxAmt()).abs().subtract(new BigDecimal("0.06")).abs().setScale(2, 1);
                allowAdjust = adjustAmount.compareTo(allowAdjust) > 0 ? allowAdjust : adjustAmount;
                billDetailDto.setTaxAmt(billDetailDto.getTaxAmt().subtract(allowAdjust));
                lastBillDetail.setTaxAmt(lastBillDetail.getTaxAmt().add(allowAdjust));
                err = err.subtract(allowAdjust);
            }
        }
        if (hasDisLine && (disErr = (lastBillDteailDis = detailDtos.get(detailDtos.size() - 1)).getAmounts().multiply(lastBillDteailDis.getTaxRate()).subtract(lastBillDteailDis.getTaxAmt())).abs().compareTo(lineTaxAmtErr) > 0) {
            BigDecimal adjustAmount = disErr.divide(new BigDecimal(String.valueOf(detailDtos.size())), 2, 0);
            for (BillDetailDto billDetailDto : detailDtos) {
                if (!InvoiceSplitCoreService.isDisLine(billDetailDto).booleanValue()) continue;
                if (disErr.abs().compareTo(lineAmtErr) <= 0) break;
                BigDecimal allowAdjust = billDetailDto.getAmounts().multiply(billDetailDto.getTaxRate()).subtract(billDetailDto.getTaxAmt()).abs().subtract(new BigDecimal("0.06")).abs().setScale(2, 1);
                allowAdjust = adjustAmount.compareTo(allowAdjust) > 0 ? allowAdjust : adjustAmount;
                billDetailDto.setTaxAmt(billDetailDto.getTaxAmt().subtract(allowAdjust));
                lastBillDteailDis.setTaxAmt(lastBillDteailDis.getTaxAmt().add(allowAdjust));
                disErr = disErr.subtract(allowAdjust);
            }
        }
        price = lastBillDetail.getPrice();
        amts = lastBillDetail.getAmts();
        amounts = lastBillDetail.getAmounts();
        priceInc = lastBillDetail.getPriceIncTax();
        amountsInc = lastBillDetail.getAmountsIncTax();
        if (price != null && price.compareTo(BigDecimal.ZERO) > 0) {
            BigDecimal allAmounts = amounts;
            if (hasDisLine) {
                allAmounts = allAmounts.add(detailDtos.get(detailDtos.size() - 1).getAmounts());
            }
            if (allAmounts.compareTo(invLimitAmt) > 0 && priceNumber < 15) {
                configDto.setPriceNumber(priceNumber + 1);
                if (configDto.getPriceNumberType() != 1) {
                    detailDtos = InvoiceSplitCoreService.goodsLineSplit(originDetailDtos, configDto, originAggrAmt, hasDisLine, allAmount, splitAmounts);
                }
                configDto.setPriceNumber(priceNumber);
                return detailDtos;
            }
            if (priceInc.multiply(amts).subtract(amountsInc).abs().compareTo(lineAmtErr) > 0 && priceNumber < 15) {
                configDto.setPriceNumber(priceNumber + 1);
                if (configDto.getPriceNumberType() != 1) {
                    detailDtos = InvoiceSplitCoreService.goodsLineSplit(originDetailDtos, configDto, originAggrAmt, hasDisLine, allAmount, splitAmounts);
                }
                configDto.setPriceNumber(priceNumber);
                return detailDtos;
            }
            if (price.multiply(amts).subtract(amounts).abs().compareTo(lineAmtErr) > 0 && priceNumber < 15) {
                configDto.setPriceNumber(priceNumber + 1);
                if (configDto.getPriceNumberType() != 1) {
                    detailDtos = InvoiceSplitCoreService.goodsLineSplit(originDetailDtos, configDto, originAggrAmt, hasDisLine, allAmount, splitAmounts);
                }
                configDto.setPriceNumber(priceNumber);
                return detailDtos;
            }
        }
        return detailDtos;
    }

    private static Boolean addNextProLineIsExpeed(List<BillDetailDto> detailDtos, int curIndex, BigDecimal invLimitAmt) {
        BillDetailDto lineDto = detailDtos.get(curIndex);
        BigDecimal countNextAmount = BigDecimal.ZERO.add(lineDto.getAmounts());
        int j = curIndex + 1;
        if (j < detailDtos.size()) {
            BillDetailDto disLineDto = detailDtos.get(j);
            countNextAmount = countNextAmount.add(disLineDto.getAmounts());
        }
        if (countNextAmount.compareTo(invLimitAmt) > 0) {
            return true;
        }
        return false;
    }

    private static void splitLineByDis(SmruleConfigDto configDto, BillDetailDto orginDto, BillDetailDto productDto, BillDetailDto newProductDto, BillDetailDto orginDisDto, BillDetailDto disDto, BillDetailDto newdisDto, BigDecimal aggrAmt, BigDecimal invLimitAmt) throws IllegalAccessException, InvocationTargetException {
        BigDecimal dec = orginDto.getTaxDeduction();
        BigDecimal oAmounts = orginDto.getAmounts();
        BigDecimal oDisAmounts = orginDisDto.getAmounts();
        BigDecimal lineAmtErr = configDto.getLineAmountErr();
        BigDecimal itemAmt = invLimitAmt.subtract(aggrAmt);
        BigDecimal calDisAmt = null;
        BigDecimal usedAmt = null;
        if (itemAmt.compareTo(invLimitAmt) > 0) {
            calDisAmt = oDisAmounts.multiply(invLimitAmt).divide(oAmounts, 2, 4);
            usedAmt = invLimitAmt.subtract(calDisAmt);
        } else {
            BigDecimal itemAmtGroup = oAmounts.add(oDisAmounts);
            calDisAmt = oDisAmounts.multiply(itemAmt).divide(itemAmtGroup, 2, 4);
            usedAmt = itemAmt.subtract(calDisAmt);
        }
        int includeTax = orginDto.getIncludeTax();
        Map<String, Integer> decimalMap = InvoiceSplitCoreService.getDigitByRuleConfig(configDto);
        int amtNumber = decimalMap.get("amtNumber");
        int priceNumber = decimalMap.get("priceNumber");
        BeanUtils.copyProperties((Object)productDto, (Object)orginDto);
        productDto.setAmounts(usedAmt);
        BigDecimal taxRate = productDto.getTaxRate();
        BigDecimal amounts = productDto.getAmounts();
        BigDecimal price = productDto.getPrice();
        BigDecimal price1 = productDto.getPrice();
        BigDecimal priceInc = productDto.getPriceIncTax();
        BigDecimal priceInc1 = productDto.getPriceIncTax();
        BigDecimal amts = null;
        BigDecimal amts1 = null;
        BigDecimal taxAmt = null;
        BigDecimal taxAmt1 = null;
        BigDecimal amounts1 = null;
        BigDecimal amountsInc = null;
        BigDecimal amountsInc1 = null;
        BeanUtils.copyProperties((Object)newProductDto, (Object)orginDto);
        BigDecimal tmpAmountsInc = orginDto.getAmountsIncTax();
        if (price != null && price.compareTo(BigDecimal.ZERO) > 0) {
            if ((price = price.setScale(priceNumber, 4)).compareTo(BigDecimal.ZERO) == 0) {
                price = price1;
            } else {
                price1 = price1.setScale(priceNumber, 4);
            }
            priceInc = priceInc.setScale(priceNumber, 4);
            if (priceInc.compareTo(BigDecimal.ZERO) == 0) {
                priceInc = priceInc1;
            } else {
                priceInc1 = priceInc1.setScale(priceNumber, 4);
            }
            amts = calcUtilMethods.recursionAmtsCut(amounts, price, amtNumber, configDto);
            amts = amts.setScale(amtNumber, 3);
            if (amts.compareTo(BigDecimal.ZERO) == 0) {
                amts = calcUtilMethods.recursionAmtsCut(amounts, price, amtNumber, configDto);
            }
            if (amts.compareTo(BigDecimal.ONE) <= 0 && price.compareTo(invLimitAmt) < 0 && amts.setScale(amtNumber, 3).compareTo(BigDecimal.ZERO) == 0) {
                BeanUtils.copyProperties((Object)productDto, (Object)orginDto);
                newProductDto.setAmounts(BigDecimal.ZERO);
                BeanUtils.copyProperties((Object)disDto, (Object)orginDisDto);
                newdisDto.setAmounts(BigDecimal.ZERO);
                return;
            }
            amts1 = orginDto.getAmts().subtract(amts);
            if (amts1.compareTo(BigDecimal.ZERO) < 0) {
                configDto.setPriceNumber(priceNumber + 1);
                if (configDto.getPriceNumber() > 15) {
                    BeanUtils.copyProperties((Object)productDto, (Object)orginDto);
                    newProductDto.setAmounts(BigDecimal.ZERO);
                    BeanUtils.copyProperties((Object)disDto, (Object)orginDisDto);
                    newdisDto.setAmounts(BigDecimal.ZERO);
                    return;
                }
                InvoiceSplitCoreService.splitLineByDis(configDto, orginDto, productDto, newProductDto, orginDisDto, disDto, newdisDto, aggrAmt, invLimitAmt);
                return;
            }
            amounts = calcUtilMethods.recursionAmounts(amts, price, 2, configDto);
            amounts1 = orginDto.getAmounts().subtract(amounts);
            amountsInc = calcUtilMethods.recursionAmounts(amts, priceInc, 2, configDto);
            amountsInc1 = orginDto.getAmountsIncTax().subtract(amountsInc);
            taxAmt = amountsInc.subtract(amounts);
            taxAmt1 = orginDto.getTaxAmt().subtract(taxAmt);
            if (amounts.compareTo(BigDecimal.ZERO) <= 0 || amounts1.compareTo(BigDecimal.ZERO) < 0 || amountsInc.compareTo(BigDecimal.ZERO) <= 0 || amountsInc1.compareTo(BigDecimal.ZERO) < 0) {
                BeanUtils.copyProperties((Object)productDto, (Object)orginDto);
                newProductDto.setAmounts(BigDecimal.ZERO);
                BeanUtils.copyProperties((Object)disDto, (Object)orginDisDto);
                newdisDto.setAmounts(BigDecimal.ZERO);
                return;
            }
            if (amounts.multiply(taxRate).subtract(taxAmt).abs().compareTo(configDto.getLineTaxAmtErr()) > 0) {
                taxAmt = calcUtilMethods.calcTaxAmtByNoTaxMoneyDec(amounts, dec, taxRate, 2);
                taxAmt1 = orginDto.getTaxAmt().subtract(taxAmt);
            }
            if (taxRate.compareTo(BigDecimal.ZERO) == 0) {
                taxAmt = orginDto.getTaxAmt().multiply(amounts).divide(orginDto.getAmounts(), 2, 4);
                taxAmt1 = orginDto.getTaxAmt().subtract(taxAmt);
                amountsInc = amounts.add(taxAmt);
                amountsInc1 = orginDto.getAmountsIncTax().subtract(amountsInc);
                if (EnumType.YOrNEnum.YES.getValue() == includeTax && priceInc.multiply(amts).subtract(amountsInc).abs().compareTo(lineAmtErr) > 0) {
                    amountsInc = calcUtilMethods.recursionAmounts(amts, priceInc, 2, configDto);
                    amountsInc1 = orginDto.getAmountsIncTax().subtract(amountsInc);
                }
            }
            productDto.setAmts(amts);
            productDto.setPrice(price);
            productDto.setPriceIncTax(priceInc);
            newProductDto.setAmts(amts1);
            newProductDto.setPrice(price1);
            newProductDto.setPriceIncTax(priceInc1);
        } else {
            amounts = usedAmt.setScale(2, 4);
            amounts1 = oAmounts.subtract(amounts).setScale(2, 4);
            taxAmt = calcUtilMethods.calcTaxAmtByNoTaxMoneyDec(amounts, dec, taxRate, 2);
            taxAmt1 = orginDto.getTaxAmt().subtract(taxAmt);
            amountsInc = amounts.add(taxAmt);
            amountsInc1 = tmpAmountsInc.subtract(amountsInc).setScale(2, 4);
        }
        productDto.setAmounts(amounts);
        productDto.setAmountsIncTax(amountsInc);
        productDto.setTaxAmt(taxAmt);
        productDto.setSplitSign(1);
        newProductDto.setAmounts(amounts1);
        newProductDto.setAmountsIncTax(amountsInc1);
        newProductDto.setTaxAmt(taxAmt1);
        newProductDto.setSplitSign(1);
        BeanUtils.copyProperties((Object)disDto, (Object)orginDisDto);
        BigDecimal disTaxRate = disDto.getTaxRate();
        BigDecimal disAmtount = itemAmt.subtract(amounts);
        disAmtount = disAmtount.compareTo(BigDecimal.ZERO) >= 0 ? calDisAmt : disAmtount;
        BigDecimal disTaxAmt = disAmtount.multiply(disTaxRate).setScale(2, 4);
        disDto.setAmounts(disAmtount);
        disDto.setTaxAmt(disTaxAmt);
        BigDecimal disAmtInc = disAmtount.add(disTaxAmt);
        disDto.setAmountsIncTax(disAmtInc);
        disDto.setSplitSign(1);
        BeanUtils.copyProperties((Object)newdisDto, (Object)orginDisDto);
        BigDecimal disAmt1 = orginDisDto.getAmounts().subtract(disAmtount).setScale(2, 4);
        BigDecimal disTaxAmt1 = orginDisDto.getTaxAmt().subtract(disTaxAmt).setScale(2, 4);
        newdisDto.setAmounts(disAmt1);
        newdisDto.setTaxAmt(disTaxAmt1);
        BigDecimal disAmtInc1 = orginDisDto.getAmountsIncTax().subtract(disAmtInc);
        newdisDto.setAmountsIncTax(disAmtInc1);
        newdisDto.setSplitSign(1);
        InvoiceSplitCoreService.BillDetailIdSplit(orginDto, productDto, newProductDto, orginDisDto, disDto, newdisDto, configDto);
    }

    public static BigDecimal getTaxAmtByIncTax(int includeTax, BigDecimal amountInc, BigDecimal amount, BigDecimal dec, BigDecimal taxRate) {
        if (EnumType.YOrNEnum.YES.getValue() == includeTax) {
            return calcUtilMethods.calcTaxAmtByTaxMoneyDec(amountInc, dec, taxRate, 2);
        }
        return calcUtilMethods.calcTaxAmtByNoTaxMoneyDec(amount, dec, taxRate, 2);
    }

    private static void splitLine(SmruleConfigDto configDto, BillDetailDto orginDto, BillDetailDto productDto, BillDetailDto newProductDto, BigDecimal aggrAmt, BigDecimal invLimitAmt) throws IllegalAccessException, InvocationTargetException {
        BigDecimal dec = orginDto.getTaxDeduction();
        int includeTax = orginDto.getIncludeTax();
        BigDecimal lineAmtErr = configDto.getLineAmountErr();
        Map<String, Integer> decimalMap = InvoiceSplitCoreService.getDigitByRuleConfig(configDto);
        int amtNumber = decimalMap.get("amtNumber");
        int priceNumber = decimalMap.get("priceNumber");
        BigDecimal usedAmt = invLimitAmt.subtract(aggrAmt);
        BeanUtils.copyProperties((Object)productDto, (Object)orginDto);
        productDto.setAmounts(usedAmt);
        BigDecimal taxRate = productDto.getTaxRate();
        BigDecimal amounts = productDto.getAmounts();
        BigDecimal price = productDto.getPrice();
        BigDecimal price1 = productDto.getPrice();
        BigDecimal priceInc = productDto.getPriceIncTax();
        BigDecimal priceInc1 = productDto.getPriceIncTax();
        BigDecimal amts = null;
        BigDecimal amts1 = null;
        BigDecimal taxAmt = null;
        BigDecimal taxAmt1 = null;
        BigDecimal amounts1 = null;
        BigDecimal amountsInc = null;
        BigDecimal amountsInc1 = null;
        BeanUtils.copyProperties((Object)newProductDto, (Object)orginDto);
        BigDecimal tmpAmountsInc = orginDto.getAmountsIncTax();
        if (price != null && price.compareTo(BigDecimal.ZERO) > 0) {
            if ((priceInc = priceInc.setScale(priceNumber, 4)).compareTo(BigDecimal.ZERO) == 0) {
                priceInc = priceInc1;
            } else {
                priceInc1 = priceInc1.setScale(priceNumber, 4);
            }
            price = price.setScale(priceNumber, 4);
            if (price.compareTo(BigDecimal.ZERO) == 0) {
                price = price1;
            } else {
                price1 = price1.setScale(priceNumber, 4);
            }
            amts = calcUtilMethods.recursionAmtsCut(amounts, price, amtNumber, configDto);
            amts = amts.setScale(amtNumber, 3);
            if (amts.compareTo(BigDecimal.ZERO) == 0) {
                amts = calcUtilMethods.recursionAmtsCut(amounts, price, amtNumber, configDto);
            }
            if (amts.compareTo(BigDecimal.ONE) <= 0 && price.compareTo(invLimitAmt) < 0 && amts.setScale(amtNumber, 3).compareTo(BigDecimal.ZERO) == 0) {
                BeanUtils.copyProperties((Object)productDto, (Object)orginDto);
                newProductDto.setAmounts(BigDecimal.ZERO);
                return;
            }
            amts1 = orginDto.getAmts().subtract(amts);
            if (amts1.compareTo(BigDecimal.ZERO) < 0) {
                configDto.setPriceNumber(priceNumber + 1);
                if (configDto.getPriceNumber() > 15) {
                    BeanUtils.copyProperties((Object)productDto, (Object)orginDto);
                    newProductDto.setAmounts(BigDecimal.ZERO);
                    return;
                }
                InvoiceSplitCoreService.splitLine(configDto, orginDto, productDto, newProductDto, aggrAmt, invLimitAmt);
                return;
            }
            amounts = calcUtilMethods.recursionAmounts(amts, price, 2, configDto);
            amounts1 = orginDto.getAmounts().subtract(amounts);
            amountsInc = calcUtilMethods.recursionAmounts(amts, priceInc, 2, configDto);
            amountsInc1 = orginDto.getAmountsIncTax().subtract(amountsInc);
            taxAmt = amountsInc.subtract(amounts);
            taxAmt1 = orginDto.getTaxAmt().subtract(taxAmt);
            if (amounts.compareTo(BigDecimal.ZERO) <= 0 || amounts1.compareTo(BigDecimal.ZERO) < 0 || amountsInc.compareTo(BigDecimal.ZERO) <= 0 || amountsInc1.compareTo(BigDecimal.ZERO) < 0) {
                BeanUtils.copyProperties((Object)productDto, (Object)orginDto);
                newProductDto.setAmounts(BigDecimal.ZERO);
                return;
            }
            if (amounts.multiply(taxRate).subtract(taxAmt).abs().compareTo(configDto.getLineTaxAmtErr()) > 0) {
                taxAmt = calcUtilMethods.calcTaxAmtByNoTaxMoneyDec(amounts, dec, taxRate, 2);
                taxAmt1 = orginDto.getTaxAmt().subtract(taxAmt);
            }
            if (taxRate.compareTo(BigDecimal.ZERO) == 0) {
                taxAmt = orginDto.getTaxAmt().multiply(amounts).divide(orginDto.getAmounts(), 2, 4);
                taxAmt1 = orginDto.getTaxAmt().subtract(taxAmt);
                amountsInc = amounts.add(taxAmt);
                amountsInc1 = orginDto.getAmountsIncTax().subtract(amountsInc);
                if (EnumType.YOrNEnum.YES.getValue() == includeTax && priceInc.multiply(amts).subtract(amountsInc).abs().compareTo(lineAmtErr) > 0) {
                    amountsInc = calcUtilMethods.recursionAmounts(amts, priceInc, 2, configDto);
                    amountsInc1 = orginDto.getAmountsIncTax().subtract(amountsInc);
                }
            }
            productDto.setAmts(amts);
            productDto.setPrice(price);
            productDto.setPriceIncTax(priceInc);
            newProductDto.setAmts(amts1);
            newProductDto.setPrice(price1);
            newProductDto.setPriceIncTax(priceInc1);
        } else {
            BigDecimal oAmounts = orginDto.getAmounts();
            amounts = usedAmt.setScale(2, 3);
            amounts1 = oAmounts.subtract(amounts).setScale(2, 3);
            taxAmt = calcUtilMethods.calcTaxAmtByNoTaxMoneyDec(amounts, dec, taxRate, 2);
            taxAmt1 = orginDto.getTaxAmt().subtract(taxAmt);
            amountsInc = amounts.add(taxAmt);
            amountsInc1 = tmpAmountsInc.subtract(amountsInc).setScale(2, 4);
        }
        productDto.setAmounts(amounts);
        productDto.setAmountsIncTax(amountsInc);
        productDto.setTaxAmt(taxAmt);
        productDto.setSplitSign(1);
        newProductDto.setAmounts(amounts1);
        newProductDto.setAmountsIncTax(amountsInc1);
        newProductDto.setTaxAmt(taxAmt1);
        newProductDto.setSplitSign(1);
        InvoiceSplitCoreService.BillDetailIdSplit(orginDto, productDto, newProductDto, null, null, null, configDto);
    }

    public static Map<String, Integer> getDigitByRuleConfig(SmruleConfigDto configDto) {
        HashMap<String, Integer> retMap = new HashMap<String, Integer>(1);
        Integer amtNumberType = configDto.getAmtNumberType();
        Integer amtNumber = configDto.getAmtNumber();
        Integer priceNumberType = configDto.getPriceNumberType();
        Integer priceNumber = configDto.getPriceNumber();
        int digit = SmserConstant.ONE;
        if (EnumType.NumberTypeEnum.ZERO.getValue().intValue() == priceNumberType.intValue()) {
            digit = priceNumber;
        } else if (EnumType.NumberTypeEnum.ONE.getValue().intValue() == priceNumberType.intValue()) {
            digit = 0;
        } else if (EnumType.NumberTypeEnum.TWO.getValue().intValue() == priceNumberType.intValue()) {
            digit = priceNumber;
        }
        retMap.put("priceNumber", digit);
        if (EnumType.NumberTypeEnum.ZERO.getValue().intValue() == amtNumberType.intValue()) {
            digit = amtNumber;
        } else if (EnumType.NumberTypeEnum.ONE.getValue().intValue() == amtNumberType.intValue()) {
            digit = 0;
        } else if (EnumType.NumberTypeEnum.TWO.getValue().intValue() == amtNumberType.intValue()) {
            digit = amtNumber;
        }
        retMap.put("amtNumber", digit);
        return retMap;
    }

    public static Boolean isDisLine(BillDetailDto detailDto) {
        Integer lineProperty = detailDto.getLineProperty();
        BigDecimal amounts = detailDto.getAmounts();
        Boolean isDisline = false;
        if (EnumType.LinePropertyEnum.FOUR.getValue().compareTo(lineProperty) == 0 && amounts.compareTo(BigDecimal.ZERO) < 0) {
            isDisline = true;
        }
        return isDisline;
    }

    public static void BillDetailIdSplit(BillDetailDto orginDto, BillDetailDto productDto, BillDetailDto newProductDto, BillDetailDto orginDisDto, BillDetailDto disDto, BillDetailDto newdisDto, SmruleConfigDto configDto) {
        Set<BillDetailIdDto> orginDetailIdSet = orginDto.getDetailIdSet();
        Iterator<BillDetailIdDto> it = orginDetailIdSet.iterator();
        LinkedHashSet<BillDetailIdDto> productDetailIdSet = new LinkedHashSet<BillDetailIdDto>();
        BigDecimal sumAmount = BigDecimal.ZERO;
        while (it.hasNext()) {
            BillDetailIdDto billDetailIdDto = it.next();
            if ((sumAmount = sumAmount.add(billDetailIdDto.getAmounts())).compareTo(productDto.getAmountsByTax()) > 0) {
                BigDecimal splitAomunt2 = sumAmount.subtract(productDto.getAmountsByTax());
                BigDecimal splitAomunt1 = billDetailIdDto.getAmounts().subtract(splitAomunt2);
                BigDecimal amt2 = calcUtilMethods.recursionAmtsCut(splitAomunt2, billDetailIdDto.getPrice(), configDto.getAmtNumber(), configDto);
                BigDecimal amt1 = billDetailIdDto.getAmts().subtract(amt2);
                BillDetailIdDto splitBillDetailId1 = new BillDetailIdDto(billDetailIdDto.getBillNO(), billDetailIdDto.getBillDetailNO(), splitAomunt1, billDetailIdDto.getPrice(), amt1);
                BillDetailIdDto splitBillDetailId2 = new BillDetailIdDto(billDetailIdDto.getBillNO(), billDetailIdDto.getBillDetailNO(), splitAomunt2, billDetailIdDto.getPrice(), amt2);
                productDetailIdSet.add(splitBillDetailId1);
                it.remove();
                orginDetailIdSet.add(splitBillDetailId2);
                break;
            }
            if (sumAmount.compareTo(productDto.getAmountsByTax()) == 0) {
                productDetailIdSet.add(billDetailIdDto);
                it.remove();
                break;
            }
            productDetailIdSet.add(billDetailIdDto);
            it.remove();
        }
        productDto.setDetailIdSet(productDetailIdSet);
        newProductDto.setDetailIdSet(orginDetailIdSet);
        if (orginDisDto != null) {
            Set<BillDetailIdDto> orginDisDetailIdSet = orginDisDto.getDetailIdSet();
            Iterator<BillDetailIdDto> disIt = orginDisDetailIdSet.iterator();
            LinkedHashSet<BillDetailIdDto> disProductDetailIdSet = new LinkedHashSet<BillDetailIdDto>();
            BigDecimal sumDisAmount = BigDecimal.ZERO;
            while (disIt.hasNext()) {
                BillDetailIdDto billDetailIdDto = disIt.next();
                if ((sumDisAmount = sumDisAmount.add(billDetailIdDto.getAmounts())).compareTo(disDto.getAmountsByTax()) < 0) {
                    BigDecimal splitAomunt2 = sumDisAmount.subtract(disDto.getAmountsByTax());
                    BigDecimal splitAomunt1 = billDetailIdDto.getAmounts().subtract(splitAomunt2);
                    BillDetailIdDto splitBillDetailId1 = new BillDetailIdDto(billDetailIdDto.getBillNO(), billDetailIdDto.getBillDetailNO(), splitAomunt1, billDetailIdDto.getPrice(), billDetailIdDto.getAmts());
                    BillDetailIdDto splitBillDetailId2 = new BillDetailIdDto(billDetailIdDto.getBillNO(), billDetailIdDto.getBillDetailNO(), splitAomunt2, billDetailIdDto.getPrice(), billDetailIdDto.getAmts());
                    disProductDetailIdSet.add(splitBillDetailId1);
                    disIt.remove();
                    orginDisDetailIdSet.add(splitBillDetailId2);
                    break;
                }
                if (sumDisAmount.compareTo(disDto.getAmountsByTax()) == 0) {
                    disProductDetailIdSet.add(billDetailIdDto);
                    disIt.remove();
                    break;
                }
                disProductDetailIdSet.add(billDetailIdDto);
                disIt.remove();
            }
            disDto.setDetailIdSet(disProductDetailIdSet);
            newdisDto.setDetailIdSet(orginDisDetailIdSet);
        }
    }
}

