/*
 * Decompiled with CFR 0.152.
 */
package com.szhtxx.etcloud.smser.service;

import com.szhtxx.etcloud.smser.dto.BillDealResultDto;
import com.szhtxx.etcloud.smser.dto.BillDetailDto;
import com.szhtxx.etcloud.smser.dto.BillSubjectDto;
import com.szhtxx.etcloud.smser.dto.SmsRequestDto;
import com.szhtxx.etcloud.smser.dto.SmsResultDto;
import com.szhtxx.etcloud.smser.enums.EnumType;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class MultiMergeCoreService {
    public static void sortBillSubjects(List<BillSubjectDto> billSList) {
        if (CollectionUtils.isNotEmpty(billSList)) {
            Collections.sort(billSList, new Comparator<BillSubjectDto>(){

                @Override
                public int compare(BillSubjectDto o1, BillSubjectDto o2) {
                    return o1.getSortField().compareTo(o2.getSortField());
                }
            });
        }
    }

    public static void checkMerge(SmsRequestDto requestDto, SmsResultDto resultDto) {
        BigDecimal zeroBd = BigDecimal.ZERO;
        List<BillSubjectDto> billSList = requestDto.getBillSList();
        int i = 0;
        while (i < billSList.size()) {
            BillDealResultDto dealResultDto;
            BillSubjectDto billSubjectDto = billSList.get(i);
            String billNo = billSubjectDto.getBillNO();
            int invKind = billSubjectDto.getInvKind();
            if (StringUtils.isEmpty((CharSequence)billNo) || StringUtils.isEmpty((CharSequence)billNo.trim())) {
                dealResultDto = MultiMergeCoreService.getBDR(billNo, false, "\u4f20\u5165\u5355\u636e\u7f16\u53f7\u4e3a\u7a7a");
                resultDto.getBdrList().add(dealResultDto);
                billSubjectDto.setCheckPassed(false);
            } else if (CollectionUtils.isEmpty(billSubjectDto.getBillDList())) {
                dealResultDto = MultiMergeCoreService.getBDR(billNo, false, "\u4f20\u5165\u5355\u636e\u660e\u7ec6\u4e3a\u7a7a");
                resultDto.getBdrList().add(dealResultDto);
                billSubjectDto.setCheckPassed(false);
            } else if (EnumType.InvKindEnum.SPECIAL.getValue() == invKind && requestDto.getSiAmt().compareTo(zeroBd) <= 0) {
                dealResultDto = MultiMergeCoreService.getBDR(billNo, false, "\u4f20\u5165\u7eb8\u8d28\u4e13\u7528\u53d1\u7968\u62c6\u5206\u9650\u989d\u4e3a0");
                resultDto.getBdrList().add(dealResultDto);
                billSubjectDto.setCheckPassed(false);
            } else if (EnumType.InvKindEnum.NORMAL.getValue() == invKind && requestDto.getCiAmt().compareTo(zeroBd) <= 0) {
                dealResultDto = MultiMergeCoreService.getBDR(billNo, false, "\u4f20\u5165\u7eb8\u8d28\u666e\u901a\u53d1\u7968\u62c6\u5206\u9650\u989d\u4e3a0");
                resultDto.getBdrList().add(dealResultDto);
                billSubjectDto.setCheckPassed(false);
            } else if (EnumType.InvKindEnum.EINV.getValue() == invKind && requestDto.getEiAmt().compareTo(zeroBd) <= 0) {
                dealResultDto = MultiMergeCoreService.getBDR(billNo, false, "\u4f20\u5165\u7535\u5b50\u666e\u901a\u53d1\u7968\u62c6\u5206\u9650\u989d\u4e3a0");
                resultDto.getBdrList().add(dealResultDto);
                billSubjectDto.setCheckPassed(false);
            } else if (EnumType.InvKindEnum.ESINV.getValue() == invKind && requestDto.getEsiAmt().compareTo(zeroBd) <= 0) {
                dealResultDto = MultiMergeCoreService.getBDR(billNo, false, "\u4f20\u5165\u7535\u5b50\u4e13\u7528\u53d1\u7968\u62c6\u5206\u9650\u989d\u4e3a0");
                resultDto.getBdrList().add(dealResultDto);
                billSubjectDto.setCheckPassed(false);
            } else if (EnumType.InvKindEnum.ROLL.getValue() == invKind && requestDto.getVlAmt().compareTo(zeroBd) <= 0) {
                dealResultDto = MultiMergeCoreService.getBDR(billNo, false, "\u4f20\u5165\u5377\u7968\u7968\u62c6\u5206\u9650\u989d\u4e3a0");
                resultDto.getBdrList().add(dealResultDto);
                billSubjectDto.setCheckPassed(false);
            } else if (EnumType.InvKindEnum.notExisted(invKind).booleanValue()) {
                dealResultDto = MultiMergeCoreService.getBDR(billNo, false, "\u4f20\u5165\u7684\u53d1\u7968\u79cd\u7c7b:" + invKind + "\u4e0d\u6b63\u786e\u3002");
                resultDto.getBdrList().add(dealResultDto);
                billSubjectDto.setCheckPassed(false);
            } else if (!MultiMergeCoreService.includeTaxIsSame(billSubjectDto, resultDto).booleanValue()) {
                dealResultDto = MultiMergeCoreService.getBDR(billNo, false, "\u5355\u636e\u7684\u542b\u7a0e\u6807\u8bc6\u8981\u8ddf\u5355\u636e\u660e\u7ec6\u542b\u7a0e\u6807\u8bc6\u4fdd\u6301\u4e00\u81f4");
                resultDto.getBdrList().add(dealResultDto);
                billSubjectDto.setCheckPassed(false);
            }
            ++i;
        }
    }

    public static BillDealResultDto getBDR(String billNO, boolean success, String errorMsg) {
        BillDealResultDto bdr = new BillDealResultDto();
        bdr.setBillNO(billNO);
        bdr.setSuccess(success);
        bdr.setErrorMsg(errorMsg);
        return bdr;
    }

    private static Boolean includeTaxIsSame(BillSubjectDto billSubjectDto, SmsResultDto resultDto) {
        Boolean flag = true;
        List<BillDetailDto> billDetailDtos = billSubjectDto.getBillDList();
        int includeTaxTmp = billSubjectDto.getIncludeTax();
        if (CollectionUtils.isNotEmpty(billDetailDtos)) {
            for (BillDetailDto detailDto : billDetailDtos) {
                int includeTax = detailDto.getIncludeTax();
                if (includeTaxTmp == includeTax) continue;
                flag = false;
                break;
            }
        }
        return flag;
    }
}

