/*
 * Decompiled with CFR 0.152.
 */
package com.szhtxx.etcloud.smser.service;

import com.szhtxx.etcloud.smser.dto.BillDealResultDto;
import com.szhtxx.etcloud.smser.dto.BillDetailDto;
import com.szhtxx.etcloud.smser.dto.BillSubjectDto;
import com.szhtxx.etcloud.smser.dto.SmruleConfigDto;
import com.szhtxx.etcloud.smser.exception.EtcRuleException;
import com.szhtxx.etcloud.smser.service.GoodsMergeService;
import com.szhtxx.etcloud.smser.utils.BigDecimalUtils;
import com.szhtxx.etcloud.smser.utils.CalTaxUtils;
import java.math.BigDecimal;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NegativeRowService {
    private static final Logger LOG = LoggerFactory.getLogger(NegativeRowService.class);

    public static BillDealResultDto deal(BillSubjectDto billSubjectDto, SmruleConfigDto smruleConfig) {
        NegativeRowService.merge(billSubjectDto, smruleConfig);
        return NegativeRowService.doAgainst(billSubjectDto, smruleConfig);
    }

    public static BillDealResultDto merge(BillSubjectDto billSubjectDto, SmruleConfigDto smruleConfig) {
        BillDealResultDto resultDto = new BillDealResultDto();
        resultDto.setBillNO(billSubjectDto.getBillNO());
        resultDto.setSuccess(true);
        List<BillDetailDto> detailList = billSubjectDto.getBillDList();
        if (smruleConfig.getAgainstTyp() == 0) {
            return resultDto;
        }
        HashSet<String> hasDealNegSet = new HashSet<String>();
        int negIndex = 0;
        while (negIndex < detailList.size()) {
            BillDetailDto negDetail = detailList.get(negIndex);
            if (negDetail.getAmounts().compareTo(BigDecimal.ZERO) <= 0 && negDetail.getLineProperty() != 4 && !hasDealNegSet.contains(negDetail.getBillDetailNO())) {
                while (true) {
                    Optional<BillDetailDto> maxMoneyDetailOptional;
                    BillDetailDto maxMoneyDetail;
                    BillDetailDto billDetailDto = maxMoneyDetail = (maxMoneyDetailOptional = detailList.stream().filter(billDetailDto2 -> NegativeRowService.isFitMergeCondition(negDetail, billDetailDto2)).max(Comparator.comparing(BillDetailDto::getAmountsByTax))).isPresent() ? maxMoneyDetailOptional.get() : null;
                    if (maxMoneyDetail == null) break;
                    int maxMoneyIndex = detailList.indexOf(maxMoneyDetail);
                    BillDetailDto discountDetail = new BillDetailDto();
                    if (maxMoneyIndex < detailList.size() - 1 && detailList.get(maxMoneyIndex + 1).getLineProperty() == 4) {
                        discountDetail = detailList.get(maxMoneyIndex + 1);
                    }
                    BigDecimal actualMoney = BigDecimalUtils.add(maxMoneyDetail.getAmountsByTax(), discountDetail.getAmountsByTax(), BigDecimal.ZERO);
                    BigDecimal actualTax = BigDecimalUtils.add(maxMoneyDetail.getTaxAmt(), discountDetail.getTaxAmt(), BigDecimal.ZERO);
                    BigDecimal remainMoney = actualMoney.add(negDetail.getAmountsByTax());
                    BigDecimal remainTax = actualTax.add(negDetail.getTaxAmt());
                    BigDecimal remainAtms = BigDecimalUtils.add(negDetail.getAmts(), maxMoneyDetail.getAmts(), BigDecimal.ZERO);
                    if (remainMoney.compareTo(BigDecimal.ZERO) > 0) {
                        NegativeRowService.dealRemaimMoneyGTZero(smruleConfig, detailList, negDetail, maxMoneyDetail, remainAtms);
                        break;
                    }
                    if (remainMoney.compareTo(BigDecimal.ZERO) == 0) {
                        detailList.remove(negDetail);
                        detailList.remove(maxMoneyDetail);
                        detailList.remove(discountDetail);
                        if (detailList.isEmpty()) break;
                        detailList.get(0).addDetailId(negDetail.getDetailIdSet());
                        detailList.get(0).addDetailId(maxMoneyDetail.getDetailIdSet());
                        detailList.get(0).addDetailId(discountDetail.getDetailIdSet());
                        break;
                    }
                    detailList.remove(maxMoneyDetail);
                    detailList.remove(discountDetail);
                    NegativeRowService.updateDetailData(negDetail, remainAtms, remainMoney, remainTax);
                    negDetail.addDetailId(maxMoneyDetail.getDetailIdSet());
                    negDetail.addDetailId(discountDetail.getDetailIdSet());
                }
                negIndex = -1;
                hasDealNegSet.add(negDetail.getBillDetailNO());
            }
            ++negIndex;
        }
        return resultDto;
    }

    public static void dealRemaimMoneyGTZero(SmruleConfigDto smruleConfig, List<BillDetailDto> detailList, BillDetailDto negDetail, BillDetailDto maxMoneyDetail, BigDecimal remainAtms) {
        BigDecimal calTax;
        boolean taxErrorFlag;
        BigDecimal goodsRemainMoney = maxMoneyDetail.getAmountsByTax().add(negDetail.getAmountsByTax());
        BigDecimal goodsRemainTax = maxMoneyDetail.getTaxAmt().add(negDetail.getTaxAmt());
        boolean bl = taxErrorFlag = goodsRemainTax.subtract(calTax = CalTaxUtils.calTax(maxMoneyDetail.getIncludeTax(), goodsRemainMoney, negDetail.getTaxRate())).abs().compareTo(smruleConfig.getLineTaxAmtErr()) > 0;
        if (taxErrorFlag && smruleConfig.getTotalTaxamtCount() != 1) {
            return;
        }
        if (taxErrorFlag) {
            goodsRemainTax = calTax;
        }
        detailList.remove(negDetail);
        NegativeRowService.updateDetailData(maxMoneyDetail, remainAtms, goodsRemainMoney, goodsRemainTax);
        GoodsMergeService.dealAmtsAndPrice(maxMoneyDetail, smruleConfig, 1);
        NegativeRowService.remarkDeal(negDetail, smruleConfig, maxMoneyDetail);
    }

    public static boolean isFitMergeCondition(BillDetailDto negDetail, BillDetailDto posDetail) {
        if (posDetail.getAmountsByTax().compareTo(BigDecimal.ZERO) <= 0) {
            return false;
        }
        return com.szhtxx.etcloud.smser.utils.StringUtils.equalIgnoreNull(negDetail.getGoodsName(), posDetail.getGoodsName()) && com.szhtxx.etcloud.smser.utils.StringUtils.equalIgnoreNull(negDetail.getGoodsModel(), posDetail.getGoodsModel()) && com.szhtxx.etcloud.smser.utils.StringUtils.equalIgnoreNull(negDetail.getGoodsUnit(), posDetail.getGoodsUnit()) && BigDecimalUtils.equals(negDetail.getPriceByTaxFlag(), posDetail.getPriceByTaxFlag()) && BigDecimalUtils.equals(negDetail.getTaxRate(), posDetail.getTaxRate());
    }

    public static void updateDetailData(BillDetailDto posDetail, BigDecimal remainAtms, BigDecimal goodsRemainMoney, BigDecimal goodsRemainTax) {
        posDetail.setTaxAmt(goodsRemainTax);
        if (remainAtms != null && remainAtms.compareTo(BigDecimal.ZERO) != 0) {
            posDetail.setAmts(remainAtms);
        }
        if (posDetail.getIncludeTax() == 1) {
            posDetail.setAmountsIncTax(goodsRemainMoney);
            posDetail.setOtherMoney();
        } else {
            posDetail.setAmounts(goodsRemainMoney);
            posDetail.setOtherMoney();
        }
    }

    public static BillDealResultDto doAgainst(BillSubjectDto billSubjectDto, SmruleConfigDto smruleConfig) {
        String billNO = billSubjectDto.getBillNO();
        List<BillDetailDto> detailList = billSubjectDto.getBillDList();
        BillDealResultDto resultDto = new BillDealResultDto();
        resultDto.setBillNO(billNO);
        resultDto.setSuccess(true);
        boolean noPosDetailFlag = false;
        int negIndex = 0;
        while (negIndex < detailList.size()) {
            BillDetailDto detail = detailList.get(negIndex);
            if (detail.getAmounts().compareTo(BigDecimal.ZERO) < 0 && detail.getLineProperty() != 4) {
                noPosDetailFlag = NegativeRowService.doAgainst(detail, billSubjectDto, 0, smruleConfig);
                if (noPosDetailFlag) {
                    throw new EtcRuleException("\u8d1f\u6570\u884c\u51b2\u62b5\u65f6\u5fc5\u987b\u7a0e\u7387\u4e00\u81f4\u624d\u5141\u8bb8\u51b2\u62b5\u3002\u4e0e\u8d1f\u6570\u884c\u7a0e\u7387\u76f8\u540c\u7684\u5546\u54c1\u660e\u7ec6\u91d1\u989d\u4e0d\u591f\u51b2\u62b5\uff0c\u8bf7\u8c03\u6574\u51b2\u62b5\u91d1\u989d");
                }
                negIndex = -1;
            }
            ++negIndex;
        }
        return resultDto;
    }

    private static boolean doAgainst(BillDetailDto negDetail, BillSubjectDto billSubjectDto, int againstRule, SmruleConfigDto smruleConfig) {
        boolean taxIncludeFlag = negDetail.getIncludeTax() != 0;
        BigDecimal remainAmount = taxIncludeFlag ? negDetail.getAmountsIncTax() : negDetail.getAmounts();
        List<BillDetailDto> detailList = billSubjectDto.getBillDList();
        int fitConditionMaxMoneyIndex = -1;
        int posIndex = 0;
        while (posIndex < detailList.size()) {
            BigDecimal negDetailAmount = remainAmount;
            BillDetailDto posDetail = detailList.get(posIndex);
            boolean doAgainstFlag = NegativeRowService.isAgainstCondition(posDetail, negDetail, againstRule);
            if (doAgainstFlag) {
                BigDecimal nowMoney = detailList.get(posIndex).getAmountsByTax();
                if (fitConditionMaxMoneyIndex == -1 || nowMoney.compareTo(detailList.get(fitConditionMaxMoneyIndex).getAmountsByTax()) > 0) {
                    fitConditionMaxMoneyIndex = posIndex;
                }
            }
            if (posIndex >= detailList.size() - 1) {
                if (posIndex == detailList.size() - 1 && fitConditionMaxMoneyIndex == -1) break;
                posIndex = fitConditionMaxMoneyIndex;
                posDetail = detailList.get(posIndex);
                BigDecimal disDetailAmount = BigDecimal.ZERO;
                BillDetailDto disDetail = null;
                if (posIndex + 1 < detailList.size() && detailList.get(posIndex + 1).getLineProperty() == 4) {
                    disDetail = detailList.get(posIndex + 1);
                    disDetailAmount = taxIncludeFlag ? disDetail.getAmountsIncTax() : disDetail.getAmounts();
                }
                BigDecimal posDetailAmount = taxIncludeFlag ? posDetail.getAmountsIncTax() : posDetail.getAmounts();
                remainAmount = negDetailAmount.add(posDetailAmount).add(disDetailAmount);
                LOG.debug("\u51b2\u62b5\uff1a\u6b63\u5546\u54c1\u884c\u3010{}\u3011\uff0c\u8d1f\u6570\u884c\u3010{}\u3011\uff0c\u51b2\u62b5\u89c4\u5219\u3010{}\u3011\uff0c\u51b2\u62b5\u540e\u91d1\u989d\u3010{}\u3011", new Object[]{posDetail.getBillDetailNO(), negDetail.getBillDetailNO(), againstRule, remainAmount});
                if (remainAmount.compareTo(BigDecimal.ZERO) <= 0) {
                    String billNo;
                    Set<String> negBillNoSet = billSubjectDto.getNegBillNoSet();
                    if (CollectionUtils.isEmpty(negBillNoSet)) {
                        negBillNoSet = new HashSet<String>(2);
                    }
                    if (!negBillNoSet.contains(billNo = posDetail.getBillNO())) {
                        negBillNoSet.add(billNo);
                    }
                    billSubjectDto.setNegBillNoSet(negBillNoSet);
                    detailList.remove(posDetail);
                    negDetail.addDetailId(posDetail.getDetailIdSet());
                    --posIndex;
                    if (disDetail != null) {
                        detailList.remove(disDetail);
                        negDetail.addDetailId(disDetail.getDetailIdSet());
                    }
                    if (remainAmount.compareTo(BigDecimal.ZERO) == 0) {
                        LOG.debug("\u6b63\u5546\u54c1\u884c\u5168\u90e8\u51b2\u62b5\uff1a\u79fb\u9664\u8d1f\u6570\u884c\u3010{}\u3011,break", (Object)negDetail.getBillDetailNO());
                        detailList.remove(negDetail);
                        detailList.get(0).addDetailId(negDetail.getDetailIdSet());
                        break;
                    }
                    if (taxIncludeFlag) {
                        negDetail.setAmountsIncTax(remainAmount);
                    } else {
                        negDetail.setAmounts(remainAmount);
                    }
                    LOG.debug("\u6b63\u5546\u54c1\u884c\u5168\u90e8\u51b2\u62b5\uff1a\u8bbe\u7f6e\u8d1f\u6570\u884c\u3010{}\u3011\u91d1\u989d\u3010{}\u3011,\u79fb\u9664\u5546\u54c1\u884c\u4ee5\u53ca\u5bf9\u5e94\u7684\u6298\u6263\u884c", (Object)negDetail.getBillDetailNO(), (Object)remainAmount);
                    fitConditionMaxMoneyIndex = -1;
                    posIndex = -1;
                } else {
                    posDetailAmount = posDetailAmount.add(negDetailAmount);
                    BigDecimal calTax = CalTaxUtils.calTax(posDetail.getIncludeTax(), posDetailAmount, posDetail.getTaxRate());
                    posDetail.setTaxAmt(calTax);
                    if (taxIncludeFlag) {
                        posDetail.setAmountsIncTax(posDetailAmount);
                        posDetail.setAmounts(posDetail.getAmountsIncTax().subtract(posDetail.getTaxAmt()));
                    } else {
                        posDetail.setAmounts(posDetailAmount);
                        posDetail.setAmountsIncTax(posDetail.getAmounts().add(posDetail.getTaxAmt()));
                    }
                    LOG.debug("\u6b63\u5546\u54c1\u884c\u90e8\u5206\u51b2\u62b5: \u8bbe\u7f6e\u5546\u54c1\u884c\u3010{}\u3011\uff0c\u91d1\u989d\u3010{}\u3011\uff0c\u7a0e\u989d\u3010{}\u3011\uff0c\u4ef7\u7a0e\u5408\u8ba1\u3010{}\u3011", new Object[]{posDetail.getBillDetailNO(), posDetail.getAmounts(), posDetail.getTaxAmt(), posDetail.getAmountsIncTax()});
                    GoodsMergeService.dealAmtsAndPrice(posDetail, smruleConfig, smruleConfig.getSplitListType());
                    NegativeRowService.remarkDeal(negDetail, smruleConfig, posDetail);
                    LOG.debug("\u6b63\u5546\u54c1\u884c\u90e8\u5206\u51b2\u62b5: \u79fb\u9664\u8d1f\u6570\u884c\u3010{}\u3011\uff0cbreak", (Object)negDetail.getBillDetailNO());
                    detailList.remove(negDetail);
                    break;
                }
            }
            ++posIndex;
        }
        if (remainAmount.compareTo(BigDecimal.ZERO) >= 0) {
            return false;
        }
        if (againstRule == 2) {
            LOG.debug("\u4efb\u610f\u51b2\u62b5\u4e0b\uff0c\u8fd8\u672a\u51b2\u62b5\u5b8c\uff0c\u5219\u65e0\u6b63\u5546\u54c1\u884c\u4e86");
            BigDecimal calTax = CalTaxUtils.calTax(negDetail.getIncludeTax(), remainAmount, negDetail.getTaxRate());
            if (calTax.subtract(negDetail.getTaxAmt()).abs().compareTo(smruleConfig.getLineTaxAmtErr()) > 0) {
                negDetail.setTaxAmt(calTax);
            }
            if (taxIncludeFlag) {
                negDetail.setAmounts(negDetail.getAmountsIncTax().subtract(negDetail.getTaxAmt()));
            } else {
                negDetail.setAmountsIncTax(negDetail.getAmounts().add(negDetail.getTaxAmt()));
            }
            return true;
        }
        return NegativeRowService.doAgainst(negDetail, billSubjectDto, againstRule + 1, smruleConfig);
    }

    public static void remarkDeal(BillDetailDto negDetail, SmruleConfigDto smruleConfig, BillDetailDto posDetail) {
        String mergeRemark = posDetail.getLineNote();
        if (StringUtils.isNotEmpty((CharSequence)negDetail.getLineNote())) {
            mergeRemark = StringUtils.isNotEmpty((CharSequence)mergeRemark) && (smruleConfig.isMccRepeat() || !mergeRemark.equals(negDetail.getLineNote())) ? String.valueOf(mergeRemark) + smruleConfig.getMccNoteStr() + negDetail.getLineNote() : negDetail.getLineNote();
        }
        posDetail.setLineNote(mergeRemark);
        posDetail.addDetailId(negDetail.getDetailIdSet());
        LOG.debug("\u8bbe\u7f6e\u6b63\u5546\u54c1\u884c\u3010{}\u3011\u5907\u6ce8\u3010{}\u3011", (Object)posDetail.getBillDetailNO(), (Object)mergeRemark);
    }

    private static boolean isAgainstCondition(BillDetailDto posDetail, BillDetailDto negDetail, int againstTyp) {
        boolean doAgainstFlag = false;
        if (posDetail.getAmounts().compareTo(BigDecimal.ZERO) <= 0) {
            return doAgainstFlag;
        }
        if (posDetail.getTaxRate().compareTo(negDetail.getTaxRate()) != 0) {
            return doAgainstFlag;
        }
        if (againstTyp == 0) {
            if (com.szhtxx.etcloud.smser.utils.StringUtils.equalIgnoreNull(posDetail.getGoodsName(), negDetail.getGoodsName()) && com.szhtxx.etcloud.smser.utils.StringUtils.equalIgnoreNull(posDetail.getGoodsModel(), negDetail.getGoodsModel()) && com.szhtxx.etcloud.smser.utils.StringUtils.equalIgnoreNull(posDetail.getGoodsUnit(), negDetail.getGoodsUnit())) {
                doAgainstFlag = true;
            }
        } else if (againstTyp == 1) {
            if (com.szhtxx.etcloud.smser.utils.StringUtils.equalIgnoreNull(posDetail.getGoodsName(), negDetail.getGoodsName())) {
                doAgainstFlag = true;
            }
        } else {
            doAgainstFlag = true;
        }
        return doAgainstFlag;
    }
}

