/*
 * Decompiled with CFR 0.152.
 */
package com.szhtxx.etcloud.smser.utils;

import java.lang.management.ManagementFactory;
import java.net.NetworkInterface;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.security.SecureRandom;
import java.util.Enumeration;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanId {
    private static final Logger log = LoggerFactory.getLogger(BeanId.class);
    private static final int LOW_ORDER_THREE_BYTES = 0xFFFFFF;
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final int MAC;
    private static final short PROC;
    private static final AtomicInteger NEXT_COUNTER;
    private final int timestamp;
    private final int machineIdentifier;
    private final short processIdentifier;
    private final int counter;

    static {
        NEXT_COUNTER = new AtomicInteger(new SecureRandom().nextInt());
        try {
            MAC = BeanId.createMachineIdentifier();
            PROC = BeanId.createProcessIdentifier();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public BeanId() {
        this.timestamp = (int)(System.currentTimeMillis() / 1000L);
        this.machineIdentifier = MAC;
        this.processIdentifier = PROC;
        this.counter = NEXT_COUNTER.getAndIncrement();
    }

    public BeanId(String id) {
        ByteBuffer buffer = ByteBuffer.wrap(BeanId.parseHexString(id));
        this.timestamp = BeanId.makeInt(buffer.get(), buffer.get(), buffer.get(), buffer.get());
        this.machineIdentifier = BeanId.makeInt((byte)0, buffer.get(), buffer.get(), buffer.get());
        this.processIdentifier = (short)BeanId.makeInt((byte)0, (byte)0, buffer.get(), buffer.get());
        this.counter = BeanId.makeInt((byte)0, buffer.get(), buffer.get(), buffer.get());
    }

    public void putToByteBuffer(ByteBuffer buffer) {
        buffer.put(BeanId.int3(this.timestamp));
        buffer.put(BeanId.int2(this.timestamp));
        buffer.put(BeanId.int1(this.timestamp));
        buffer.put(BeanId.int0(this.timestamp));
        buffer.put(BeanId.int2(this.machineIdentifier));
        buffer.put(BeanId.int1(this.machineIdentifier));
        buffer.put(BeanId.int0(this.machineIdentifier));
        buffer.put(BeanId.short1(this.processIdentifier));
        buffer.put(BeanId.short0(this.processIdentifier));
        buffer.put(BeanId.int2(this.counter));
        buffer.put(BeanId.int1(this.counter));
        buffer.put(BeanId.int0(this.counter));
    }

    public int getTimestamp() {
        return this.timestamp;
    }

    public int getMachineIdentifier() {
        return this.machineIdentifier;
    }

    public short getProcessIdentifier() {
        return this.processIdentifier;
    }

    public int getCounter() {
        return this.counter;
    }

    public String toString() {
        return this.toHexString();
    }

    public String toHexString() {
        char[] chars = new char[24];
        int i = 0;
        ByteBuffer buffer = ByteBuffer.allocate(12);
        this.putToByteBuffer(buffer);
        byte[] byArray = buffer.array();
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            chars[i++] = HEX_CHARS[b >> 4 & 0xF];
            chars[i++] = HEX_CHARS[b & 0xF];
            ++n2;
        }
        return new String(chars);
    }

    public static String generateUUId() {
        return new BeanId().toString();
    }

    private static int createMachineIdentifier() {
        int machinePiece;
        try {
            StringBuilder sb = new StringBuilder();
            Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
            while (e.hasMoreElements()) {
                NetworkInterface ni = e.nextElement();
                sb.append(ni.toString());
                byte[] mac = ni.getHardwareAddress();
                if (mac == null) continue;
                ByteBuffer bb = ByteBuffer.wrap(mac);
                try {
                    sb.append(bb.getChar());
                    sb.append(bb.getChar());
                    sb.append(bb.getChar());
                }
                catch (BufferUnderflowException bufferUnderflowException) {
                    // empty catch block
                }
            }
            machinePiece = sb.toString().hashCode();
        }
        catch (Throwable t) {
            machinePiece = new SecureRandom().nextInt();
            log.warn("Failed to get machine identifier from network interface, using random number instead", t);
        }
        return machinePiece &= 0xFFFFFF;
    }

    private static short createProcessIdentifier() {
        short processId;
        try {
            String processName = ManagementFactory.getRuntimeMXBean().getName();
            processId = processName.contains("@") ? (short)Integer.parseInt(processName.substring(0, processName.indexOf(64))) : (short)ManagementFactory.getRuntimeMXBean().getName().hashCode();
        }
        catch (Throwable t) {
            processId = (short)new SecureRandom().nextInt();
            log.warn("Failed to get stub identifier from JMX, using random number instead", t);
        }
        return processId;
    }

    private static byte[] parseHexString(String s) {
        if (!BeanId.isValid(s)) {
            throw new IllegalArgumentException("invalid hexadecimal representation of an ObjectId: [" + s + "]");
        }
        byte[] b = new byte[12];
        int i = 0;
        while (i < b.length) {
            b[i] = (byte)Integer.parseInt(s.substring(i * 2, i * 2 + 2), 16);
            ++i;
        }
        return b;
    }

    public static boolean isValid(String hexString) {
        if (hexString == null) {
            throw new IllegalArgumentException();
        }
        int len = hexString.length();
        if (len != 24) {
            return false;
        }
        int i = 0;
        while (i < len) {
            char c = hexString.charAt(i);
            if (!(c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F')) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static int makeInt(byte b3, byte b2, byte b1, byte b0) {
        return b3 << 24 | (b2 & 0xFF) << 16 | (b1 & 0xFF) << 8 | b0 & 0xFF;
    }

    private static byte int3(int x) {
        return (byte)(x >> 24);
    }

    private static byte int2(int x) {
        return (byte)(x >> 16);
    }

    private static byte int1(int x) {
        return (byte)(x >> 8);
    }

    private static byte int0(int x) {
        return (byte)x;
    }

    private static byte short1(short x) {
        return (byte)(x >> 8);
    }

    private static byte short0(short x) {
        return (byte)x;
    }

    public static void main(String[] args) throws Exception {
        int i = 0;
        while (i < 100) {
            Integer s = BeanId.timestamp10();
            Thread.sleep(1000L);
            ++i;
        }
    }

    public static Integer timestamp10() {
        Long timestamp = System.currentTimeMillis() / 1000L;
        return timestamp.intValue();
    }
}

