/*
 * Decompiled with CFR 0.152.
 */
package com.szhtxx.etcloud.smser.utils;

import com.szhtxx.etcloud.smser.exception.EtcRuleException;
import java.math.BigDecimal;

public class BigDecimalUtils {
    public static boolean equals(BigDecimal b1, BigDecimal b2) {
        if (b1 == null && b2 == null) {
            return true;
        }
        return b1 != null && b2 != null && b1.compareTo(b2) == 0;
    }

    public static BigDecimal add(BigDecimal b1, BigDecimal b2, BigDecimal defaultNull) {
        if (b1 == null) {
            if (defaultNull == null) {
                return null;
            }
            b1 = defaultNull;
        }
        if (b2 == null) {
            if (defaultNull == null) {
                return null;
            }
            b2 = defaultNull;
        }
        return b1.add(b2);
    }

    public static BigDecimal recursionDivision(BigDecimal dividend, BigDecimal divisor, int digit, BigDecimal errorValue) {
        BigDecimal value = dividend.divide(divisor, digit, 4);
        BigDecimal calcErrorValue = dividend.subtract(divisor.multiply(value)).abs();
        if (calcErrorValue.compareTo(errorValue) > 0) {
            return BigDecimalUtils.recursionDivision(dividend, divisor, digit + 1, errorValue);
        }
        return value;
    }

    public static BigDecimal recursionDivision(BigDecimal dividend, BigDecimal divisor, int digit, BigDecimal compareValue, BigDecimal errorValue) {
        if (digit > 100) {
            throw new EtcRuleException("\u53cd\u7b97\u65f6\u5c0f\u6570\u4f4d\u5df2\u8d85100\u4f4d");
        }
        BigDecimal value = dividend.divide(divisor, digit, 4);
        BigDecimal calcErrorValue = compareValue.subtract(divisor.multiply(value)).abs();
        if (calcErrorValue.compareTo(errorValue) > 0) {
            return BigDecimalUtils.recursionDivision(dividend, divisor, digit + 1, compareValue, errorValue);
        }
        return value;
    }
}

