/*
 * Decompiled with CFR 0.152.
 */
package com.szhtxx.etcloud.smser.utils;

import com.szhtxx.etcloud.smser.constant.SmruleConfConstant;
import com.szhtxx.etcloud.smser.dto.BillDetailDto;
import com.szhtxx.etcloud.smser.dto.BillSubjectDto;
import com.szhtxx.etcloud.smser.dto.SmruleConfigDto;
import com.szhtxx.etcloud.smser.enums.EnumType;
import com.szhtxx.etcloud.smser.exception.EtcRuleException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class ComUtil {
    public static Map<String, Integer> getDigitByRuleConfig(SmruleConfigDto configDto) {
        HashMap<String, Integer> retMap = new HashMap<String, Integer>(1);
        Integer amtNumberType = configDto.getAmtNumberType();
        Integer amtNumber = configDto.getAmtNumber();
        Integer priceNumberType = configDto.getPriceNumberType();
        Integer priceNumber = configDto.getPriceNumber();
        int digit = SmruleConfConstant.ONE;
        if (EnumType.NumberTypeEnum.ZERO.getValue().intValue() == priceNumberType.intValue()) {
            digit = 1;
        } else if (EnumType.NumberTypeEnum.ONE.getValue().intValue() == priceNumberType.intValue()) {
            digit = 0;
        } else if (EnumType.NumberTypeEnum.TWO.getValue().intValue() == priceNumberType.intValue()) {
            digit = priceNumber;
        }
        retMap.put("priceNumber", digit);
        if (EnumType.NumberTypeEnum.ZERO.getValue().intValue() == amtNumberType.intValue()) {
            digit = 1;
        } else if (EnumType.NumberTypeEnum.ONE.getValue().intValue() == amtNumberType.intValue()) {
            digit = 0;
        } else if (EnumType.NumberTypeEnum.TWO.getValue().intValue() == amtNumberType.intValue()) {
            digit = amtNumber;
        }
        retMap.put("amtNumber", digit);
        return retMap;
    }

    public static Boolean isDisLine(BillDetailDto detailDto) {
        Integer lineProperty = detailDto.getLineProperty();
        BigDecimal amounts = detailDto.getAmounts();
        Boolean isDisline = false;
        if (EnumType.LinePropertyEnum.FOUR.getValue().compareTo(lineProperty) == 0 && amounts.compareTo(BigDecimal.ZERO) < 0) {
            isDisline = true;
        }
        return isDisline;
    }

    public static int findObjIndexInList(List<BillDetailDto> billDList, BillDetailDto detailDto) {
        String msg = "";
        String billNoP = detailDto.getBillNO();
        String billDetailNoP = detailDto.getBillDetailNO();
        if (StringUtils.isEmpty((CharSequence)billDetailNoP)) {
            msg = String.format("\u5355\u636e\u7f16\u53f7[%s] \u5355\u636e\u660e\u7ec6\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a", billNoP);
            throw new EtcRuleException(msg);
        }
        if (CollectionUtils.isNotEmpty(billDList)) {
            int i = 0;
            for (BillDetailDto dto : billDList) {
                String billNo = dto.getBillNO();
                String billDetailNo = dto.getBillDetailNO();
                if (billNo.equals(billNoP) && billDetailNo.equals(billDetailNoP)) break;
                ++i;
            }
            return i;
        }
        return -1;
    }

    public static List<BillDetailDto> bubbleSort(BillSubjectDto subjectDto) {
        List<BillDetailDto> list = subjectDto.getBillDList();
        ArrayList<Map> mapList = new ArrayList<Map>();
        ArrayList<BillDetailDto> billList = new ArrayList<BillDetailDto>();
        int i = 0;
        while (i < list.size()) {
            BillDetailDto curDto = list.get(i);
            BillDetailDto b = new BillDetailDto();
            HashMap<BillDetailDto, BillDetailDto> map = new HashMap<BillDetailDto, BillDetailDto>();
            if (!ComUtil.isDisLine(curDto).booleanValue()) {
                int j = i + 1;
                if (j < list.size()) {
                    BillDetailDto disDto = list.get(j);
                    if (ComUtil.isDisLine(disDto).booleanValue()) {
                        map.put(curDto, list.get(j));
                    } else {
                        map.put(curDto, b);
                    }
                } else {
                    map.put(curDto, b);
                }
                mapList.add(map);
            }
            ++i;
        }
        i = 0;
        while (i < mapList.size() - 1) {
            int j = 0;
            while (j < mapList.size() - i - 1) {
                Map map = (Map)mapList.get(j);
                Map map1 = (Map)mapList.get(j + 1);
                BillDetailDto mx = new BillDetailDto();
                BigDecimal value = BigDecimal.ZERO;
                BillDetailDto mx1 = new BillDetailDto();
                BigDecimal value1 = BigDecimal.ZERO;
                for (BillDetailDto key : map.keySet()) {
                    mx = key;
                    value = ((BillDetailDto)map.get(mx)).getAmounts();
                    if (value != null) continue;
                    value = BigDecimal.ZERO;
                }
                for (BillDetailDto key : map1.keySet()) {
                    mx1 = key;
                    value1 = ((BillDetailDto)map1.get(mx1)).getAmounts();
                    if (value1 != null) continue;
                    value1 = BigDecimal.ZERO;
                }
                if (mx.getAmounts().add(value).compareTo(mx1.getAmounts().add(value1)) < 0) {
                    mapList.set(j, (Map)mapList.get(j + 1));
                    mapList.set(j + 1, map);
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < mapList.size()) {
            Map map = (Map)mapList.get(i);
            for (BillDetailDto s : map.keySet()) {
                billList.add(s);
                BillDetailDto curDto = (BillDetailDto)map.get(s);
                BigDecimal amounts = curDto.getAmounts();
                BigDecimal taxAmt = curDto.getTaxAmt();
                if (!(amounts != null && amounts.compareTo(BigDecimal.ZERO) != 0 || taxAmt != null && taxAmt.compareTo(BigDecimal.ZERO) != 0)) continue;
                billList.add((BillDetailDto)map.get(s));
            }
            ++i;
        }
        subjectDto.setBillDList(billList);
        return billList;
    }

    public void getMaxLine(BillSubjectDto billSubjectDto, SmruleConfigDto configDto) {
        int invkind = billSubjectDto.getInvKind();
        int maxLine = 0;
        maxLine = EnumType.InvKindEnum.SPECIAL.getValue() == invkind ? configDto.getMaxSLine() : (EnumType.InvKindEnum.NORMAL.getValue() == invkind ? configDto.getMaxCLine() : (EnumType.InvKindEnum.ESINV.getValue() == invkind ? configDto.getMaxEsiLine() : configDto.getMaxELine()));
        String isOil = billSubjectDto.getIsOil();
        if (StringUtils.isNotEmpty((CharSequence)isOil) && isOil.equals(EnumType.NumberTypeEnum.ONE.getValue().toString())) {
            maxLine = 8;
        } else if (EnumType.NumberTypeEnum.TWO.getValue().intValue() == configDto.getListType() && maxLine > 8) {
            maxLine = 8;
        }
        if (EnumType.InvKindEnum.ROLL.getValue() == invkind) {
            String mode = billSubjectDto.getRollInvSpec();
            maxLine = StringUtils.isNotEmpty((CharSequence)mode) && mode.equals("01") ? 13 : 6;
        }
        billSubjectDto.setLimitLine(maxLine);
    }
}

