/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.it.eip.ump.common.protocol.body;

import com.alibaba.fastjson.annotation.JSONField;
import com.huawei.it.eip.ump.common.util.CommonUtils;

public class Region {
    private String dc;
    private String zone;

    public Region(String dc, String zone) {
        this.dc = dc;
        this.zone = zone;
    }

    public String getDc() {
        return this.dc;
    }

    public void setDc(String dc) {
        this.dc = dc;
    }

    public String getZone() {
        return this.zone;
    }

    public void setZone(String zone) {
        this.zone = zone;
    }

    @JSONField(serialize=false)
    public String getRegionName() {
        return this.dc + "_" + this.zone;
    }

    @JSONField(serialize=false)
    public boolean isValid() {
        return CommonUtils.isNotEmpty(this.dc) && CommonUtils.isNotEmpty(this.zone);
    }

    public boolean dcEquals(Region region) {
        if (!region.isValid() || !this.isValid()) {
            return false;
        }
        return this.getDc().equals(region.getDc());
    }

    public boolean zoneEquals(Region region) {
        if (!region.isValid() || !this.isValid()) {
            return false;
        }
        return this.getZone().equals(region.getZone());
    }

    public boolean equals(Object obj) {
        if (obj instanceof Region) {
            Region region = (Region)obj;
            return this.dcEquals(region) && this.zoneEquals(region);
        }
        return false;
    }

    public int hashCode() {
        return this.getRegionName().hashCode();
    }

    public String toString() {
        return "Region [dc=" + this.dc + ", zone=" + this.zone + "]";
    }
}

