/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.it.eip.ump.common.util;

import io.netty.channel.Channel;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import java.util.UUID;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import org.apache.rocketmq.common.MixAll;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageConst;
import org.apache.rocketmq.remoting.common.RemotingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"UmpConnector");
    public static final char NAME_VALUE_SEPARATOR = '\u0001';
    public static final char PROPERTY_SEPARATOR = '\u0002';

    public static String generateUuid() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    public static String map2string(Map<String, String> properties) {
        StringBuilder sb = new StringBuilder();
        if (properties != null) {
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                String name = entry.getKey();
                String value = entry.getValue();
                sb.append(name);
                sb.append('\u0001');
                sb.append(value);
                sb.append('\u0002');
            }
        }
        return sb.toString();
    }

    public static Map<String, String> string2map(String properties) {
        String[] items;
        HashMap<String, String> map = new HashMap<String, String>();
        if (properties != null && (items = properties.split(String.valueOf('\u0002'))) != null) {
            for (String i : items) {
                String[] nv = i.split(String.valueOf('\u0001'));
                if (nv == null || 2 != nv.length) continue;
                map.put(nv[0], nv[1]);
            }
        }
        return map;
    }

    public static Object map2object(Map<String, Object> map, Class<?> beanClass) throws Exception {
        Field[] fields;
        if (map == null) {
            return null;
        }
        Object obj = beanClass.newInstance();
        for (Field field : fields = obj.getClass().getDeclaredFields()) {
            int mod = field.getModifiers();
            if (Modifier.isStatic(mod) || Modifier.isFinal(mod)) continue;
            field.setAccessible(true);
            field.set(obj, map.get(field.getName()));
        }
        return obj;
    }

    public static Map<String, Object> object2map(Object obj) throws Exception {
        Field[] declaredFields;
        if (obj == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Field field : declaredFields = obj.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            map.put(field.getName(), field.get(obj));
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadProperty(Class<?> clazz, String path) throws Exception {
        Properties prop = new Properties();
        InputStream is = null;
        try {
            is = clazz.getResourceAsStream(path);
            prop.load(is);
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        return prop;
    }

    public static boolean isEmpty(String value) {
        return value == null || value.length() == 0;
    }

    public static boolean isNotEmpty(String value) {
        return !CommonUtils.isEmpty(value);
    }

    public static String defaultString(String value) {
        if (CommonUtils.isEmpty(value)) {
            return "";
        }
        return value;
    }

    public static boolean isEmpty(Collection<?> coll) {
        return coll == null || coll.isEmpty();
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static boolean isNotEmpty(Collection<?> coll) {
        return !CommonUtils.isEmpty(coll);
    }

    public static Map<String, String> mapCoppy(Map<String, String> source) {
        HashMap<String, String> destintion = new HashMap<String, String>();
        for (String key : source.keySet()) {
            destintion.put(key, source.get(key));
        }
        return destintion;
    }

    public static String timeMillisToHumanString3(long t) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(t);
        return String.format("%04d%02d%02d%02d%02d%02d", cal.get(1), cal.get(2) + 1, cal.get(5), cal.get(11), cal.get(12), cal.get(13));
    }

    public static byte[] compress(byte[] src, int level) throws IOException {
        byte[] result = src;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(src.length);
        Deflater deflater = new Deflater(level);
        DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream((OutputStream)byteArrayOutputStream, deflater);
        try {
            deflaterOutputStream.write(src);
            deflaterOutputStream.finish();
            deflaterOutputStream.close();
            result = byteArrayOutputStream.toByteArray();
        }
        catch (IOException e) {
            deflater.end();
            throw e;
        }
        finally {
            try {
                byteArrayOutputStream.close();
            }
            catch (IOException iOException) {}
            deflater.end();
        }
        return result;
    }

    public static byte[] uncompress(byte[] src) throws IOException {
        byte[] result = src;
        byte[] uncompressData = new byte[src.length];
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(src);
        InflaterInputStream inflaterInputStream = new InflaterInputStream(byteArrayInputStream);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(src.length);
        try {
            int len;
            while ((len = inflaterInputStream.read(uncompressData, 0, uncompressData.length)) > 0) {
                byteArrayOutputStream.write(uncompressData, 0, len);
            }
            byteArrayOutputStream.flush();
            result = byteArrayOutputStream.toByteArray();
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            try {
                byteArrayInputStream.close();
            }
            catch (IOException iOException) {}
            try {
                inflaterInputStream.close();
            }
            catch (IOException iOException) {}
            try {
                byteArrayOutputStream.close();
            }
            catch (IOException iOException) {}
        }
        return result;
    }

    public static boolean verifyTags(String configTags, String incomingTags) {
        configTags = configTags == null ? configTags : configTags.replace(" ", "");
        String string = incomingTags = incomingTags == null ? incomingTags : incomingTags.replace(" ", "");
        if (CommonUtils.isEmpty(configTags) || "*".equals(configTags)) {
            return true;
        }
        if (CommonUtils.isEmpty(incomingTags)) {
            return false;
        }
        List<String> configTagList = Arrays.asList(configTags.split("\\|\\|"));
        List<String> incomingTagList = Arrays.asList(incomingTags.split("\\|\\|"));
        return configTagList.containsAll(incomingTagList);
    }

    public static String formatAppId(String appId) {
        return appId == null ? null : appId.replaceAll("[^%|a-zA-Z0-9_-]", "-");
    }

    public static String formatTags(String tags) {
        if (CommonUtils.isNotEmpty(tags) && !"*".equals(tags.trim())) {
            String[] splitTags = tags.split("\\|\\|");
            TreeSet<String> tagSet = new TreeSet<String>();
            StringBuilder sbTags = new StringBuilder();
            for (String tag : splitTags) {
                if (tag.trim().length() <= 0) continue;
                tagSet.add(CommonUtils.formatAppId(tag.trim()));
            }
            for (String tag : tagSet) {
                if (sbTags.length() > 0) {
                    sbTags.append("_");
                }
                sbTags.append(tag);
            }
            return sbTags.toString();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties readProperties(String propertiesFile) {
        InputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(propertiesFile));
            Properties properties = new Properties();
            properties.load(in);
            LOGGER.info("Load properties file : {}  OK", (Object)propertiesFile);
            Properties properties2 = properties;
            return properties2;
        }
        catch (IOException e) {
            LOGGER.error("Load properties file : {} Fail, {}", (Object)propertiesFile, (Object)e.getMessage());
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    public static void saveProperties(Properties properties, String propertiesFile) {
        try {
            String str = MixAll.properties2String((Properties)properties);
            MixAll.string2File((String)str, (String)propertiesFile);
            LOGGER.info("Persist properties file : {}  OK", (Object)propertiesFile);
        }
        catch (IOException e) {
            LOGGER.error("Persist properties file : {} Fail, {}", (Object)propertiesFile, (Object)e.getMessage());
        }
    }

    public static String parseChannelRemoteIP(Channel channel) {
        String remoteAddr = RemotingHelper.parseChannelRemoteAddr((Channel)channel);
        int index = remoteAddr.lastIndexOf(":");
        if (index > 0) {
            return remoteAddr.substring(0, index - 1);
        }
        return remoteAddr;
    }

    public static void putUserPropertyWarpper(Message message, String name, String value) {
        if (MessageConst.STRING_HASH_SET.contains(name)) {
            LOGGER.warn(String.format("The Property<%s> is used by system, input another please", name));
            return;
        }
        if (value == null || value.trim().isEmpty() || name == null || name.trim().isEmpty()) {
            LOGGER.warn("The name or value of property can not be null or blank string!");
            return;
        }
        message.putUserProperty(name, value);
    }
}

