/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.it.eip.ump.common.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateUtil {
    public static final String yyyy_MM_dd = "yyyy-MM-dd";
    public static final String yyyy_MM_dd_HH_mm_ss = "yyyy-MM-dd HH:mm:ss";
    public static final String yyyy_MM_dd_HH_mm_ss_SSS = "yyyy-MM-dd HH:mm:ss.SSS";

    public static String formatDate(Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
        String time = formatter.format(date);
        return time;
    }

    public static String formatDate(Date date, String format) {
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        String time = formatter.format(date);
        return time;
    }

    public static String getDatePattern() {
        return yyyy_MM_dd;
    }

    public static String getTimePattern() {
        return yyyy_MM_dd_HH_mm_ss;
    }

    public static final Date toDate(String pattern, String strDate) {
        SimpleDateFormat df = new SimpleDateFormat(pattern);
        Date date = null;
        try {
            date = df.parse(strDate);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return date;
    }

    public static Date toDate(String strDate) {
        Date aDate = DateUtil.toDate(DateUtil.getDatePattern(), strDate);
        return aDate;
    }

    public static Date toDateTime(String strDateTime) {
        Date aDate = DateUtil.toDate(DateUtil.getTimePattern(), strDateTime);
        return aDate;
    }

    public static Date calendarAdd(Date date, int field, int amount) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(field, amount);
        return calendar.getTime();
    }

    public static long getTimeMillis(String time) {
        Date curDate = DateUtil.toDate(DateUtil.getTimePattern(), DateUtil.formatDate(new Date(), DateUtil.getDatePattern()) + " " + time);
        return curDate.getTime();
    }

    public static long toTimeMillis(String strDate) {
        if (strDate == null || strDate.length() == 0) {
            return 0L;
        }
        String pattern = yyyy_MM_dd_HH_mm_ss;
        Date curDate = DateUtil.toDate(pattern, strDate);
        return curDate == null ? 0L : curDate.getTime();
    }
}

