/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.it.eip.ump.common.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class DigestUtils {
    private static final int SIXTEEN_K = 16384;

    public static String md5AsHex(byte[] data) throws NoSuchAlgorithmException {
        return DigestUtils.toHexString(DigestUtils.computeMD5Hash(data));
    }

    public static String md5AsHex(InputStream is) throws IOException {
        return DigestUtils.toHexString(DigestUtils.computeMD5Hash(is));
    }

    public static byte[] computeMD5Hash(byte[] input) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            return md.digest(input);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    public static byte[] computeMD5Hash(InputStream is) throws IOException {
        BufferedInputStream bis = new BufferedInputStream(is);
        try {
            int bytesRead;
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            byte[] buffer = new byte[16384];
            while ((bytesRead = bis.read(buffer, 0, buffer.length)) != -1) {
                messageDigest.update(buffer, 0, bytesRead);
            }
            byte[] byArray = messageDigest.digest();
            return byArray;
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
        finally {
            try {
                bis.close();
            }
            catch (Exception exception) {}
        }
    }

    public static String toHexString(byte[] hash) {
        StringBuffer hexString = new StringBuffer();
        for (int i = 0; i < hash.length; ++i) {
            String hex = Integer.toHexString(0xFF & hash[i]);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }

    public static String sha256AsHex(byte[] data) throws NoSuchAlgorithmException {
        return DigestUtils.toHexString(DigestUtils.computeSHA256(data));
    }

    public static byte[] computeSHA256(byte[] input) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        return md.digest(input);
    }
}

