/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.it.eip.ump.common.util;

import com.huawei.it.eip.ump.common.security.AesCoder;
import com.huawei.it.eip.ump.common.util.CommonUtils;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;

public class EncryptionUtils {
    public static boolean isEncrypted(RemotingCommand remotingCommand) {
        boolean encrypted = false;
        if (remotingCommand != null && !CommonUtils.isEmpty(remotingCommand.getExtFields())) {
            encrypted = "1".equals(remotingCommand.getExtFields().get("msg_bd_encrypted"));
        }
        return encrypted;
    }

    public static RemotingCommand encrypt(RemotingCommand remotingCommand, String key) throws Exception {
        if (remotingCommand == null) {
            return null;
        }
        byte[] body = remotingCommand.getBody();
        if (body != null && !EncryptionUtils.isEncrypted(remotingCommand)) {
            body = AesCoder.encrypt(body, key);
            remotingCommand.setBody(body);
        }
        EncryptionUtils.addEncryptField(remotingCommand);
        return remotingCommand;
    }

    public static RemotingCommand encrypt(RemotingCommand remotingCommand) throws Exception {
        String key = AesCoder.getKey();
        return EncryptionUtils.encrypt(remotingCommand, key);
    }

    public static RemotingCommand decrypt(RemotingCommand remotingCommand, String key) throws Exception {
        if (remotingCommand == null) {
            return null;
        }
        byte[] body = remotingCommand.getBody();
        if (body != null && EncryptionUtils.isEncrypted(remotingCommand)) {
            body = AesCoder.decrypt(body, key);
            remotingCommand.setBody(body);
        }
        EncryptionUtils.removeEncryptField(remotingCommand);
        return remotingCommand;
    }

    public static RemotingCommand decrypt(RemotingCommand remotingCommand) throws Exception {
        String key = AesCoder.getKey();
        return EncryptionUtils.decrypt(remotingCommand, key);
    }

    private static RemotingCommand addEncryptField(RemotingCommand remotingCommand) {
        if (remotingCommand != null) {
            remotingCommand.addExtField("msg_bd_encrypted", "1");
        }
        return remotingCommand;
    }

    private static RemotingCommand removeEncryptField(RemotingCommand remotingCommand) {
        if (remotingCommand != null && !CommonUtils.isEmpty(remotingCommand.getExtFields())) {
            remotingCommand.getExtFields().remove("msg_bd_encrypted");
        }
        return remotingCommand;
    }
}

