/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.it.eip.ump.client.config;

import com.huawei.it.eip.ump.common.constant.UmpConstants;
import org.apache.rocketmq.remoting.common.RemotingUtil;

public class ClientConfig {
    private String appId;
    private String appSecret;
    private String topic;
    private String clientIp = RemotingUtil.getLocalAddress();
    private String instanceName = "ump_default";
    private String umpNamesrvUrls;
    private String dc;
    private String zone;
    private boolean encryptTransport;
    private String tags = "*";
    private String fileServiceUrl;
    private boolean compressLargeBody = false;
    private String umpConnectorUrls;
    private long loginTimeoutMillis = UmpConstants.TIMEOUT_MILLIS;
    private String connectorIp;

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getAppSecret() {
        return this.appSecret;
    }

    public void setAppSecret(String appSecret) {
        this.appSecret = appSecret;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public String getClientIp() {
        return this.clientIp;
    }

    public void setClientIp(String clientIp) {
        this.clientIp = clientIp;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    public String getUmpNamesrvUrls() {
        return this.umpNamesrvUrls;
    }

    public void setUmpNamesrvUrls(String umpNamesrvUrls) {
        this.umpNamesrvUrls = umpNamesrvUrls;
    }

    @Deprecated
    public String getDc() {
        return this.dc;
    }

    @Deprecated
    public void setDc(String dc) {
        this.dc = dc;
    }

    @Deprecated
    public String getZone() {
        return this.zone;
    }

    @Deprecated
    public void setZone(String zone) {
        this.zone = zone;
    }

    public boolean isEncryptTransport() {
        return this.encryptTransport;
    }

    public void setEncryptTransport(boolean encryptTransport) {
        this.encryptTransport = encryptTransport;
    }

    public String getTags() {
        return this.tags;
    }

    public void setTags(String tags) {
        this.tags = tags;
    }

    public String getFileServiceUrl() {
        return this.fileServiceUrl;
    }

    protected void setFileServiceUrl(String fileServiceUrl) {
        this.fileServiceUrl = fileServiceUrl;
    }

    public boolean isCompressLargeBody() {
        return this.compressLargeBody;
    }

    public void setCompressLargeBody(boolean compressLargeBody) {
        this.compressLargeBody = compressLargeBody;
    }

    public String getUmpConnectorUrls() {
        return this.umpConnectorUrls;
    }

    public void setUmpConnectorUrls(String umpConnectorUrls) {
        this.umpConnectorUrls = umpConnectorUrls;
    }

    public long getLoginTimeoutMillis() {
        return this.loginTimeoutMillis;
    }

    public void setLoginTimeoutMillis(long loginTimeoutMillis) {
        this.loginTimeoutMillis = loginTimeoutMillis;
    }

    public String getConnectorIp() {
        return this.connectorIp;
    }

    public void setConnectorIp(String connectorIp) {
        this.connectorIp = connectorIp;
    }

    private String hideSecret() {
        int minLength = 8;
        if (this.appSecret == null) {
            return null;
        }
        if (this.appSecret.length() <= minLength) {
            return this.appSecret;
        }
        String secret = this.appSecret;
        secret = secret.replace(this.appSecret.substring(4, this.appSecret.length() - 4), "******");
        return secret;
    }

    public String toString() {
        return "ClientConfig{appId='" + this.appId + '\'' + ", appSecret='" + this.hideSecret() + '\'' + ", topic='" + this.topic + '\'' + ", clientIp='" + this.clientIp + '\'' + ", instanceName='" + this.instanceName + '\'' + ", umpNamesrvUrls='" + this.umpNamesrvUrls + '\'' + ", encryptTransport=" + this.encryptTransport + ", tags='" + this.tags + '\'' + ", fileServiceUrl='" + this.fileServiceUrl + '\'' + ", compressLargeBody=" + this.compressLargeBody + ", umpConnectorUrls='" + this.umpConnectorUrls + '\'' + ", loginTimeoutMillis='" + this.loginTimeoutMillis + '\'' + ", connectorIp='" + this.connectorIp + '\'' + '}';
    }
}

