/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.it.eip.ump.client.consumer;

import com.alibaba.fastjson.JSON;
import com.huawei.it.eip.ump.client.AbstractClient;
import com.huawei.it.eip.ump.client.admin.UmpAdmin;
import com.huawei.it.eip.ump.client.config.ClientConfigMap;
import com.huawei.it.eip.ump.client.consumer.ConsumeFromWhere;
import com.huawei.it.eip.ump.client.consumer.ConsumeStatus;
import com.huawei.it.eip.ump.client.consumer.ConsumeTimeoutHook;
import com.huawei.it.eip.ump.client.consumer.ConsumerLargeBodyHelper;
import com.huawei.it.eip.ump.client.consumer.DelayTime;
import com.huawei.it.eip.ump.client.consumer.MessageModel;
import com.huawei.it.eip.ump.client.http.HttpFsClient;
import com.huawei.it.eip.ump.client.listener.MessageListener;
import com.huawei.it.eip.ump.common.constant.UmpConstants;
import com.huawei.it.eip.ump.common.exception.UmpException;
import com.huawei.it.eip.ump.common.log.LogOperateType;
import com.huawei.it.eip.ump.common.log.MessageLogBo;
import com.huawei.it.eip.ump.common.message.Message;
import com.huawei.it.eip.ump.common.util.CommonUtils;
import com.huawei.it.eip.ump.common.util.LogUtils;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.rocketmq.client.ext.consumer.DefaultMQPushConsumer;
import org.apache.rocketmq.client.ext.consumer.listener.ConsumeConcurrentlyContext;
import org.apache.rocketmq.client.ext.consumer.listener.ConsumeConcurrentlyStatus;
import org.apache.rocketmq.client.ext.consumer.listener.MessageListenerConcurrently;
import org.apache.rocketmq.client.ext.exception.MQClientException;
import org.apache.rocketmq.common.message.MessageClientExt;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;

public class Consumer
extends AbstractClient
implements UmpAdmin {
    private DefaultMQPushConsumer defaultMQPushConsumer;
    private MessageModel messageModel = MessageModel.CLUSTERING;
    private String consumeTimestamp = CommonUtils.timeMillisToHumanString3((long)(System.currentTimeMillis() - 1800000L));
    private ConsumeFromWhere consumeFromWhere = ConsumeFromWhere.CONSUME_FROM_FIRST_OFFSET;
    private MessageListener messageListener;
    private int consumeThreadMin = 8;
    private int consumeThreadMax = 32;
    private boolean groupWithTags = false;
    private int pullThresholdForQueue = 1000;
    private long pullInterval = 0L;
    private int consumeMessageBatchMaxSize = 1;
    private int pullBatchSize = 32;
    protected ConsumerLargeBodyHelper largeBodyHelper = null;
    private DelayTime[] delayTimeArray;
    private String subGroup;
    private long consumeTimeoutMinutes = 0L;

    public Consumer() {
        this.clientLoginCode = 18;
    }

    protected Message processMessageBeforeConsume(Message message) throws UmpException {
        message.setBody(this.largeBodyHelper.fetchBody(message));
        message.clearProperty("UmpLargeBodySize");
        message.clearProperty("UmpLargeBodyCompressed");
        return message;
    }

    public ConsumerLargeBodyHelper createLargeBodyHelper() {
        HttpFsClient httpFsClient = new HttpFsClient();
        httpFsClient.setAppid(this.getAppId());
        httpFsClient.setToken(this.getAppSecret());
        return new ConsumerLargeBodyHelper(httpFsClient);
    }

    private DefaultMQPushConsumer createConsumer() throws MQClientException {
        MessageModel messageModel;
        String formatTags;
        String appId = this.getAppId();
        String formattedAppId = CommonUtils.formatAppId((String)appId);
        String topic = this.getTopic();
        String tags = this.getTags();
        String consumerGroup = formattedAppId + "_" + topic;
        if (this.isGroupWithTags() && CommonUtils.isNotEmpty((String)(formatTags = CommonUtils.formatTags((String)tags)))) {
            consumerGroup = consumerGroup + "_" + formatTags;
        }
        if (CommonUtils.isNotEmpty((String)this.subGroup)) {
            String formattedSubGroup = CommonUtils.formatAppId((String)this.subGroup);
            consumerGroup = consumerGroup + "_" + formattedSubGroup;
        }
        logger.info("The consumerGroup is {}", (Object)consumerGroup);
        this.defaultMQPushConsumer = new DefaultMQPushConsumer(consumerGroup);
        String instanceName = formattedAppId + "_" + CommonUtils.generateUuid();
        MessageModel messageModel2 = messageModel = this.getMessageModel() == null ? MessageModel.CLUSTERING : this.getMessageModel();
        if (MessageModel.BROADCASTING == messageModel) {
            String clientInstanceName = CommonUtils.isEmpty((String)this.getInstanceName()) ? this.getClientIp() : this.getInstanceName();
            instanceName = consumerGroup + "_" + clientInstanceName;
        }
        instanceName = instanceName + "_" + CommonUtils.formatAppId((String)"v2.0.1");
        this.defaultMQPushConsumer.setNamesrvAddr(this.getConnectorUrl());
        this.defaultMQPushConsumer.setInstanceName(instanceName);
        this.defaultMQPushConsumer.subscribe(topic, this.getTags());
        this.defaultMQPushConsumer.registerMessageListener(new MessageListenerConcurrently(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ConsumeConcurrentlyStatus consumeMessage(List<MessageExt> msgs, ConsumeConcurrentlyContext context) {
                MessageExt messageExt = msgs.get(0);
                ConsumeStatus consumeStatus = ConsumeStatus.RECONSUME_LATER;
                ConsumeConcurrentlyStatus consumeConcurrentlyStatus = ConsumeConcurrentlyStatus.CONSUME_SUCCESS;
                LogOperateType logOperateType = LogOperateType.RECEIVE_SUCCESS;
                long startMillis = System.currentTimeMillis();
                try {
                    Message message = Consumer.this.toUmpMessage(messageExt);
                    Consumer.this.processMessageBeforeConsume(message);
                    consumeStatus = Consumer.this.messageListener.consume(message);
                }
                catch (Exception e) {
                    consumeStatus = ConsumeStatus.RECONSUME_LATER;
                    logger.error(e.getMessage(), (Throwable)e);
                }
                finally {
                    if (ConsumeStatus.RECONSUME_LATER == consumeStatus) {
                        logOperateType = LogOperateType.RECEIVE_ERROR;
                        consumeConcurrentlyStatus = ConsumeConcurrentlyStatus.RECONSUME_LATER;
                        if (Consumer.this.delayTimeArray != null && Consumer.this.delayTimeArray.length > 0) {
                            context.setDelayLevelWhenNextConsume(Consumer.this.convertDelayTimeLevel(messageExt.getDelayTimeLevel()));
                        }
                    }
                    Consumer.this.sendLogMessage(messageExt, logOperateType, startMillis);
                }
                return consumeConcurrentlyStatus;
            }
        });
        this.defaultMQPushConsumer.setMessageModel(this.convertMessageModel(this.getMessageModel()));
        this.defaultMQPushConsumer.setConsumeFromWhere(this.convertConsumeFromWhere(this.getConsumeFromWhere()));
        if (!CommonUtils.isEmpty((String)this.getConsumeTimestamp())) {
            this.defaultMQPushConsumer.setConsumeTimestamp(this.getConsumeTimestamp());
        }
        this.defaultMQPushConsumer.setConsumeThreadMin(this.getConsumeThreadMin());
        this.defaultMQPushConsumer.setConsumeThreadMax(this.getConsumeThreadMax());
        this.defaultMQPushConsumer.setPullThresholdForQueue(this.getPullThresholdForQueue());
        this.defaultMQPushConsumer.setPullInterval(this.getPullInterval());
        this.defaultMQPushConsumer.setPullBatchSize(this.getPullBatchSize());
        this.defaultMQPushConsumer.setConsumeMessageBatchMaxSize(this.consumeMessageBatchMaxSize);
        this.defaultMQPushConsumer.setConsumeTimeout(this.consumeTimeoutMinutes);
        this.defaultMQPushConsumer.setConsumeTimeoutHook(new ConsumeTimeoutHook(){

            @Override
            public void doHook(MessageExt messageExt, long startMillis) {
                Consumer.this.sendLogMessage(messageExt, LogOperateType.CONSUME_TIMEOUT, startMillis);
            }
        });
        ClientConfigMap.put(this.defaultMQPushConsumer.buildMQClientId(), this);
        return this.defaultMQPushConsumer;
    }

    public void subscribe(MessageListener messageListener) {
        this.messageListener = messageListener;
    }

    private void sendLogMessage(MessageExt messageExt, LogOperateType logOperateType, long startMillis) {
        try {
            Map userProperties = CommonUtils.mapCoppy((Map)messageExt.getProperties());
            userProperties.put("app_id", this.fixClientConfig.getAppId());
            userProperties.put("client_ip_address", this.fixClientConfig.getClientIp());
            userProperties.put("consumer_group", this.defaultMQPushConsumer.getConsumerGroup());
            userProperties.put("consumer_instance", this.defaultMQPushConsumer.getInstanceName());
            userProperties.put("message_model", String.valueOf((Object)this.getMessageModel()));
            int messageSize = messageExt.getBody() == null ? 0 : messageExt.getBody().length;
            int largeBodySize = this.getLargeBodySize(userProperties);
            if (largeBodySize > 0) {
                messageSize = largeBodySize;
            }
            MessageLogBo messageLogBo = LogUtils.toLogBo((Map)userProperties, (String)((MessageClientExt)messageExt).getOffsetMsgId(), (String)messageExt.getTopic(), (LogOperateType)logOperateType, (String)this.getConnectorIp(), (int)messageSize);
            messageLogBo.setCostMillis(System.currentTimeMillis() - startMillis);
            messageLogBo.setReConsumeTimes(messageExt.getReconsumeTimes());
            RemotingCommand request = RemotingCommand.createRequestCommand((int)919, null);
            request.setBody(JSON.toJSONString((Object)messageLogBo).getBytes());
            this.remotingClient.invokeOneway(null, request, UmpConstants.TIMEOUT_MILLIS);
        }
        catch (Exception e) {
            logger.error("Failed to send log message.", (Throwable)e);
        }
    }

    protected int getLargeBodySize(Map<String, String> userProperties) {
        String largeBodySize = userProperties.get("UmpLargeBodySize");
        if (CommonUtils.isNotEmpty((String)largeBodySize)) {
            try {
                return Integer.parseInt(largeBodySize);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return -1;
    }

    @Override
    protected void startClient() throws MQClientException {
        super.startClient();
        this.largeBodyHelper = this.createLargeBodyHelper();
        this.createConsumer().start();
    }

    @Override
    protected void shutdownClient() {
        if (this.defaultMQPushConsumer != null) {
            if (this.defaultMQPushConsumer.getDefaultMQPushConsumerImpl() != null && this.defaultMQPushConsumer.getDefaultMQPushConsumerImpl().getmQClientFactory() != null && this.defaultMQPushConsumer.getDefaultMQPushConsumerImpl().getmQClientFactory().getScheduledExecutorService() != null) {
                this.defaultMQPushConsumer.getDefaultMQPushConsumerImpl().getmQClientFactory().getScheduledExecutorService().shutdown();
            }
            this.defaultMQPushConsumer.shutdown();
            this.defaultMQPushConsumer = null;
        }
    }

    protected void shutdownClientGracefully(long timeout, TimeUnit timeUnit) throws InterruptedException {
        if (this.defaultMQPushConsumer != null) {
            if (this.defaultMQPushConsumer.getDefaultMQPushConsumerImpl() != null && this.defaultMQPushConsumer.getDefaultMQPushConsumerImpl().getmQClientFactory() != null && this.defaultMQPushConsumer.getDefaultMQPushConsumerImpl().getmQClientFactory().getScheduledExecutorService() != null) {
                this.defaultMQPushConsumer.getDefaultMQPushConsumerImpl().getmQClientFactory().getScheduledExecutorService().shutdown();
            }
            this.defaultMQPushConsumer.shutdownGracefully(timeout, timeUnit);
            this.defaultMQPushConsumer = null;
        }
    }

    public void shutdownGracefully(long timeout, TimeUnit timeUnit) throws UmpException {
        try {
            if (this.closed.compareAndSet(false, true)) {
                this.shutdownClientGracefully(timeout, timeUnit);
                this.namesrvService.shutdown();
            }
        }
        catch (Exception e) {
            throw new UmpException("shutdownGracefully " + this.clientName + " encounter exception.", (Throwable)e);
        }
    }

    public ConsumeFromWhere getConsumeFromWhere() {
        return this.consumeFromWhere;
    }

    public void setConsumeFromWhere(ConsumeFromWhere consumeFromWhere) {
        this.consumeFromWhere = consumeFromWhere;
    }

    public String getConsumeTimestamp() {
        return this.consumeTimestamp;
    }

    public void setConsumeTimestamp(String consumeTimestamp) {
        this.consumeTimestamp = consumeTimestamp;
    }

    public MessageModel getMessageModel() {
        return this.messageModel;
    }

    public void setMessageModel(MessageModel messageModel) {
        this.messageModel = messageModel;
    }

    public int getConsumeThreadMin() {
        return this.consumeThreadMin;
    }

    public void setConsumeThreadMin(int consumeThreadMin) {
        this.consumeThreadMin = consumeThreadMin;
    }

    public int getConsumeThreadMax() {
        return this.consumeThreadMax;
    }

    public void setConsumeThreadMax(int consumeThreadMax) {
        this.consumeThreadMax = consumeThreadMax;
    }

    public boolean isGroupWithTags() {
        return this.groupWithTags;
    }

    public void setGroupWithTags(boolean groupWithTags) {
        this.groupWithTags = groupWithTags;
    }

    public int getPullThresholdForQueue() {
        return this.pullThresholdForQueue;
    }

    public void setPullThresholdForQueue(int pullThresholdForQueue) {
        this.pullThresholdForQueue = pullThresholdForQueue;
    }

    public long getPullInterval() {
        return this.pullInterval;
    }

    public void setPullInterval(long pullInterval) {
        this.pullInterval = pullInterval;
    }

    public int getPullBatchSize() {
        return this.pullBatchSize;
    }

    public void setPullBatchSize(int pullBatchSize) {
        this.pullBatchSize = pullBatchSize;
    }

    public String getSubGroup() {
        return this.subGroup;
    }

    public void setSubGroup(String subGroup) {
        this.subGroup = subGroup;
    }

    private org.apache.rocketmq.common.protocol.heartbeat.MessageModel convertMessageModel(MessageModel messageModel) {
        if (MessageModel.BROADCASTING == messageModel) {
            return org.apache.rocketmq.common.protocol.heartbeat.MessageModel.BROADCASTING;
        }
        return org.apache.rocketmq.common.protocol.heartbeat.MessageModel.CLUSTERING;
    }

    private org.apache.rocketmq.common.consumer.ConsumeFromWhere convertConsumeFromWhere(ConsumeFromWhere where) {
        if (ConsumeFromWhere.CONSUME_FROM_LAST_OFFSET == where) {
            return org.apache.rocketmq.common.consumer.ConsumeFromWhere.CONSUME_FROM_LAST_OFFSET;
        }
        if (ConsumeFromWhere.CONSUME_FROM_TIMESTAMP == where) {
            return org.apache.rocketmq.common.consumer.ConsumeFromWhere.CONSUME_FROM_TIMESTAMP;
        }
        return org.apache.rocketmq.common.consumer.ConsumeFromWhere.CONSUME_FROM_FIRST_OFFSET;
    }

    @Override
    protected void checkConfig() throws UmpException {
        super.checkConfig();
        if (this.messageListener == null) {
            throw new UmpException("messageListener is required.");
        }
    }

    public DelayTime[] getDelayTimeArray() {
        return this.delayTimeArray;
    }

    public void setDelayTimeArray(DelayTime[] delayTimeArray) {
        if (delayTimeArray != null && delayTimeArray.length > 0) {
            EnumSet<DelayTime> set = EnumSet.noneOf(DelayTime.class);
            set.addAll(Arrays.asList(delayTimeArray));
            delayTimeArray = set.toArray(new DelayTime[0]);
            Arrays.sort((Object[])delayTimeArray);
        }
        this.delayTimeArray = delayTimeArray;
    }

    private int convertDelayTimeLevel(int delayTimeLevel) {
        if (this.delayTimeArray == null || this.delayTimeArray.length == 0) {
            return 0;
        }
        int max = this.delayTimeArray[this.delayTimeArray.length - 1].level();
        if (delayTimeLevel >= max) {
            return -1;
        }
        for (DelayTime dt : this.delayTimeArray) {
            if (delayTimeLevel >= dt.level()) continue;
            return dt.level();
        }
        return delayTimeLevel;
    }

    public long getConsumeTimeoutMinutes() {
        return this.consumeTimeoutMinutes;
    }

    public void setConsumeTimeoutMinutes(long consumeTimeoutMinutes) {
        this.consumeTimeoutMinutes = consumeTimeoutMinutes;
    }

    @Override
    public String toString() {
        return "Consumer [messageModel=" + (Object)((Object)this.messageModel) + ", consumeFromWhere=" + (Object)((Object)this.consumeFromWhere) + ", consumeThreadMin=" + this.consumeThreadMin + ", consumeThreadMax=" + this.consumeThreadMax + ", groupWithTags=" + this.groupWithTags + ", consumeTimestamp=" + this.consumeTimestamp + ", subGroup=" + this.subGroup + ", consumeTimeoutMinutes=" + this.consumeTimeoutMinutes + ", toString()=" + super.toString() + "]";
    }
}

