/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.it.eip.ump.client.consumer;

import com.alibaba.fastjson.JSON;
import com.huawei.it.eip.ump.client.AbstractClient;
import com.huawei.it.eip.ump.client.config.ClientConfigMap;
import com.huawei.it.eip.ump.client.consumer.ConsumerLargeBodyHelper;
import com.huawei.it.eip.ump.client.consumer.MessageModel;
import com.huawei.it.eip.ump.client.consumer.UmpConverter;
import com.huawei.it.eip.ump.client.consumer.UmpMessageQueue;
import com.huawei.it.eip.ump.client.consumer.UmpMessageQueueListener;
import com.huawei.it.eip.ump.client.consumer.UmpPullResult;
import com.huawei.it.eip.ump.client.http.HttpFsClient;
import com.huawei.it.eip.ump.common.constant.UmpConstants;
import com.huawei.it.eip.ump.common.exception.UmpException;
import com.huawei.it.eip.ump.common.log.LogOperateType;
import com.huawei.it.eip.ump.common.log.MessageLogBo;
import com.huawei.it.eip.ump.common.message.Message;
import com.huawei.it.eip.ump.common.util.CommonUtils;
import com.huawei.it.eip.ump.common.util.LogUtils;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.rocketmq.client.ext.consumer.DefaultMQPullConsumer;
import org.apache.rocketmq.client.ext.consumer.MessageQueueListener;
import org.apache.rocketmq.client.ext.consumer.PullResult;
import org.apache.rocketmq.client.ext.exception.MQClientException;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;

public class PullConsumer
extends AbstractClient {
    private DefaultMQPullConsumer defaultMQPullConsumer;
    private MessageModel messageModel = MessageModel.CLUSTERING;
    private ConsumerLargeBodyHelper largeBodyHelper = null;
    private boolean groupWithTags = false;
    private String subGroup;
    private UmpMessageQueueListener messageQueueListener;
    private AtomicBoolean balanced = new AtomicBoolean(false);

    public void registerMessageQueueListener(UmpMessageQueueListener listener) {
        this.messageQueueListener = listener;
    }

    public UmpPullResult pull(UmpMessageQueue mq, long offset) throws UmpException {
        return this.pull(mq, offset, 32);
    }

    public UmpPullResult pull(UmpMessageQueue mq, long offset, int maxNums) throws UmpException {
        return this.pull(mq, offset, maxNums, UmpConstants.TIMEOUT_MILLIS);
    }

    public UmpPullResult pull(final UmpMessageQueue mq, final long offset, final int maxNums, final long timeoutMillis) throws UmpException {
        if (null == mq) {
            throw new UmpException("mq is null");
        }
        if (offset < 0L) {
            throw new UmpException("offset < 0");
        }
        if (maxNums <= 0) {
            throw new UmpException("maxNums <= 0");
        }
        if (timeoutMillis <= 0L) {
            throw new UmpException("timeoutMillis <= 0");
        }
        return this.call(new Callable<UmpPullResult>(){

            @Override
            public UmpPullResult call() throws Exception {
                PullResult pullResult = PullConsumer.this.defaultMQPullConsumer.pull(UmpConverter.convert(mq), PullConsumer.this.fixClientConfig.getTags(), offset, maxNums, timeoutMillis);
                UmpPullResult result = UmpConverter.convert(pullResult);
                if (CommonUtils.isNotEmpty(pullResult.getMsgFoundList())) {
                    for (MessageExt messageExt : pullResult.getMsgFoundList()) {
                        Message message = PullConsumer.this.toUmpMessage(messageExt);
                        PullConsumer.this.processMessageBeforeConsume(message);
                        result.getMsgFoundList().add(message);
                        PullConsumer.this.sendLogMessage(messageExt);
                    }
                }
                return result;
            }
        });
    }

    public Set<UmpMessageQueue> fetchMessageQueuesInBalance() throws UmpException {
        return this.call(new Callable<Set<UmpMessageQueue>>(){

            @Override
            public Set<UmpMessageQueue> call() throws Exception {
                while (!PullConsumer.this.isBalanced()) {
                    Thread.sleep(10L);
                }
                Set<MessageQueue> set = PullConsumer.this.defaultMQPullConsumer.fetchMessageQueuesInBalance(PullConsumer.this.fixClientConfig.getTopic());
                return UmpConverter.convert(set);
            }
        });
    }

    public Set<UmpMessageQueue> fetchSubscribeMessageQueues() throws UmpException {
        return this.call(new Callable<Set<UmpMessageQueue>>(){

            @Override
            public Set<UmpMessageQueue> call() throws Exception {
                Set<MessageQueue> set = PullConsumer.this.defaultMQPullConsumer.fetchSubscribeMessageQueues(PullConsumer.this.fixClientConfig.getTopic());
                return UmpConverter.convert(set);
            }
        });
    }

    public long searchOffset(final UmpMessageQueue mq, final long timestamp) throws UmpException {
        if (null == mq) {
            throw new UmpException("mq is null");
        }
        if (timestamp <= 0L) {
            throw new UmpException("timestamp <= 0");
        }
        return this.call(new Callable<Long>(){

            @Override
            public Long call() throws Exception {
                return PullConsumer.this.defaultMQPullConsumer.searchOffset(UmpConverter.convert(mq), timestamp);
            }
        });
    }

    public long maxOffset(final UmpMessageQueue mq) throws UmpException {
        if (null == mq) {
            throw new UmpException("mq is null");
        }
        return this.call(new Callable<Long>(){

            @Override
            public Long call() throws Exception {
                return PullConsumer.this.defaultMQPullConsumer.maxOffset(UmpConverter.convert(mq));
            }
        });
    }

    public long minOffset(final UmpMessageQueue mq) throws UmpException {
        if (null == mq) {
            throw new UmpException("mq is null");
        }
        return this.call(new Callable<Long>(){

            @Override
            public Long call() throws Exception {
                return PullConsumer.this.defaultMQPullConsumer.minOffset(UmpConverter.convert(mq));
            }
        });
    }

    public void updateConsumeOffset(final UmpMessageQueue mq, final long offset) throws UmpException {
        if (null == mq) {
            throw new UmpException("mq is null");
        }
        if (offset < 0L) {
            throw new UmpException("offset less than 0");
        }
        this.call(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                PullConsumer.this.defaultMQPullConsumer.updateConsumeOffset(UmpConverter.convert(mq), offset);
                return null;
            }
        });
    }

    private DefaultMQPullConsumer createConsumer() {
        MessageModel messageModel;
        String formatTags;
        String appId = this.getAppId();
        String formattedAppId = CommonUtils.formatAppId((String)appId);
        String topic = this.getTopic();
        String tags = this.getTags();
        String consumerGroup = "PULL_" + formattedAppId + "_" + topic;
        if (this.groupWithTags && CommonUtils.isNotEmpty((String)(formatTags = CommonUtils.formatTags((String)tags)))) {
            consumerGroup = consumerGroup + "_" + formatTags;
        }
        if (CommonUtils.isNotEmpty((String)this.subGroup)) {
            String formattedSubGroup = CommonUtils.formatAppId((String)this.subGroup);
            consumerGroup = consumerGroup + "_" + formattedSubGroup;
        }
        logger.info("The consumerGroup is {}", (Object)consumerGroup);
        this.defaultMQPullConsumer = new DefaultMQPullConsumer(consumerGroup);
        String instanceName = formattedAppId + "_" + CommonUtils.generateUuid();
        MessageModel messageModel2 = messageModel = this.messageModel == null ? MessageModel.CLUSTERING : this.messageModel;
        if (MessageModel.BROADCASTING == messageModel) {
            String clientInstanceName = CommonUtils.isEmpty((String)this.getInstanceName()) ? this.getClientIp() : this.getInstanceName();
            instanceName = consumerGroup + "_" + clientInstanceName;
        }
        this.defaultMQPullConsumer.setNamesrvAddr(this.getConnectorUrl());
        this.defaultMQPullConsumer.setInstanceName(instanceName);
        this.defaultMQPullConsumer.setMessageModel(this.convertMessageModel(this.messageModel));
        this.defaultMQPullConsumer.registerMessageQueueListener(this.getTopic(), new MessageQueueListener(){

            @Override
            public void messageQueueChanged(String topic, Set<MessageQueue> mqAll, Set<MessageQueue> mqDivided) {
                PullConsumer.this.balanced.set(true);
                if (PullConsumer.this.messageQueueListener != null) {
                    Set<UmpMessageQueue> all = UmpConverter.convert(mqAll);
                    Set<UmpMessageQueue> divided = UmpConverter.convert(mqDivided);
                    PullConsumer.this.messageQueueListener.messageQueueChanged(topic, all, divided);
                }
            }
        });
        ClientConfigMap.put(this.defaultMQPullConsumer.buildMQClientId(), this);
        return this.defaultMQPullConsumer;
    }

    @Override
    protected void startClient() throws MQClientException {
        super.startClient();
        this.largeBodyHelper = this.createLargeBodyHelper();
        this.createConsumer().start();
    }

    @Override
    protected void shutdownClient() {
        if (this.defaultMQPullConsumer != null) {
            this.defaultMQPullConsumer.shutdown();
            this.defaultMQPullConsumer = null;
        }
    }

    private org.apache.rocketmq.common.protocol.heartbeat.MessageModel convertMessageModel(MessageModel messageModel) {
        if (MessageModel.BROADCASTING == messageModel) {
            return org.apache.rocketmq.common.protocol.heartbeat.MessageModel.BROADCASTING;
        }
        return org.apache.rocketmq.common.protocol.heartbeat.MessageModel.CLUSTERING;
    }

    private ConsumerLargeBodyHelper createLargeBodyHelper() {
        HttpFsClient httpFsClient = new HttpFsClient();
        httpFsClient.setAppid(this.getAppId());
        httpFsClient.setToken(this.getAppSecret());
        return new ConsumerLargeBodyHelper(httpFsClient);
    }

    private Message processMessageBeforeConsume(Message message) throws UmpException {
        message.setBody(this.largeBodyHelper.fetchBody(message));
        message.clearProperty("UmpLargeBodySize");
        message.clearProperty("UmpLargeBodyCompressed");
        return message;
    }

    private void makeSureStateOK() throws UmpException {
        if (this.defaultMQPullConsumer == null) {
            throw new UmpException("The pull consumer state not OK.");
        }
    }

    private <T> T call(Callable<T> callable) throws UmpException {
        this.makeSureStateOK();
        try {
            return callable.call();
        }
        catch (Exception e) {
            throw new UmpException("Fail to send request, ", (Throwable)e);
        }
    }

    private int getLargeBodySize(Map<String, String> userProperties) {
        String largeBodySize = userProperties.get("UmpLargeBodySize");
        if (CommonUtils.isNotEmpty((String)largeBodySize)) {
            try {
                return Integer.parseInt(largeBodySize);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return -1;
    }

    private void sendLogMessage(MessageExt messageExt) {
        try {
            Map userProperties = CommonUtils.mapCoppy((Map)messageExt.getProperties());
            userProperties.put("app_id", this.fixClientConfig.getAppId());
            userProperties.put("client_ip_address", this.fixClientConfig.getClientIp());
            userProperties.put("consumer_group", this.defaultMQPullConsumer.getConsumerGroup());
            userProperties.put("consumer_instance", this.defaultMQPullConsumer.getInstanceName());
            userProperties.put("message_model", String.valueOf((Object)this.messageModel));
            int messageSize = messageExt.getBody() == null ? 0 : messageExt.getBody().length;
            int largeBodySize = this.getLargeBodySize(userProperties);
            if (largeBodySize > 0) {
                messageSize = largeBodySize;
            }
            MessageLogBo messageLogBo = LogUtils.toLogBo((Map)userProperties, (String)messageExt.getMsgId(), (String)messageExt.getTopic(), (LogOperateType)LogOperateType.PULL_SUCCESS, (String)this.getUmpNamesrvUrls(), (int)messageSize);
            RemotingCommand request = RemotingCommand.createRequestCommand((int)919, null);
            request.setBody(JSON.toJSONString((Object)messageLogBo).getBytes());
            this.remotingClient.invokeOneway(null, request, UmpConstants.TIMEOUT_MILLIS);
        }
        catch (Exception e) {
            logger.error("Failed to send log message.", (Throwable)e);
        }
    }

    public boolean isGroupWithTags() {
        return this.groupWithTags;
    }

    public void setGroupWithTags(boolean groupWithTags) {
        this.groupWithTags = groupWithTags;
    }

    public String getSubGroup() {
        return this.subGroup;
    }

    public void setSubGroup(String subGroup) {
        this.subGroup = subGroup;
    }

    public boolean isBalanced() {
        return this.balanced.get();
    }

    public MessageModel getMessageModel() {
        return this.messageModel;
    }

    public void setMessageModel(MessageModel messageModel) {
        this.messageModel = messageModel;
    }
}

