/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.ext.impl.consumer;

import org.apache.rocketmq.client.ext.impl.factory.MQClientInstance;
import org.apache.rocketmq.client.ext.log.ClientLogger;
import org.apache.rocketmq.common.ServiceThread;
import org.apache.rocketmq.logging.InternalLogger;

public class RebalanceService
extends ServiceThread {
    private static long waitInterval = Long.parseLong(System.getProperty("rocketmq.client.rebalance.waitInterval", "20000"));
    private final InternalLogger log = ClientLogger.getLog();
    private final MQClientInstance mqClientFactory;

    public RebalanceService(MQClientInstance mqClientFactory) {
        this.mqClientFactory = mqClientFactory;
    }

    public void run() {
        this.log.info(this.getServiceName() + " service started");
        while (!this.isStopped()) {
            this.waitForRunning(waitInterval);
            this.mqClientFactory.doRebalance();
        }
        this.log.info(this.getServiceName() + " service end");
    }

    public String getServiceName() {
        return RebalanceService.class.getSimpleName();
    }
}

