/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.ext.impl.producer;

import com.huawei.it.eip.ump.common.exception.FAQUrl;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.rocketmq.client.ext.QueryResult;
import org.apache.rocketmq.client.ext.Validators;
import org.apache.rocketmq.client.ext.exception.MQBrokerException;
import org.apache.rocketmq.client.ext.exception.MQClientException;
import org.apache.rocketmq.client.ext.exception.RequestTimeoutException;
import org.apache.rocketmq.client.ext.hook.CheckForbiddenContext;
import org.apache.rocketmq.client.ext.hook.CheckForbiddenHook;
import org.apache.rocketmq.client.ext.hook.SendMessageContext;
import org.apache.rocketmq.client.ext.hook.SendMessageHook;
import org.apache.rocketmq.client.ext.impl.CommunicationMode;
import org.apache.rocketmq.client.ext.impl.MQClientManager;
import org.apache.rocketmq.client.ext.impl.factory.MQClientInstance;
import org.apache.rocketmq.client.ext.impl.producer.MQProducerInner;
import org.apache.rocketmq.client.ext.impl.producer.TopicPublishInfo;
import org.apache.rocketmq.client.ext.latency.MQFaultStrategy;
import org.apache.rocketmq.client.ext.log.ClientLogger;
import org.apache.rocketmq.client.ext.producer.DefaultMQProducer;
import org.apache.rocketmq.client.ext.producer.LocalTransactionExecuter;
import org.apache.rocketmq.client.ext.producer.LocalTransactionState;
import org.apache.rocketmq.client.ext.producer.MessageQueueSelector;
import org.apache.rocketmq.client.ext.producer.RequestCallback;
import org.apache.rocketmq.client.ext.producer.RequestFutureTable;
import org.apache.rocketmq.client.ext.producer.RequestResponseFuture;
import org.apache.rocketmq.client.ext.producer.SendCallback;
import org.apache.rocketmq.client.ext.producer.SendResult;
import org.apache.rocketmq.client.ext.producer.SendStatus;
import org.apache.rocketmq.client.ext.producer.TransactionCheckListener;
import org.apache.rocketmq.client.ext.producer.TransactionListener;
import org.apache.rocketmq.client.ext.producer.TransactionMQProducer;
import org.apache.rocketmq.client.ext.producer.TransactionSendResult;
import org.apache.rocketmq.common.MixAll;
import org.apache.rocketmq.common.ServiceState;
import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageAccessor;
import org.apache.rocketmq.common.message.MessageBatch;
import org.apache.rocketmq.common.message.MessageClientIDSetter;
import org.apache.rocketmq.common.message.MessageDecoder;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.common.message.MessageId;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.common.message.MessageType;
import org.apache.rocketmq.common.protocol.NamespaceUtil;
import org.apache.rocketmq.common.protocol.header.CheckTransactionStateRequestHeader;
import org.apache.rocketmq.common.protocol.header.EndTransactionRequestHeader;
import org.apache.rocketmq.common.protocol.header.SendMessageRequestHeader;
import org.apache.rocketmq.common.utils.CorrelationIdUtil;
import org.apache.rocketmq.logging.InternalLogger;
import org.apache.rocketmq.remoting.RPCHook;
import org.apache.rocketmq.remoting.common.RemotingHelper;
import org.apache.rocketmq.remoting.exception.RemotingConnectException;
import org.apache.rocketmq.remoting.exception.RemotingException;
import org.apache.rocketmq.remoting.exception.RemotingTimeoutException;
import org.apache.rocketmq.remoting.exception.RemotingTooMuchRequestException;

public class DefaultMQProducerImpl
implements MQProducerInner {
    private final InternalLogger log = ClientLogger.getLog();
    private final Random random = new Random();
    private final DefaultMQProducer defaultMQProducer;
    private final ConcurrentMap<String, TopicPublishInfo> topicPublishInfoTable = new ConcurrentHashMap<String, TopicPublishInfo>();
    private final ArrayList<SendMessageHook> sendMessageHookList = new ArrayList();
    private final RPCHook rpcHook;
    private final BlockingQueue<Runnable> asyncSenderThreadPoolQueue;
    private final ExecutorService defaultAsyncSenderExecutor;
    private final Timer timer = new Timer("RequestHouseKeepingService", true);
    protected BlockingQueue<Runnable> checkRequestQueue;
    protected ExecutorService checkExecutor;
    private ServiceState serviceState = ServiceState.CREATE_JUST;
    private MQClientInstance mQClientFactory;
    private ArrayList<CheckForbiddenHook> checkForbiddenHookList = new ArrayList();
    private int zipCompressLevel = Integer.parseInt(System.getProperty("rocketmq.message.compressLevel", "5"));
    private MQFaultStrategy mqFaultStrategy = new MQFaultStrategy();
    private ExecutorService asyncSenderExecutor;

    public DefaultMQProducerImpl(DefaultMQProducer defaultMQProducer) {
        this(defaultMQProducer, null);
    }

    public DefaultMQProducerImpl(DefaultMQProducer defaultMQProducer, RPCHook rpcHook) {
        this.defaultMQProducer = defaultMQProducer;
        this.rpcHook = rpcHook;
        this.asyncSenderThreadPoolQueue = new LinkedBlockingQueue<Runnable>(50000);
        this.defaultAsyncSenderExecutor = new ThreadPoolExecutor(Runtime.getRuntime().availableProcessors(), Runtime.getRuntime().availableProcessors(), 60000L, TimeUnit.MILLISECONDS, this.asyncSenderThreadPoolQueue, new ThreadFactory(){
            private AtomicInteger threadIndex = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "AsyncSenderExecutor_" + this.threadIndex.incrementAndGet());
            }
        });
    }

    public void registerCheckForbiddenHook(CheckForbiddenHook checkForbiddenHook) {
        this.checkForbiddenHookList.add(checkForbiddenHook);
        this.log.info("register a new checkForbiddenHook. hookName={}, allHookSize={}", (Object)checkForbiddenHook.hookName(), (Object)this.checkForbiddenHookList.size());
    }

    public void initTransactionEnv() {
        TransactionMQProducer producer = (TransactionMQProducer)this.defaultMQProducer;
        if (producer.getExecutorService() != null) {
            this.checkExecutor = producer.getExecutorService();
        } else {
            this.checkRequestQueue = new LinkedBlockingQueue<Runnable>(producer.getCheckRequestHoldMax());
            this.checkExecutor = new ThreadPoolExecutor(producer.getCheckThreadPoolMinSize(), producer.getCheckThreadPoolMaxSize(), 60000L, TimeUnit.MILLISECONDS, this.checkRequestQueue);
        }
    }

    public void destroyTransactionEnv() {
        if (this.checkExecutor != null) {
            this.checkExecutor.shutdown();
        }
    }

    public void registerSendMessageHook(SendMessageHook hook) {
        this.sendMessageHookList.add(hook);
        this.log.info("register sendMessage Hook, {}", (Object)hook.hookName());
    }

    public void start() throws MQClientException {
        this.start(true);
    }

    public void start(boolean startFactory) throws MQClientException {
        switch (this.serviceState) {
            case CREATE_JUST: {
                this.serviceState = ServiceState.START_FAILED;
                this.checkConfig();
                if (!this.defaultMQProducer.getProducerGroup().equals("CLIENT_INNER_PRODUCER")) {
                    this.defaultMQProducer.changeInstanceNameToPID();
                }
                this.mQClientFactory = MQClientManager.getInstance().getOrCreateMQClientInstance(this.defaultMQProducer, this.rpcHook);
                boolean registerOK = this.mQClientFactory.registerProducer(this.defaultMQProducer.getProducerGroup(), this);
                if (!registerOK) {
                    this.serviceState = ServiceState.CREATE_JUST;
                    throw new MQClientException("The producer group[" + this.defaultMQProducer.getProducerGroup() + "] has been created before, specify another name please." + FAQUrl.suggestTodo((String)"http://his.huawei.com/ump/#/help/faq/"), null);
                }
                if (startFactory) {
                    this.mQClientFactory.start();
                }
                this.log.info("the producer [{}] start OK. sendMessageWithVIPChannel={}", (Object)this.defaultMQProducer.getProducerGroup(), (Object)this.defaultMQProducer.isSendMessageWithVIPChannel());
                this.serviceState = ServiceState.RUNNING;
                break;
            }
            case RUNNING: 
            case START_FAILED: 
            case SHUTDOWN_ALREADY: {
                throw new MQClientException("The producer service state not OK, maybe started once, " + this.serviceState + FAQUrl.suggestTodo((String)"http://his.huawei.com/ump/#/help/faq/"), null);
            }
        }
        this.mQClientFactory.sendHeartbeatToAllBrokerWithLock();
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                try {
                    RequestFutureTable.scanExpiredRequest();
                }
                catch (Throwable e) {
                    DefaultMQProducerImpl.this.log.error("scan RequestFutureTable exception", e);
                }
            }
        }, 3000L, 1000L);
    }

    private void checkConfig() throws MQClientException {
        Validators.checkGroup(this.defaultMQProducer.getProducerGroup());
        if (null == this.defaultMQProducer.getProducerGroup()) {
            throw new MQClientException("producerGroup is null", null);
        }
        if (this.defaultMQProducer.getProducerGroup().equals("DEFAULT_PRODUCER")) {
            throw new MQClientException("producerGroup can not equal DEFAULT_PRODUCER, please specify another one.", null);
        }
    }

    public void shutdown() {
        this.shutdown(true);
    }

    public void shutdown(boolean shutdownFactory) {
        switch (this.serviceState) {
            case CREATE_JUST: {
                break;
            }
            case RUNNING: {
                this.mQClientFactory.unregisterProducer(this.defaultMQProducer.getProducerGroup());
                this.defaultAsyncSenderExecutor.shutdown();
                if (shutdownFactory) {
                    this.mQClientFactory.shutdown();
                }
                this.log.info("the producer [{}] shutdown OK", (Object)this.defaultMQProducer.getProducerGroup());
                this.serviceState = ServiceState.SHUTDOWN_ALREADY;
                break;
            }
            case SHUTDOWN_ALREADY: {
                break;
            }
        }
    }

    @Override
    public Set<String> getPublishTopicList() {
        HashSet<String> topicList = new HashSet<String>();
        for (String key : this.topicPublishInfoTable.keySet()) {
            topicList.add(key);
        }
        return topicList;
    }

    @Override
    public boolean isPublishTopicNeedUpdate(String topic) {
        TopicPublishInfo prev = (TopicPublishInfo)this.topicPublishInfoTable.get(topic);
        return null == prev || !prev.ok();
    }

    @Override
    @Deprecated
    public TransactionCheckListener checkListener() {
        if (this.defaultMQProducer instanceof TransactionMQProducer) {
            TransactionMQProducer producer = (TransactionMQProducer)this.defaultMQProducer;
            return producer.getTransactionCheckListener();
        }
        return null;
    }

    @Override
    public TransactionListener getCheckListener() {
        if (this.defaultMQProducer instanceof TransactionMQProducer) {
            TransactionMQProducer producer = (TransactionMQProducer)this.defaultMQProducer;
            return producer.getTransactionListener();
        }
        return null;
    }

    @Override
    public void checkTransactionState(final String addr, final MessageExt msg, final CheckTransactionStateRequestHeader header) {
        Runnable request = new Runnable(){
            private final String brokerAddr;
            private final MessageExt message;
            private final CheckTransactionStateRequestHeader checkRequestHeader;
            private final String group;
            {
                this.brokerAddr = addr;
                this.message = msg;
                this.checkRequestHeader = header;
                this.group = DefaultMQProducerImpl.this.defaultMQProducer.getProducerGroup();
            }

            @Override
            public void run() {
                TransactionCheckListener transactionCheckListener = DefaultMQProducerImpl.this.checkListener();
                TransactionListener transactionListener = DefaultMQProducerImpl.this.getCheckListener();
                if (transactionCheckListener != null || transactionListener != null) {
                    LocalTransactionState localTransactionState = LocalTransactionState.UNKNOW;
                    Throwable exception = null;
                    try {
                        if (transactionCheckListener != null) {
                            localTransactionState = transactionCheckListener.checkLocalTransactionState(this.message);
                        } else if (transactionListener != null) {
                            DefaultMQProducerImpl.this.log.debug("Used new check API in transaction message");
                            localTransactionState = transactionListener.checkLocalTransaction(this.message);
                        } else {
                            DefaultMQProducerImpl.this.log.warn("CheckTransactionState, pick transactionListener by group[{}] failed", (Object)this.group);
                        }
                    }
                    catch (Throwable e) {
                        DefaultMQProducerImpl.this.log.error("Broker call checkTransactionState, but checkLocalTransactionState exception", e);
                        exception = e;
                    }
                    this.processTransactionState(localTransactionState, this.group, exception);
                } else {
                    DefaultMQProducerImpl.this.log.warn("CheckTransactionState, pick transactionCheckListener by group[{}] failed", (Object)this.group);
                }
            }

            private void processTransactionState(LocalTransactionState localTransactionState, String producerGroup, Throwable exception) {
                EndTransactionRequestHeader thisHeader = new EndTransactionRequestHeader();
                thisHeader.setCommitLogOffset(this.checkRequestHeader.getCommitLogOffset());
                thisHeader.setProducerGroup(producerGroup);
                thisHeader.setTranStateTableOffset(this.checkRequestHeader.getTranStateTableOffset());
                thisHeader.setFromTransactionCheck(Boolean.valueOf(true));
                String uniqueKey = (String)this.message.getProperties().get("UNIQ_KEY");
                if (uniqueKey == null) {
                    uniqueKey = this.message.getMsgId();
                }
                thisHeader.setMsgId(uniqueKey);
                thisHeader.setTransactionId(this.checkRequestHeader.getTransactionId());
                switch (localTransactionState) {
                    case COMMIT_MESSAGE: {
                        thisHeader.setCommitOrRollback(Integer.valueOf(8));
                        break;
                    }
                    case ROLLBACK_MESSAGE: {
                        thisHeader.setCommitOrRollback(Integer.valueOf(12));
                        DefaultMQProducerImpl.this.log.warn("when broker check, client rollback this transaction, {}", (Object)thisHeader);
                        break;
                    }
                    case UNKNOW: {
                        thisHeader.setCommitOrRollback(Integer.valueOf(0));
                        DefaultMQProducerImpl.this.log.warn("when broker check, client does not know this transaction state, {}", (Object)thisHeader);
                        break;
                    }
                }
                String remark = null;
                if (exception != null) {
                    remark = "checkLocalTransactionState Exception: " + RemotingHelper.exceptionSimpleDesc((Throwable)exception);
                }
                try {
                    DefaultMQProducerImpl.this.mQClientFactory.getMQClientAPIImpl().endTransactionOneway(this.brokerAddr, thisHeader, remark, 3000L);
                }
                catch (Exception e) {
                    DefaultMQProducerImpl.this.log.error("endTransactionOneway exception", (Throwable)e);
                }
            }
        };
        this.checkExecutor.submit(request);
    }

    @Override
    public void updateTopicPublishInfo(String topic, TopicPublishInfo info) {
        TopicPublishInfo prev;
        if (info != null && topic != null && (prev = this.topicPublishInfoTable.put(topic, info)) != null) {
            this.log.info("updateTopicPublishInfo prev is not null, " + prev.toString());
        }
    }

    @Override
    public boolean isUnitMode() {
        return this.defaultMQProducer.isUnitMode();
    }

    public void createTopic(String key, String newTopic, int queueNum) throws MQClientException {
        this.createTopic(key, newTopic, queueNum, 0);
    }

    public void createTopic(String key, String newTopic, int queueNum, int topicSysFlag) throws MQClientException {
        this.makeSureStateOK();
        Validators.checkTopic(newTopic);
        this.mQClientFactory.getMQAdminImpl().createTopic(key, newTopic, queueNum, topicSysFlag);
    }

    private void makeSureStateOK() throws MQClientException {
        if (this.serviceState != ServiceState.RUNNING) {
            throw new MQClientException("The producer service state not OK, " + this.serviceState + FAQUrl.suggestTodo((String)"http://his.huawei.com/ump/#/help/faq/"), null);
        }
    }

    public List<MessageQueue> fetchPublishMessageQueues(String topic) throws MQClientException {
        this.makeSureStateOK();
        return this.mQClientFactory.getMQAdminImpl().fetchPublishMessageQueues(topic);
    }

    public long searchOffset(MessageQueue mq, long timestamp) throws MQClientException {
        this.makeSureStateOK();
        return this.mQClientFactory.getMQAdminImpl().searchOffset(mq, timestamp);
    }

    public long maxOffset(MessageQueue mq) throws MQClientException {
        this.makeSureStateOK();
        return this.mQClientFactory.getMQAdminImpl().maxOffset(mq);
    }

    public long minOffset(MessageQueue mq) throws MQClientException {
        this.makeSureStateOK();
        return this.mQClientFactory.getMQAdminImpl().minOffset(mq);
    }

    public long earliestMsgStoreTime(MessageQueue mq) throws MQClientException {
        this.makeSureStateOK();
        return this.mQClientFactory.getMQAdminImpl().earliestMsgStoreTime(mq);
    }

    public MessageExt viewMessage(String msgId) throws RemotingException, MQBrokerException, InterruptedException, MQClientException {
        this.makeSureStateOK();
        return this.mQClientFactory.getMQAdminImpl().viewMessage(msgId);
    }

    public QueryResult queryMessage(String topic, String key, int maxNum, long begin, long end) throws MQClientException, InterruptedException {
        this.makeSureStateOK();
        return this.mQClientFactory.getMQAdminImpl().queryMessage(topic, key, maxNum, begin, end);
    }

    public MessageExt queryMessageByUniqKey(String topic, String uniqKey) throws MQClientException, InterruptedException {
        this.makeSureStateOK();
        return this.mQClientFactory.getMQAdminImpl().queryMessageByUniqKey(topic, uniqKey);
    }

    public void send(Message msg, SendCallback sendCallback) throws MQClientException, RemotingException, InterruptedException {
        this.send(msg, sendCallback, (long)this.defaultMQProducer.getSendMsgTimeout());
    }

    @Deprecated
    public void send(final Message msg, final SendCallback sendCallback, final long timeout) throws MQClientException, RemotingException, InterruptedException {
        final long beginStartTime = System.currentTimeMillis();
        ExecutorService executor = this.getAsyncSenderExecutor();
        try {
            executor.submit(new Runnable(){

                @Override
                public void run() {
                    long costTime = System.currentTimeMillis() - beginStartTime;
                    if (timeout > costTime) {
                        try {
                            DefaultMQProducerImpl.this.sendDefaultImpl(msg, CommunicationMode.ASYNC, sendCallback, timeout - costTime);
                        }
                        catch (Exception e) {
                            sendCallback.onException(e);
                        }
                    } else {
                        sendCallback.onException((Throwable)new RemotingTooMuchRequestException("DEFAULT ASYNC send call timeout"));
                    }
                }
            });
        }
        catch (RejectedExecutionException e) {
            throw new MQClientException("executor rejected ", e);
        }
    }

    public MessageQueue selectOneMessageQueue(TopicPublishInfo tpInfo, String lastBrokerName) {
        return this.mqFaultStrategy.selectOneMessageQueue(tpInfo, lastBrokerName);
    }

    public void updateFaultItem(String brokerName, long currentLatency, boolean isolation) {
        this.mqFaultStrategy.updateFaultItem(brokerName, currentLatency, isolation);
    }

    private void validateNameServerSetting() throws MQClientException {
        List<String> nsList = this.getmQClientFactory().getMQClientAPIImpl().getNameServerAddressList();
        if (null == nsList || nsList.isEmpty()) {
            throw new MQClientException("No name server address, please set it." + FAQUrl.suggestTodo((String)"http://his.huawei.com/ump/#/help/faq/"), null).setResponseCode(10004);
        }
    }

    private SendResult sendDefaultImpl(Message msg, CommunicationMode communicationMode, SendCallback sendCallback, long timeout) throws MQClientException, RemotingException, MQBrokerException, InterruptedException {
        long beginTimestampFirst;
        this.makeSureStateOK();
        Validators.checkMessage(msg, this.defaultMQProducer);
        long invokeID = this.random.nextLong();
        long beginTimestampPrev = beginTimestampFirst = System.currentTimeMillis();
        long endTimestamp = beginTimestampFirst;
        TopicPublishInfo topicPublishInfo = this.tryToFindTopicPublishInfo(msg.getTopic());
        if (topicPublishInfo != null && topicPublishInfo.ok()) {
            String lastBrokerName;
            MessageQueue mqSelected;
            int times;
            boolean callTimeout = false;
            MessageQueue mq = null;
            Throwable exception = null;
            SendResult sendResult = null;
            int timesTotal = communicationMode == CommunicationMode.SYNC ? 1 + this.defaultMQProducer.getRetryTimesWhenSendFailed() : 1;
            Object[] brokersSent = new String[timesTotal];
            block13: for (times = 0; times < timesTotal && (mqSelected = this.selectOneMessageQueue(topicPublishInfo, lastBrokerName = null == mq ? null : mq.getBrokerName())) != null; ++times) {
                mq = mqSelected;
                brokersSent[times] = mq.getBrokerName();
                try {
                    long costTime;
                    beginTimestampPrev = System.currentTimeMillis();
                    if (times > 0) {
                        msg.setTopic(this.defaultMQProducer.withNamespace(msg.getTopic()));
                    }
                    if (timeout < (costTime = beginTimestampPrev - beginTimestampFirst)) {
                        callTimeout = true;
                        break;
                    }
                    sendResult = this.sendKernelImpl(msg, mq, communicationMode, sendCallback, topicPublishInfo, timeout - costTime);
                    endTimestamp = System.currentTimeMillis();
                    this.updateFaultItem(mq.getBrokerName(), endTimestamp - beginTimestampPrev, false);
                    switch (communicationMode) {
                        case ASYNC: {
                            return null;
                        }
                        case ONEWAY: {
                            return null;
                        }
                        case SYNC: {
                            if (sendResult.getSendStatus() != SendStatus.SEND_OK && this.defaultMQProducer.isRetryAnotherBrokerWhenNotStoreOK()) break;
                            return sendResult;
                        }
                    }
                    continue;
                }
                catch (RemotingException e) {
                    endTimestamp = System.currentTimeMillis();
                    this.updateFaultItem(mq.getBrokerName(), endTimestamp - beginTimestampPrev, true);
                    this.log.warn(String.format("sendKernelImpl exception, resend at once, InvokeID: %s, RT: %sms, Broker: %s", invokeID, endTimestamp - beginTimestampPrev, mq), (Throwable)e);
                    this.log.warn(msg.toString());
                    exception = e;
                    continue;
                }
                catch (MQClientException e) {
                    endTimestamp = System.currentTimeMillis();
                    this.updateFaultItem(mq.getBrokerName(), endTimestamp - beginTimestampPrev, true);
                    this.log.warn(String.format("sendKernelImpl exception, resend at once, InvokeID: %s, RT: %sms, Broker: %s", invokeID, endTimestamp - beginTimestampPrev, mq), (Throwable)e);
                    this.log.warn(msg.toString());
                    exception = e;
                    continue;
                }
                catch (MQBrokerException e) {
                    endTimestamp = System.currentTimeMillis();
                    this.updateFaultItem(mq.getBrokerName(), endTimestamp - beginTimestampPrev, true);
                    this.log.warn(String.format("sendKernelImpl exception, resend at once, InvokeID: %s, RT: %sms, Broker: %s", invokeID, endTimestamp - beginTimestampPrev, mq), (Throwable)e);
                    this.log.warn(msg.toString());
                    exception = e;
                    switch (e.getResponseCode()) {
                        case 1: 
                        case 14: 
                        case 16: 
                        case 17: 
                        case 204: 
                        case 205: {
                            continue block13;
                        }
                        default: {
                            if (sendResult != null) {
                                return sendResult;
                            }
                            throw e;
                        }
                    }
                }
                catch (InterruptedException e) {
                    endTimestamp = System.currentTimeMillis();
                    this.updateFaultItem(mq.getBrokerName(), endTimestamp - beginTimestampPrev, false);
                    this.log.warn(String.format("sendKernelImpl exception, throw exception, InvokeID: %s, RT: %sms, Broker: %s", invokeID, endTimestamp - beginTimestampPrev, mq), (Throwable)e);
                    this.log.warn(msg.toString());
                    this.log.warn("sendKernelImpl exception", (Throwable)e);
                    this.log.warn(msg.toString());
                    throw e;
                }
            }
            if (sendResult != null) {
                return sendResult;
            }
            String info = String.format("Send [%d] times, still failed, cost [%d]ms, Topic: %s, BrokersSent: %s", times, System.currentTimeMillis() - beginTimestampFirst, msg.getTopic(), Arrays.toString(brokersSent));
            info = info + FAQUrl.suggestTodo((String)"http://his.huawei.com/ump/#/help/faq/");
            MQClientException mqClientException = new MQClientException(info, exception);
            if (callTimeout) {
                throw new RemotingTooMuchRequestException("sendDefaultImpl call timeout");
            }
            if (exception instanceof MQBrokerException) {
                mqClientException.setResponseCode(((MQBrokerException)exception).getResponseCode());
            } else if (exception instanceof RemotingConnectException) {
                mqClientException.setResponseCode(10001);
            } else if (exception instanceof RemotingTimeoutException) {
                mqClientException.setResponseCode(10002);
            } else if (exception instanceof MQClientException) {
                mqClientException.setResponseCode(10003);
            }
            throw mqClientException;
        }
        this.validateNameServerSetting();
        throw new MQClientException("No route info of this topic: " + msg.getTopic() + FAQUrl.suggestTodo((String)"http://his.huawei.com/ump/#/help/faq/"), null).setResponseCode(10005);
    }

    private TopicPublishInfo tryToFindTopicPublishInfo(String topic) {
        TopicPublishInfo topicPublishInfo = (TopicPublishInfo)this.topicPublishInfoTable.get(topic);
        if (null == topicPublishInfo || !topicPublishInfo.ok()) {
            this.topicPublishInfoTable.putIfAbsent(topic, new TopicPublishInfo());
            this.mQClientFactory.updateTopicRouteInfoFromNameServer(topic);
            topicPublishInfo = (TopicPublishInfo)this.topicPublishInfoTable.get(topic);
        }
        if (topicPublishInfo.isHaveTopicRouterInfo() || topicPublishInfo.ok()) {
            return topicPublishInfo;
        }
        return null;
    }

    private SendResult sendKernelImpl(Message msg, MessageQueue mq, CommunicationMode communicationMode, SendCallback sendCallback, TopicPublishInfo topicPublishInfo, long timeout) throws MQClientException, RemotingException, MQBrokerException, InterruptedException {
        long beginStartTime = System.currentTimeMillis();
        String brokerAddr = this.mQClientFactory.findBrokerAddressInPublish(mq.getBrokerName());
        if (null == brokerAddr) {
            this.tryToFindTopicPublishInfo(mq.getTopic());
            brokerAddr = this.mQClientFactory.findBrokerAddressInPublish(mq.getBrokerName());
        }
        SendMessageContext context = null;
        if (brokerAddr != null) {
            brokerAddr = MixAll.brokerVIPChannel((boolean)this.defaultMQProducer.isSendMessageWithVIPChannel(), (String)brokerAddr);
            byte[] prevBody = msg.getBody();
            try {
                String tranMsg;
                if (!(msg instanceof MessageBatch)) {
                    MessageClientIDSetter.setUniqID((Message)msg);
                }
                boolean topicWithNamespace = false;
                if (null != this.mQClientFactory.getClientConfig().getNamespace()) {
                    msg.setInstanceId(this.mQClientFactory.getClientConfig().getNamespace());
                    topicWithNamespace = true;
                }
                int sysFlag = 0;
                boolean msgBodyCompressed = false;
                if (this.tryToCompressMessage(msg)) {
                    sysFlag |= 1;
                    msgBodyCompressed = true;
                }
                if ((tranMsg = msg.getProperty("TRAN_MSG")) != null && Boolean.parseBoolean(tranMsg)) {
                    sysFlag |= 4;
                }
                if (this.hasCheckForbiddenHook()) {
                    CheckForbiddenContext checkForbiddenContext = new CheckForbiddenContext();
                    checkForbiddenContext.setNameSrvAddr(this.defaultMQProducer.getNamesrvAddr());
                    checkForbiddenContext.setGroup(this.defaultMQProducer.getProducerGroup());
                    checkForbiddenContext.setCommunicationMode(communicationMode);
                    checkForbiddenContext.setBrokerAddr(brokerAddr);
                    checkForbiddenContext.setMessage(msg);
                    checkForbiddenContext.setMq(mq);
                    checkForbiddenContext.setUnitMode(this.isUnitMode());
                    this.executeCheckForbiddenHook(checkForbiddenContext);
                }
                if (this.hasSendMessageHook()) {
                    context = new SendMessageContext();
                    context.setProducer(this);
                    context.setProducerGroup(this.defaultMQProducer.getProducerGroup());
                    context.setCommunicationMode(communicationMode);
                    context.setBornHost(this.defaultMQProducer.getClientIP());
                    context.setBrokerAddr(brokerAddr);
                    context.setMessage(msg);
                    context.setMq(mq);
                    context.setNamespace(this.defaultMQProducer.getNamespace());
                    String isTrans = msg.getProperty("TRAN_MSG");
                    if (isTrans != null && isTrans.equals("true")) {
                        context.setMsgType(MessageType.Trans_Msg_Half);
                    }
                    if (msg.getProperty("__STARTDELIVERTIME") != null || msg.getProperty("DELAY") != null) {
                        context.setMsgType(MessageType.Delay_Msg);
                    }
                    this.executeSendMessageHookBefore(context);
                }
                SendMessageRequestHeader requestHeader = new SendMessageRequestHeader();
                requestHeader.setProducerGroup(this.defaultMQProducer.getProducerGroup());
                requestHeader.setTopic(msg.getTopic());
                requestHeader.setDefaultTopic(this.defaultMQProducer.getCreateTopicKey());
                requestHeader.setDefaultTopicQueueNums(Integer.valueOf(this.defaultMQProducer.getDefaultTopicQueueNums()));
                requestHeader.setQueueId(Integer.valueOf(mq.getQueueId()));
                requestHeader.setSysFlag(Integer.valueOf(sysFlag));
                requestHeader.setBornTimestamp(Long.valueOf(System.currentTimeMillis()));
                requestHeader.setFlag(Integer.valueOf(msg.getFlag()));
                requestHeader.setProperties(MessageDecoder.messageProperties2String((Map)msg.getProperties()));
                requestHeader.setReconsumeTimes(Integer.valueOf(0));
                requestHeader.setUnitMode(this.isUnitMode());
                requestHeader.setBatch(msg instanceof MessageBatch);
                if (requestHeader.getTopic().startsWith("%RETRY%")) {
                    String maxReconsumeTimes;
                    String reconsumeTimes = MessageAccessor.getReconsumeTime((Message)msg);
                    if (reconsumeTimes != null) {
                        requestHeader.setReconsumeTimes(Integer.valueOf(reconsumeTimes));
                        MessageAccessor.clearProperty((Message)msg, (String)"RECONSUME_TIME");
                    }
                    if ((maxReconsumeTimes = MessageAccessor.getMaxReconsumeTimes((Message)msg)) != null) {
                        requestHeader.setMaxReconsumeTimes(Integer.valueOf(maxReconsumeTimes));
                        MessageAccessor.clearProperty((Message)msg, (String)"MAX_RECONSUME_TIMES");
                    }
                }
                SendResult sendResult = null;
                switch (communicationMode) {
                    case ASYNC: {
                        long costTimeAsync;
                        Message tmpMessage = msg;
                        boolean messageCloned = false;
                        if (msgBodyCompressed) {
                            tmpMessage = MessageAccessor.cloneMessage((Message)msg);
                            messageCloned = true;
                            msg.setBody(prevBody);
                        }
                        if (topicWithNamespace) {
                            if (!messageCloned) {
                                tmpMessage = MessageAccessor.cloneMessage((Message)msg);
                                messageCloned = true;
                            }
                            msg.setTopic(NamespaceUtil.withoutNamespace((String)msg.getTopic(), (String)this.defaultMQProducer.getNamespace()));
                        }
                        if (timeout < (costTimeAsync = System.currentTimeMillis() - beginStartTime)) {
                            throw new RemotingTooMuchRequestException("sendKernelImpl call timeout");
                        }
                        sendResult = this.mQClientFactory.getMQClientAPIImpl().sendMessage(brokerAddr, mq.getBrokerName(), tmpMessage, requestHeader, timeout - costTimeAsync, communicationMode, sendCallback, topicPublishInfo, this.mQClientFactory, this.defaultMQProducer.getRetryTimesWhenSendAsyncFailed(), context, this);
                        break;
                    }
                    case ONEWAY: 
                    case SYNC: {
                        long costTimeSync = System.currentTimeMillis() - beginStartTime;
                        if (timeout < costTimeSync) {
                            throw new RemotingTooMuchRequestException("sendKernelImpl call timeout");
                        }
                        sendResult = this.mQClientFactory.getMQClientAPIImpl().sendMessage(brokerAddr, mq.getBrokerName(), msg, requestHeader, timeout - costTimeSync, communicationMode, context, this);
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
                if (this.hasSendMessageHook()) {
                    context.setSendResult(sendResult);
                    this.executeSendMessageHookAfter(context);
                }
                SendResult sendResult2 = sendResult;
                return sendResult2;
            }
            catch (RemotingException e) {
                if (this.hasSendMessageHook()) {
                    context.setException((Exception)((Object)e));
                    this.executeSendMessageHookAfter(context);
                }
                throw e;
            }
            catch (MQBrokerException e) {
                if (this.hasSendMessageHook()) {
                    context.setException(e);
                    this.executeSendMessageHookAfter(context);
                }
                throw e;
            }
            catch (InterruptedException e) {
                if (this.hasSendMessageHook()) {
                    context.setException(e);
                    this.executeSendMessageHookAfter(context);
                }
                throw e;
            }
            finally {
                msg.setBody(prevBody);
                msg.setTopic(NamespaceUtil.withoutNamespace((String)msg.getTopic(), (String)this.defaultMQProducer.getNamespace()));
            }
        }
        throw new MQClientException("The broker[" + mq.getBrokerName() + "] not exist", null);
    }

    public MQClientInstance getmQClientFactory() {
        return this.mQClientFactory;
    }

    private boolean tryToCompressMessage(Message msg) {
        if (msg instanceof MessageBatch) {
            return false;
        }
        byte[] body = msg.getBody();
        if (body != null && body.length >= this.defaultMQProducer.getCompressMsgBodyOverHowmuch()) {
            try {
                byte[] data = UtilAll.compress((byte[])body, (int)this.zipCompressLevel);
                if (data != null) {
                    msg.setBody(data);
                    return true;
                }
            }
            catch (IOException e) {
                this.log.error("tryToCompressMessage exception", (Throwable)e);
                this.log.warn(msg.toString());
            }
        }
        return false;
    }

    public boolean hasCheckForbiddenHook() {
        return !this.checkForbiddenHookList.isEmpty();
    }

    public void executeCheckForbiddenHook(CheckForbiddenContext context) throws MQClientException {
        if (this.hasCheckForbiddenHook()) {
            for (CheckForbiddenHook hook : this.checkForbiddenHookList) {
                hook.checkForbidden(context);
            }
        }
    }

    public boolean hasSendMessageHook() {
        return !this.sendMessageHookList.isEmpty();
    }

    public void executeSendMessageHookBefore(SendMessageContext context) {
        if (!this.sendMessageHookList.isEmpty()) {
            for (SendMessageHook hook : this.sendMessageHookList) {
                try {
                    hook.sendMessageBefore(context);
                }
                catch (Throwable e) {
                    this.log.warn("failed to executeSendMessageHookBefore", e);
                }
            }
        }
    }

    public void executeSendMessageHookAfter(SendMessageContext context) {
        if (!this.sendMessageHookList.isEmpty()) {
            for (SendMessageHook hook : this.sendMessageHookList) {
                try {
                    hook.sendMessageAfter(context);
                }
                catch (Throwable e) {
                    this.log.warn("failed to executeSendMessageHookAfter", e);
                }
            }
        }
    }

    public void sendOneway(Message msg) throws MQClientException, RemotingException, InterruptedException {
        try {
            this.sendDefaultImpl(msg, CommunicationMode.ONEWAY, null, this.defaultMQProducer.getSendMsgTimeout());
        }
        catch (MQBrokerException e) {
            throw new MQClientException("unknown exception", e);
        }
    }

    public SendResult send(Message msg, MessageQueue mq) throws MQClientException, RemotingException, MQBrokerException, InterruptedException {
        return this.send(msg, mq, (long)this.defaultMQProducer.getSendMsgTimeout());
    }

    public SendResult send(Message msg, MessageQueue mq, long timeout) throws MQClientException, RemotingException, MQBrokerException, InterruptedException {
        long beginStartTime = System.currentTimeMillis();
        this.makeSureStateOK();
        Validators.checkMessage(msg, this.defaultMQProducer);
        if (!msg.getTopic().equals(mq.getTopic())) {
            throw new MQClientException("message's topic not equal mq's topic", null);
        }
        long costTime = System.currentTimeMillis() - beginStartTime;
        if (timeout < costTime) {
            throw new RemotingTooMuchRequestException("call timeout");
        }
        return this.sendKernelImpl(msg, mq, CommunicationMode.SYNC, null, null, timeout);
    }

    public void send(Message msg, MessageQueue mq, SendCallback sendCallback) throws MQClientException, RemotingException, InterruptedException {
        this.send(msg, mq, sendCallback, (long)this.defaultMQProducer.getSendMsgTimeout());
    }

    @Deprecated
    public void send(final Message msg, final MessageQueue mq, final SendCallback sendCallback, final long timeout) throws MQClientException, RemotingException, InterruptedException {
        final long beginStartTime = System.currentTimeMillis();
        ExecutorService executor = this.getAsyncSenderExecutor();
        try {
            executor.submit(new Runnable(){

                @Override
                public void run() {
                    block6: {
                        try {
                            DefaultMQProducerImpl.this.makeSureStateOK();
                            Validators.checkMessage(msg, DefaultMQProducerImpl.this.defaultMQProducer);
                            if (!msg.getTopic().equals(mq.getTopic())) {
                                throw new MQClientException("message's topic not equal mq's topic", null);
                            }
                            long costTime = System.currentTimeMillis() - beginStartTime;
                            if (timeout > costTime) {
                                try {
                                    DefaultMQProducerImpl.this.sendKernelImpl(msg, mq, CommunicationMode.ASYNC, sendCallback, null, timeout - costTime);
                                    break block6;
                                }
                                catch (MQBrokerException e) {
                                    throw new MQClientException("unknown exception", e);
                                }
                            }
                            sendCallback.onException((Throwable)new RemotingTooMuchRequestException("call timeout"));
                        }
                        catch (Exception e) {
                            sendCallback.onException(e);
                        }
                    }
                }
            });
        }
        catch (RejectedExecutionException e) {
            throw new MQClientException("executor rejected ", e);
        }
    }

    public void sendOneway(Message msg, MessageQueue mq) throws MQClientException, RemotingException, InterruptedException {
        this.makeSureStateOK();
        Validators.checkMessage(msg, this.defaultMQProducer);
        try {
            this.sendKernelImpl(msg, mq, CommunicationMode.ONEWAY, null, null, this.defaultMQProducer.getSendMsgTimeout());
        }
        catch (MQBrokerException e) {
            throw new MQClientException("unknown exception", e);
        }
    }

    public SendResult send(Message msg, MessageQueueSelector selector, Object arg) throws MQClientException, RemotingException, MQBrokerException, InterruptedException {
        return this.send(msg, selector, arg, (long)this.defaultMQProducer.getSendMsgTimeout());
    }

    public SendResult send(Message msg, MessageQueueSelector selector, Object arg, long timeout) throws MQClientException, RemotingException, MQBrokerException, InterruptedException {
        return this.sendSelectImpl(msg, selector, arg, CommunicationMode.SYNC, null, timeout);
    }

    private SendResult sendSelectImpl(Message msg, MessageQueueSelector selector, Object arg, CommunicationMode communicationMode, SendCallback sendCallback, long timeout) throws MQClientException, RemotingException, MQBrokerException, InterruptedException {
        long beginStartTime = System.currentTimeMillis();
        this.makeSureStateOK();
        Validators.checkMessage(msg, this.defaultMQProducer);
        TopicPublishInfo topicPublishInfo = this.tryToFindTopicPublishInfo(msg.getTopic());
        if (topicPublishInfo != null && topicPublishInfo.ok()) {
            MessageQueue mq = null;
            try {
                List<MessageQueue> messageQueueList = this.mQClientFactory.getMQAdminImpl().parsePublishMessageQueues(topicPublishInfo.getMessageQueueList());
                Message userMessage = MessageAccessor.cloneMessage((Message)msg);
                String userTopic = NamespaceUtil.withoutNamespace((String)userMessage.getTopic(), (String)this.mQClientFactory.getClientConfig().getNamespace());
                userMessage.setTopic(userTopic);
                mq = this.mQClientFactory.getClientConfig().queueWithNamespace(selector.select(messageQueueList, userMessage, arg));
            }
            catch (Throwable e) {
                throw new MQClientException("select message queue throwed exception.", e);
            }
            long costTime = System.currentTimeMillis() - beginStartTime;
            if (timeout < costTime) {
                throw new RemotingTooMuchRequestException("sendSelectImpl call timeout");
            }
            if (mq != null) {
                return this.sendKernelImpl(msg, mq, communicationMode, sendCallback, null, timeout - costTime);
            }
            throw new MQClientException("select message queue return null.", null);
        }
        this.validateNameServerSetting();
        throw new MQClientException("No route info for this topic, " + msg.getTopic(), null);
    }

    public void send(Message msg, MessageQueueSelector selector, Object arg, SendCallback sendCallback) throws MQClientException, RemotingException, InterruptedException {
        this.send(msg, selector, arg, sendCallback, this.defaultMQProducer.getSendMsgTimeout());
    }

    @Deprecated
    public void send(final Message msg, final MessageQueueSelector selector, final Object arg, final SendCallback sendCallback, final long timeout) throws MQClientException, RemotingException, InterruptedException {
        final long beginStartTime = System.currentTimeMillis();
        ExecutorService executor = this.getAsyncSenderExecutor();
        try {
            executor.submit(new Runnable(){

                @Override
                public void run() {
                    long costTime = System.currentTimeMillis() - beginStartTime;
                    if (timeout > costTime) {
                        try {
                            try {
                                DefaultMQProducerImpl.this.sendSelectImpl(msg, selector, arg, CommunicationMode.ASYNC, sendCallback, timeout - costTime);
                            }
                            catch (MQBrokerException e) {
                                throw new MQClientException("unknownn exception", e);
                            }
                        }
                        catch (Exception e) {
                            sendCallback.onException(e);
                        }
                    } else {
                        sendCallback.onException((Throwable)new RemotingTooMuchRequestException("call timeout"));
                    }
                }
            });
        }
        catch (RejectedExecutionException e) {
            throw new MQClientException("exector rejected ", e);
        }
    }

    public void sendOneway(Message msg, MessageQueueSelector selector, Object arg) throws MQClientException, RemotingException, InterruptedException {
        try {
            this.sendSelectImpl(msg, selector, arg, CommunicationMode.ONEWAY, null, this.defaultMQProducer.getSendMsgTimeout());
        }
        catch (MQBrokerException e) {
            throw new MQClientException("unknown exception", e);
        }
    }

    public TransactionSendResult sendMessageInTransaction(Message msg, LocalTransactionExecuter localTransactionExecuter, Object arg) throws MQClientException {
        TransactionListener transactionListener = this.getCheckListener();
        if (null == localTransactionExecuter && null == transactionListener) {
            throw new MQClientException("tranExecutor is null", null);
        }
        if (msg.getDelayTimeLevel() != 0) {
            MessageAccessor.clearProperty((Message)msg, (String)"DELAY");
        }
        Validators.checkMessage(msg, this.defaultMQProducer);
        SendResult sendResult = null;
        MessageAccessor.putProperty((Message)msg, (String)"TRAN_MSG", (String)"true");
        MessageAccessor.putProperty((Message)msg, (String)"PGROUP", (String)this.defaultMQProducer.getProducerGroup());
        try {
            sendResult = this.send(msg);
        }
        catch (Exception e) {
            throw new MQClientException("send message Exception", e);
        }
        LocalTransactionState localTransactionState = LocalTransactionState.UNKNOW;
        Throwable localException = null;
        switch (sendResult.getSendStatus()) {
            case SEND_OK: {
                try {
                    String transactionId;
                    if (sendResult.getTransactionId() != null) {
                        msg.putUserProperty("__transactionId__", sendResult.getTransactionId());
                    }
                    if (null != (transactionId = msg.getProperty("UNIQ_KEY")) && !"".equals(transactionId)) {
                        msg.setTransactionId(transactionId);
                    }
                    if (null != localTransactionExecuter) {
                        localTransactionState = localTransactionExecuter.executeLocalTransactionBranch(msg, arg);
                    } else if (transactionListener != null) {
                        this.log.debug("Used new transaction API");
                        localTransactionState = transactionListener.executeLocalTransaction(msg, arg);
                    }
                    if (null == localTransactionState) {
                        localTransactionState = LocalTransactionState.UNKNOW;
                    }
                    if (localTransactionState == LocalTransactionState.COMMIT_MESSAGE) break;
                    this.log.info("executeLocalTransactionBranch return {}", (Object)localTransactionState);
                    this.log.info(msg.toString());
                }
                catch (Throwable e) {
                    this.log.info("executeLocalTransactionBranch exception", e);
                    this.log.info(msg.toString());
                    localException = e;
                }
                break;
            }
            case FLUSH_DISK_TIMEOUT: 
            case FLUSH_SLAVE_TIMEOUT: 
            case SLAVE_NOT_AVAILABLE: {
                localTransactionState = LocalTransactionState.ROLLBACK_MESSAGE;
                break;
            }
        }
        try {
            this.endTransaction(sendResult, localTransactionState, localException);
        }
        catch (Exception e) {
            this.log.warn("local transaction execute " + (Object)((Object)localTransactionState) + ", but end broker transaction failed", (Throwable)e);
        }
        TransactionSendResult transactionSendResult = new TransactionSendResult();
        transactionSendResult.setSendStatus(sendResult.getSendStatus());
        transactionSendResult.setMessageQueue(sendResult.getMessageQueue());
        transactionSendResult.setMsgId(sendResult.getMsgId());
        transactionSendResult.setQueueOffset(sendResult.getQueueOffset());
        transactionSendResult.setTransactionId(sendResult.getTransactionId());
        transactionSendResult.setLocalTransactionState(localTransactionState);
        return transactionSendResult;
    }

    public SendResult send(Message msg) throws MQClientException, RemotingException, MQBrokerException, InterruptedException {
        return this.send(msg, this.defaultMQProducer.getSendMsgTimeout());
    }

    public void endTransaction(SendResult sendResult, LocalTransactionState localTransactionState, Throwable localException) throws RemotingException, MQBrokerException, InterruptedException, UnknownHostException {
        MessageId id = sendResult.getOffsetMsgId() != null ? MessageDecoder.decodeMessageId((String)sendResult.getOffsetMsgId()) : MessageDecoder.decodeMessageId((String)sendResult.getMsgId());
        String transactionId = sendResult.getTransactionId();
        String brokerAddr = this.mQClientFactory.findBrokerAddressInPublish(sendResult.getMessageQueue().getBrokerName());
        EndTransactionRequestHeader requestHeader = new EndTransactionRequestHeader();
        requestHeader.setTransactionId(transactionId);
        requestHeader.setCommitLogOffset(Long.valueOf(id.getOffset()));
        switch (localTransactionState) {
            case COMMIT_MESSAGE: {
                requestHeader.setCommitOrRollback(Integer.valueOf(8));
                break;
            }
            case ROLLBACK_MESSAGE: {
                requestHeader.setCommitOrRollback(Integer.valueOf(12));
                break;
            }
            case UNKNOW: {
                requestHeader.setCommitOrRollback(Integer.valueOf(0));
                break;
            }
        }
        requestHeader.setProducerGroup(this.defaultMQProducer.getProducerGroup());
        requestHeader.setTranStateTableOffset(Long.valueOf(sendResult.getQueueOffset()));
        requestHeader.setMsgId(sendResult.getMsgId());
        String remark = localException != null ? "executeLocalTransactionBranch exception: " + localException.toString() : null;
        this.mQClientFactory.getMQClientAPIImpl().endTransactionOneway(brokerAddr, requestHeader, remark, this.defaultMQProducer.getSendMsgTimeout());
    }

    public void setCallbackExecutor(ExecutorService callbackExecutor) {
        this.mQClientFactory.getMQClientAPIImpl().getRemotingClient().setCallbackExecutor(callbackExecutor);
    }

    public ExecutorService getAsyncSenderExecutor() {
        return null == this.asyncSenderExecutor ? this.defaultAsyncSenderExecutor : this.asyncSenderExecutor;
    }

    public void setAsyncSenderExecutor(ExecutorService asyncSenderExecutor) {
        this.asyncSenderExecutor = asyncSenderExecutor;
    }

    public SendResult send(Message msg, long timeout) throws MQClientException, RemotingException, MQBrokerException, InterruptedException {
        return this.sendDefaultImpl(msg, CommunicationMode.SYNC, null, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message request(Message msg, long timeout) throws RequestTimeoutException, MQClientException, RemotingException, MQBrokerException, InterruptedException {
        long beginTimestamp = System.currentTimeMillis();
        this.prepareSendRequest(msg, timeout);
        String correlationId = msg.getProperty("CORRELATION_ID");
        try {
            final RequestResponseFuture requestResponseFuture = new RequestResponseFuture(correlationId, timeout, null);
            RequestFutureTable.getRequestFutureTable().put(correlationId, requestResponseFuture);
            long cost = System.currentTimeMillis() - beginTimestamp;
            this.sendDefaultImpl(msg, CommunicationMode.ASYNC, new SendCallback(){

                @Override
                public void onSuccess(SendResult sendResult) {
                    requestResponseFuture.setSendReqeustOk(true);
                }

                @Override
                public void onException(Throwable e) {
                    requestResponseFuture.setSendReqeustOk(false);
                    requestResponseFuture.putResponseMessage(null);
                    requestResponseFuture.setCause(e);
                }
            }, timeout - cost);
            Message responseMessage = requestResponseFuture.waitResponseMessage(timeout - cost);
            if (responseMessage == null) {
                if (requestResponseFuture.isSendRequestOk()) {
                    throw new RequestTimeoutException(10006, "send request message to <" + msg.getTopic() + "> OK, but wait reply message timeout, " + timeout + " ms.");
                }
                throw new MQClientException("send request message to <" + msg.getTopic() + "> fail", requestResponseFuture.getCause());
            }
            Message message = responseMessage;
            return message;
        }
        finally {
            RequestFutureTable.getRequestFutureTable().remove(correlationId);
        }
    }

    public void request(Message msg, RequestCallback requestCallback, long timeout) throws RemotingException, InterruptedException, MQClientException, MQBrokerException {
        long beginTimestamp = System.currentTimeMillis();
        this.prepareSendRequest(msg, timeout);
        final String correlationId = msg.getProperty("CORRELATION_ID");
        final RequestResponseFuture requestResponseFuture = new RequestResponseFuture(correlationId, timeout, requestCallback);
        RequestFutureTable.getRequestFutureTable().put(correlationId, requestResponseFuture);
        long cost = System.currentTimeMillis() - beginTimestamp;
        this.sendDefaultImpl(msg, CommunicationMode.ASYNC, new SendCallback(){

            @Override
            public void onSuccess(SendResult sendResult) {
                requestResponseFuture.setSendReqeustOk(true);
            }

            @Override
            public void onException(Throwable e) {
                requestResponseFuture.setCause(e);
                DefaultMQProducerImpl.this.requestFail(correlationId);
            }
        }, timeout - cost);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message request(Message msg, MessageQueueSelector selector, Object arg, long timeout) throws MQClientException, RemotingException, MQBrokerException, InterruptedException, RequestTimeoutException {
        long beginTimestamp = System.currentTimeMillis();
        this.prepareSendRequest(msg, timeout);
        String correlationId = msg.getProperty("CORRELATION_ID");
        try {
            final RequestResponseFuture requestResponseFuture = new RequestResponseFuture(correlationId, timeout, null);
            RequestFutureTable.getRequestFutureTable().put(correlationId, requestResponseFuture);
            long cost = System.currentTimeMillis() - beginTimestamp;
            this.sendSelectImpl(msg, selector, arg, CommunicationMode.ASYNC, new SendCallback(){

                @Override
                public void onSuccess(SendResult sendResult) {
                    requestResponseFuture.setSendReqeustOk(true);
                }

                @Override
                public void onException(Throwable e) {
                    requestResponseFuture.setSendReqeustOk(false);
                    requestResponseFuture.putResponseMessage(null);
                    requestResponseFuture.setCause(e);
                }
            }, timeout - cost);
            Message responseMessage = requestResponseFuture.waitResponseMessage(timeout - cost);
            if (responseMessage == null) {
                if (requestResponseFuture.isSendRequestOk()) {
                    throw new RequestTimeoutException(10006, "send request message to <" + msg.getTopic() + "> OK, but wait reply message timeout, " + timeout + " ms.");
                }
                throw new MQClientException("send request message to <" + msg.getTopic() + "> fail", requestResponseFuture.getCause());
            }
            Message message = responseMessage;
            return message;
        }
        finally {
            RequestFutureTable.getRequestFutureTable().remove(correlationId);
        }
    }

    public void request(Message msg, MessageQueueSelector selector, Object arg, RequestCallback requestCallback, long timeout) throws RemotingException, InterruptedException, MQClientException, MQBrokerException {
        long beginTimestamp = System.currentTimeMillis();
        this.prepareSendRequest(msg, timeout);
        final String correlationId = msg.getProperty("CORRELATION_ID");
        final RequestResponseFuture requestResponseFuture = new RequestResponseFuture(correlationId, timeout, requestCallback);
        RequestFutureTable.getRequestFutureTable().put(correlationId, requestResponseFuture);
        long cost = System.currentTimeMillis() - beginTimestamp;
        this.sendSelectImpl(msg, selector, arg, CommunicationMode.ASYNC, new SendCallback(){

            @Override
            public void onSuccess(SendResult sendResult) {
                requestResponseFuture.setSendReqeustOk(true);
            }

            @Override
            public void onException(Throwable e) {
                requestResponseFuture.setCause(e);
                DefaultMQProducerImpl.this.requestFail(correlationId);
            }
        }, timeout - cost);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message request(Message msg, MessageQueue mq, long timeout) throws MQClientException, RemotingException, MQBrokerException, InterruptedException, RequestTimeoutException {
        long beginTimestamp = System.currentTimeMillis();
        this.prepareSendRequest(msg, timeout);
        String correlationId = msg.getProperty("CORRELATION_ID");
        try {
            final RequestResponseFuture requestResponseFuture = new RequestResponseFuture(correlationId, timeout, null);
            RequestFutureTable.getRequestFutureTable().put(correlationId, requestResponseFuture);
            long cost = System.currentTimeMillis() - beginTimestamp;
            this.sendKernelImpl(msg, mq, CommunicationMode.ASYNC, new SendCallback(){

                @Override
                public void onSuccess(SendResult sendResult) {
                    requestResponseFuture.setSendReqeustOk(true);
                }

                @Override
                public void onException(Throwable e) {
                    requestResponseFuture.setSendReqeustOk(false);
                    requestResponseFuture.putResponseMessage(null);
                    requestResponseFuture.setCause(e);
                }
            }, null, timeout - cost);
            Message responseMessage = requestResponseFuture.waitResponseMessage(timeout - cost);
            if (responseMessage == null) {
                if (requestResponseFuture.isSendRequestOk()) {
                    throw new RequestTimeoutException(10006, "send request message to <" + msg.getTopic() + "> OK, but wait reply message timeout, " + timeout + " ms.");
                }
                throw new MQClientException("send request message to <" + msg.getTopic() + "> fail", requestResponseFuture.getCause());
            }
            Message message = responseMessage;
            return message;
        }
        finally {
            RequestFutureTable.getRequestFutureTable().remove(correlationId);
        }
    }

    public void request(Message msg, MessageQueue mq, RequestCallback requestCallback, long timeout) throws RemotingException, InterruptedException, MQClientException, MQBrokerException {
        long beginTimestamp = System.currentTimeMillis();
        this.prepareSendRequest(msg, timeout);
        final String correlationId = msg.getProperty("CORRELATION_ID");
        final RequestResponseFuture requestResponseFuture = new RequestResponseFuture(correlationId, timeout, requestCallback);
        RequestFutureTable.getRequestFutureTable().put(correlationId, requestResponseFuture);
        long cost = System.currentTimeMillis() - beginTimestamp;
        this.sendKernelImpl(msg, mq, CommunicationMode.ASYNC, new SendCallback(){

            @Override
            public void onSuccess(SendResult sendResult) {
                requestResponseFuture.setSendReqeustOk(true);
            }

            @Override
            public void onException(Throwable e) {
                requestResponseFuture.setCause(e);
                DefaultMQProducerImpl.this.requestFail(correlationId);
            }
        }, null, timeout - cost);
    }

    private void requestFail(String correlationId) {
        RequestResponseFuture responseFuture = RequestFutureTable.getRequestFutureTable().remove(correlationId);
        if (responseFuture != null) {
            responseFuture.setSendReqeustOk(false);
            responseFuture.putResponseMessage(null);
            try {
                responseFuture.executeRequestCallback();
            }
            catch (Exception e) {
                this.log.warn("execute requestCallback in requestFail, and callback throw", (Throwable)e);
            }
        }
    }

    private void prepareSendRequest(Message msg, long timeout) {
        String correlationId = CorrelationIdUtil.createCorrelationId();
        String requestClientId = this.getmQClientFactory().getClientId();
        MessageAccessor.putProperty((Message)msg, (String)"CORRELATION_ID", (String)correlationId);
        MessageAccessor.putProperty((Message)msg, (String)"REPLY_TO_CLIENT", (String)requestClientId);
        MessageAccessor.putProperty((Message)msg, (String)"TTL", (String)String.valueOf(timeout));
        boolean hasRouteData = this.getmQClientFactory().getTopicRouteTable().containsKey(msg.getTopic());
        if (!hasRouteData) {
            long beginTimestamp = System.currentTimeMillis();
            this.tryToFindTopicPublishInfo(msg.getTopic());
            this.getmQClientFactory().sendHeartbeatToAllBrokerWithLock();
            long cost = System.currentTimeMillis() - beginTimestamp;
            if (cost > 500L) {
                this.log.warn("prepare send request for <{}> cost {} ms", (Object)msg.getTopic(), (Object)cost);
            }
        }
    }

    public ConcurrentMap<String, TopicPublishInfo> getTopicPublishInfoTable() {
        return this.topicPublishInfoTable;
    }

    public int getZipCompressLevel() {
        return this.zipCompressLevel;
    }

    public void setZipCompressLevel(int zipCompressLevel) {
        this.zipCompressLevel = zipCompressLevel;
    }

    public ServiceState getServiceState() {
        return this.serviceState;
    }

    public void setServiceState(ServiceState serviceState) {
        this.serviceState = serviceState;
    }

    public long[] getNotAvailableDuration() {
        return this.mqFaultStrategy.getNotAvailableDuration();
    }

    public void setNotAvailableDuration(long[] notAvailableDuration) {
        this.mqFaultStrategy.setNotAvailableDuration(notAvailableDuration);
    }

    public long[] getLatencyMax() {
        return this.mqFaultStrategy.getLatencyMax();
    }

    public void setLatencyMax(long[] latencyMax) {
        this.mqFaultStrategy.setLatencyMax(latencyMax);
    }

    public boolean isSendLatencyFaultEnable() {
        return this.mqFaultStrategy.isSendLatencyFaultEnable();
    }

    public void setSendLatencyFaultEnable(boolean sendLatencyFaultEnable) {
        this.mqFaultStrategy.setSendLatencyFaultEnable(sendLatencyFaultEnable);
    }

    public DefaultMQProducer getDefaultMQProducer() {
        return this.defaultMQProducer;
    }
}

