/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.webapi.sdk;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.kingdee.bos.webapi.entity.AppCfg;
import com.kingdee.bos.webapi.entity.IdentifyInfo;
import com.kingdee.bos.webapi.entity.InvokeMode;
import com.kingdee.bos.webapi.entity.K3CloudCookieStore;
import com.kingdee.bos.webapi.entity.KDException;
import com.kingdee.bos.webapi.entity.QueryRequestBodyObject;
import com.kingdee.bos.webapi.entity.QueryResultInfo;
import com.kingdee.bos.webapi.entity.QueryTaskParam;
import com.kingdee.bos.webapi.entity.RepoRet;
import com.kingdee.bos.webapi.entity.RequestBodyObject;
import com.kingdee.bos.webapi.sdk.ApiQueryRequester;
import com.kingdee.bos.webapi.sdk.ApiRequester;
import com.kingdee.bos.webapi.utils.CfgUtil;
import com.kingdee.bos.webapi.utils.K3CloudObjectTypeAdapter;
import com.kingdee.bos.webapi.utils.PrintUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class WebApiClient {
    protected IdentifyInfo identify;
    K3CloudCookieStore cookier;
    int connectTimeout = 120;
    int requestTimeout = 120;
    int stockTimeout = 180;

    public WebApiClient() {
        this(true);
    }

    public WebApiClient(boolean isPrint) {
        this(new IdentifyInfo(), isPrint);
    }

    public WebApiClient(String serverUrl) {
        this(new IdentifyInfo().setServerUrl(serverUrl));
    }

    public WebApiClient(IdentifyInfo identify) {
        this(identify, true);
    }

    public WebApiClient(IdentifyInfo identify, boolean isPrint) {
        PrintUtils.setPrint(isPrint);
        StringBuilder error = new StringBuilder();
        if (identify == null || identify.getAppId() == null || identify.getAppId().length() == 0) {
            AppCfg cfg = CfgUtil.getAppDefaultCfg();
            if (cfg != null) {
                if (identify == null) {
                    identify = new IdentifyInfo();
                }
                identify.copyPropertiesToAppCfg(cfg);
            } else {
                throw new RuntimeException("Please check whether your configuration file exists");
            }
        }
        if (identify.getAppId() == null || identify.getAppId().length() == 0) {
            error.append("Please check whether your AppId has set value");
        }
        if (identify.getAppSecret() == null || identify.getAppSecret().length() == 0) {
            error.append("Please check whether your AppSecret has set value");
        }
        if (identify.getdCID() == null || identify.getdCID().length() == 0) {
            error.append("Please check whether your dcID has set value");
        }
        if (identify.getUserName() == null || identify.getUserName().length() == 0) {
            error.append("Please check whether your UserName has set value ");
        }
        if (error.length() == 0) {
            this.identify = new IdentifyInfo();
            this.identify.setAppId(identify.getAppId());
            this.identify.setAppSecret(identify.getAppSecret());
            this.identify.setdCID(identify.getdCID());
            this.identify.setlCID(identify.getlCID());
            this.identify.setOrgNum(identify.getOrgNum());
            this.identify.setUserName(identify.getUserName());
            this.identify.setServerUrl(identify.getServerUrl());
            if (this.identify.getServerUrl() == null || this.identify.getServerUrl().length() == 0) {
                this.identify.setServerUrl("https://api.kingdee.com/galaxyapi/");
            }
            if (identify.getConnectTimeout() > 0) {
                this.connectTimeout = identify.getConnectTimeout();
            }
            if (identify.getRequestTimeout() > 0) {
                this.requestTimeout = identify.getRequestTimeout();
            }
            if (identify.getStockTimeout() > 0) {
                this.stockTimeout = identify.getStockTimeout();
            }
        } else {
            throw new RuntimeException(error.toString());
        }
    }

    protected void onPreExecute(String serviceMethod) {
    }

    protected void preExecute() {
        if (this.cookier == null) {
            this.cookier = new K3CloudCookieStore();
        }
    }

    protected void afterExecute(String json, K3CloudCookieStore cookier) {
        if (cookier != null) {
            this.cookier = cookier;
        }
    }

    Gson builderGson() {
        GsonBuilder builder = new GsonBuilder().setDateFormat("yyyy-MM-dd HH:mm:ss");
        return builder.create();
    }

    RequestBodyObject genrateBody(Object[] parameters, InvokeMode type) {
        RequestBodyObject json = null;
        json = type == InvokeMode.Query ? new QueryRequestBodyObject(parameters) : new RequestBodyObject(parameters);
        return json;
    }

    public String execute(String serviceName, Object[] parameters) throws Exception {
        String json = this.executeJson(serviceName, parameters, InvokeMode.Syn);
        if (json.startsWith("response_error:")) {
            KDException ex = KDException.parse(json);
            if (ex == null) {
                throw new Exception(json);
            }
            String msg = ex.getInnerExWrapper() != null ? ex.getMessage() + "-->" + ex.getInnerExWrapper().getMessage() : ex.getMessage();
            throw new Exception(msg);
        }
        return json;
    }

    public <T> List<T> execute(String serviceName, Object[] parameters, Type type) throws Exception {
        String json = this.executeJson(serviceName, parameters, InvokeMode.Syn);
        if (json.startsWith("response_error:")) {
            KDException ex = KDException.parse(json);
            if (ex == null) {
                throw new Exception(json);
            }
            String msg = ex.getInnerExWrapper() != null ? ex.getMessage() + "-->" + ex.getInnerExWrapper().getMessage() : ex.getMessage();
            throw new Exception(msg);
        }
        Gson gson = this.builderGson();
        List t = null;
        try {
            t = (List)gson.fromJson(json, type);
        }
        catch (Exception e) {
            throw new Exception("json parse error, response: [" + json + "]", e);
        }
        return t;
    }

    public <T> T execute(String serviceName, Object[] parameters, Class<T> cls) throws Exception {
        return this.execute(serviceName, parameters, cls, InvokeMode.Syn);
    }

    public <T> T execute(String serviceName, Object[] parameters, Class<T> cls, InvokeMode mode) throws Exception {
        String json = this.executeJson(serviceName, parameters, mode);
        if (json.startsWith("response_error:")) {
            KDException ex = KDException.parse(json);
            if (ex == null) {
                throw new Exception(json);
            }
            String msg = ex.getInnerExWrapper() != null ? ex.getMessage() + "-->" + ex.getInnerExWrapper().getMessage() : ex.getMessage();
            throw new Exception(msg);
        }
        Gson gson = WebApiClient.buildGson();
        Object t = null;
        try {
            t = gson.fromJson(json, cls);
        }
        catch (Exception e) {
            throw new Exception("json parse error, response: [" + json + "]", e);
        }
        return (T)t;
    }

    public static Gson buildGson() {
        Gson gs = new Gson();
        K3CloudObjectTypeAdapter adapter = new K3CloudObjectTypeAdapter(gs);
        Gson gson = new GsonBuilder().registerTypeAdapter(new ArrayList().getClass(), (Object)adapter).create();
        return gson;
    }

    String executeByQuery(String serviceName, Object[] parameters) throws Exception {
        String json = this.doExecuteJson(serviceName, parameters, InvokeMode.Query);
        if (json.startsWith("response_error:")) {
            KDException ex = KDException.parse(json);
            if (ex == null) {
                throw new Exception(json);
            }
            String msg = ex.getInnerExWrapper() != null ? ex.getMessage() + "-->" + ex.getInnerExWrapper().getMessage() : ex.getMessage();
            throw new Exception(msg);
        }
        Gson gson = new Gson();
        QueryResultInfo taskInfo = null;
        try {
            taskInfo = (QueryResultInfo)gson.fromJson(json, QueryResultInfo.class);
        }
        catch (Exception e) {
            throw new Exception("json parse error, response: [" + json + "]", e);
        }
        if (taskInfo.getStatus() == 2) {
            return gson.toJson(taskInfo.getResult());
        }
        return gson.toJson(this.queryTaskResult(serviceName, new QueryTaskParam(taskInfo.getTaskId(), false), 5));
    }

    Object queryTaskResult(String serviceName, QueryTaskParam param, int failTime) throws Exception {
        try {
            Thread.sleep(1000L);
            int index = serviceName.lastIndexOf(".");
            String qService = serviceName.substring(0, index) + "." + "QueryAsyncResult";
            String json = this.doExecuteJson(qService, new Object[]{param}, InvokeMode.Syn);
            if (json.startsWith("response_error:")) {
                if (failTime > 0) {
                    return this.queryTaskResult(serviceName, param, failTime - 1);
                }
                KDException ex = KDException.parse(json);
                if (ex == null) {
                    throw new Exception(json);
                }
                String msg = ex.getInnerExWrapper() != null ? ex.getMessage() + "-->" + ex.getInnerExWrapper().getMessage() : ex.getMessage();
                throw new Exception(msg);
            }
            Gson gson = new Gson();
            QueryResultInfo taskInfo = null;
            try {
                taskInfo = (QueryResultInfo)gson.fromJson(json, QueryResultInfo.class);
            }
            catch (Exception e) {
                throw new Exception("json parse error, response: [" + json + "]", e);
            }
            if (taskInfo.getStatus() == 2) {
                return taskInfo.getResult();
            }
            return this.queryTaskResult(serviceName, param, 5);
        }
        catch (Exception e) {
            if (failTime > 0) {
                return this.queryTaskResult(serviceName, param, failTime - 1);
            }
            throw e;
        }
    }

    String executeJson(String serviceName, Object[] parameters, InvokeMode type) throws Exception {
        if (type == InvokeMode.Query) {
            return this.executeByQuery(serviceName, parameters);
        }
        if (type == InvokeMode.Syn) {
            return this.doExecuteJson(serviceName, parameters, type);
        }
        throw new Exception("Not suppoer yet,for InvokeMode:" + type.toString());
    }

    String doExecuteJson(String serviceName, Object[] parameters, InvokeMode type) throws Exception {
        this.preExecute();
        this.onPreExecute(serviceName);
        String url = this.identify.getServerUrl();
        if (url == "" || url == null) {
            url = "https://api.kingdee.com/galaxyapi/";
        } else if (!url.endsWith("/")) {
            url = url + "/";
        }
        url = url + serviceName + ".common.kdsvc";
        PrintUtils.print("request_url " + url);
        ApiRequester req = null;
        req = type == InvokeMode.Query ? new ApiQueryRequester(url) : new ApiRequester(url);
        req.setConnectTimeout(this.connectTimeout);
        req.setConnectionRequrestTimeout(this.requestTimeout);
        req.setSocketTimeout(this.stockTimeout);
        req.setIdentify(this.identify);
        req.setCookieStore(this.cookier);
        try {
            String json = req.postJson(this.genrateBody(parameters, type));
            this.afterExecute(json, req.getCookieStore());
            return json;
        }
        catch (Exception e) {
            this.afterExecute(null, req.getCookieStore());
            throw e;
        }
    }

    protected <T> List<T> loadDataList(String fieldKeys, Class type, String json) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        ArrayList rets = new ArrayList();
        Gson gson = WebApiClient.buildGson();
        List rows = (List)gson.fromJson(json, rets.getClass());
        Method[] pes = type.getMethods();
        String[] fields = fieldKeys.split(",");
        Method[] setPes = this.getMethodsByFields(pes, "set", fields);
        Method[] getPes = this.getMethodsByFields(pes, "get", fields);
        for (List darray : rows) {
            Object ret = type.newInstance();
            for (int i = 0; i < fields.length; ++i) {
                Object v;
                if (setPes[i] == null || getPes[i] == null || (v = this.convertToDest(getPes[i].getReturnType(), darray.get(i))) == null) continue;
                try {
                    setPes[i].invoke(ret, v);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException("\u5b57\u6bb5\u8f6c\u6362\u5f02\u5e38\uff0c\u7c7b\u578b\u4e0d\u5339\u914d\uff0c\u8bf7\u67e5\u770b\u5bf9\u8c61\u5b9a\u4e49\u7684\u5b57\u6bb5\u7c7b\u578b\u662f\u5426\u6b63\u786e\uff01\u76ee\u6807\u7c7b\u578b\uff1a[" + getPes[i].getReturnType().getName() + "]\uff0c\u5b9e\u9645\u7c7b\u578b\uff1a" + darray.get(i).getClass().getName());
                }
            }
            rets.add(ret);
        }
        return rets;
    }

    String loadErrorMsg(String json) {
        if (json.startsWith("[[") && json.endsWith("]]")) {
            Gson gson = new Gson();
            return ((RepoRet)gson.fromJson(json.substring(2, json.length() - 2), RepoRet.class)).getResult().getResponseStatus().getErrors().get(0).getMessage();
        }
        return String.format("fail for ExecuteBillQuery:%s", json);
    }

    Method[] getMethodsByFields(Method[] pes, String pre, String[] fields) {
        Method[] rets = new Method[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            for (int j = 0; j < pes.length; ++j) {
                if (!pes[j].getName().toLowerCase().equals(pre + fields[i].toLowerCase().replace(".", "_"))) continue;
                rets[i] = pes[j];
            }
        }
        return rets;
    }

    Method getMethodFromT(Method[] pes, String pname) {
        for (int i = 0; i < pes.length; ++i) {
            if (!pes[i].getName().toLowerCase().equals(pname.toLowerCase())) continue;
            return pes[i];
        }
        return null;
    }

    Object convertToDest(Class<?> clazz, Object val) {
        if (val == null) {
            return null;
        }
        try {
            if (clazz.getName().equals(String.class.getName())) {
                return val.toString();
            }
            if (clazz.getName().equals(Byte.TYPE.getName()) || clazz.getName().equals(Byte.class.getName())) {
                String v = val.toString();
                if (v.contains(".")) {
                    v = v.substring(0, v.indexOf("."));
                }
                return new Byte(v);
            }
            if (clazz.getName().equals(Short.TYPE.getName()) || clazz.getName().equals(Short.class.getName())) {
                String v = val.toString();
                if (v.contains(".")) {
                    v = v.substring(0, v.indexOf("."));
                }
                return new Short(v);
            }
            if (clazz.getName().equals(Integer.TYPE.getName()) || clazz.getName().equals(Integer.class.getName())) {
                String v = val.toString();
                if (v.contains(".")) {
                    v = v.substring(0, v.indexOf("."));
                }
                return new Integer(v);
            }
            if (clazz.getName().equals(Long.TYPE.getName()) || clazz.getName().equals(Long.class.getName())) {
                String v = val.toString();
                if (v.contains(".")) {
                    v = v.substring(0, v.indexOf("."));
                }
                return new Long(v);
            }
            if (clazz.getName().equals(BigDecimal.class.getName())) {
                return new BigDecimal(val.toString());
            }
            if (clazz.getName().equals(Date.class.getName())) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                return sdf.parse(val.toString());
            }
            return val;
        }
        catch (Exception e) {
            throw new RuntimeException("\u5b57\u6bb5\u8f6c\u6362\u5f02\u5e38\uff0c\u7c7b\u578b\u4e0d\u5339\u914d\uff0c\u8bf7\u67e5\u770b\u5bf9\u8c61\u5b9a\u4e49\u7684\u5b57\u6bb5\u7c7b\u578b\u662f\u5426\u6b63\u786e\uff01\u76ee\u6807\u7c7b\u578b\uff1a[" + clazz.getName() + "]\uff0c\u5185\u5bb9\uff1a" + val);
        }
    }
}

