/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.fintech.core.crypto;

import com.kingdee.fintech.core.common.Assert;
import com.kingdee.fintech.core.common.KdCryptoException;
import com.kingdee.fintech.core.crypto.Base64;
import com.kingdee.fintech.core.util.KeyUtil;
import com.kingdee.fintech.core.util.StrUtil;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.digests.SM3Digest;
import org.bouncycastle.crypto.engines.SM2Engine;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.ParametersWithID;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.signers.DSAEncoding;
import org.bouncycastle.crypto.signers.PlainDSAEncoding;
import org.bouncycastle.crypto.signers.SM2Signer;
import org.bouncycastle.crypto.signers.StandardDSAEncoding;

public class SM2 {
    protected String algorithm;
    protected SM2Engine engine;
    protected SM2Signer signer;
    private DSAEncoding encoding;
    private Digest digest;
    private SM2Engine.Mode mode;
    private ECPrivateKeyParameters privateKeyParams;
    private ECPublicKeyParameters publicKeyParams;
    protected final Lock lock = new ReentrantLock();

    public SM2() {
        this(null, null);
    }

    public SM2(ECPrivateKeyParameters privateKeyParams, ECPublicKeyParameters publicKeyParams) {
        this.init();
    }

    public SM2 init() {
        this.algorithm = "SM2";
        this.encoding = StandardDSAEncoding.INSTANCE;
        this.digest = new SM3Digest();
        this.mode = SM2Engine.Mode.C1C3C2;
        return this;
    }

    public byte[] encrypt(byte[] data, byte[] pubKeyKey) throws KdCryptoException {
        byte[] cipherText;
        this.lock.lock();
        SM2Engine engine = this.getEngine();
        try {
            ECPublicKeyParameters publicKeyParams = this.decodePublicKeyParams(pubKeyKey);
            ParametersWithRandom pubKeyParams = new ParametersWithRandom((CipherParameters)publicKeyParams);
            engine.init(true, (CipherParameters)pubKeyParams);
            cipherText = engine.processBlock(data, 0, data.length);
        }
        catch (InvalidCipherTextException var8) {
            throw new KdCryptoException(var8);
        }
        finally {
            this.lock.unlock();
        }
        return cipherText;
    }

    public String encrypt(String plaintext, String base64PubKey) throws KdCryptoException {
        byte[] plainBytes = StrUtil.utf8Bytes(plaintext);
        byte[] pubKeyBytes = Base64.getDecoder().decode(base64PubKey);
        byte[] cipherBytes = this.encrypt(plainBytes, pubKeyBytes);
        return Base64.getEncoder().encodeToString(cipherBytes);
    }

    public byte[] decrypt(byte[] data, byte[] privateKey) throws KdCryptoException {
        byte[] plainText;
        this.lock.lock();
        SM2Engine engine = this.getEngine();
        try {
            ECPrivateKeyParameters privateKeyParams = this.decodePrivateKeyParams(privateKey);
            engine.init(false, (CipherParameters)privateKeyParams);
            plainText = engine.processBlock(data, 0, data.length);
        }
        catch (InvalidCipherTextException var8) {
            throw new KdCryptoException(var8);
        }
        finally {
            this.lock.unlock();
        }
        return plainText;
    }

    public String decrypt(String cipherText, String base64PriKey) throws KdCryptoException {
        byte[] cipherBytes = Base64.getDecoder().decode(cipherText);
        byte[] priKeyBytes = Base64.getDecoder().decode(base64PriKey);
        byte[] plainBytes = this.decrypt(cipherBytes, priKeyBytes);
        return StrUtil.utf8Str(plainBytes);
    }

    public String signBase64(String dataBase64, String privateKeyBase64) {
        return this.signBase64(dataBase64, privateKeyBase64, null);
    }

    public String signBase64(String dataBase64, String privateKeyBase64, String idBase64) {
        byte[] sign = this.sign(Base64.getDecoder().decode(dataBase64), Base64.getDecoder().decode(privateKeyBase64), idBase64 == null ? null : Base64.getDecoder().decode(idBase64));
        return Base64.getEncoder().encodeToString(sign);
    }

    public byte[] sign(byte[] data, byte[] privateKey) {
        return this.sign(data, privateKey, null);
    }

    public String sign(String digest, String base64PriKey) {
        byte[] digestBytes = StrUtil.utf8Bytes(digest);
        byte[] priKeyBytes = Base64.getDecoder().decode(base64PriKey);
        byte[] signBytes = this.sign(digestBytes, priKeyBytes);
        return Base64.getEncoder().encodeToString(signBytes);
    }

    public byte[] sign(byte[] data, byte[] privateKey, byte[] id) {
        byte[] signResult;
        Assert.notNull(data, "data must be not null !", new Object[0]);
        Assert.notNull(privateKey, "privateKey must be not null !", new Object[0]);
        this.lock.lock();
        SM2Signer signer = this.getSigner();
        try {
            ECPrivateKeyParameters privateKeyParams = this.decodePrivateKeyParams(privateKey);
            ParametersWithRandom param = new ParametersWithRandom((CipherParameters)privateKeyParams);
            if (id != null) {
                param = new ParametersWithID((CipherParameters)param, id);
            }
            signer.init(true, (CipherParameters)param);
            signer.update(data, 0, data.length);
            signResult = signer.generateSignature();
        }
        catch (CryptoException e) {
            throw new KdCryptoException(e);
        }
        finally {
            this.lock.unlock();
        }
        return signResult;
    }

    public boolean verifyBase64(String dataBase64, String signBase64, String publicKeyBase64) {
        return this.verifyBase64(dataBase64, signBase64, publicKeyBase64, null);
    }

    public boolean verifyBase64(String dataBase64, String signBase64, String publicKeyBase64, String idBase64) {
        Assert.notNull(dataBase64, "data must be not null !", dataBase64);
        Assert.notNull(signBase64, "sign must be not null !", signBase64);
        Assert.notNull(publicKeyBase64, "publicKey must be not null !", publicKeyBase64);
        return this.verify(Base64.getDecoder().decode(dataBase64), Base64.getDecoder().decode(signBase64), Base64.getDecoder().decode(publicKeyBase64), idBase64 == null ? null : Base64.getDecoder().decode(idBase64));
    }

    public boolean verify(byte[] data, byte[] sign, byte[] publicKey) {
        return this.verify(data, sign, publicKey, null);
    }

    public boolean verify(String digest, String sign, String base64PubKey) {
        byte[] digestBytes = StrUtil.utf8Bytes(digest);
        byte[] signBytes = Base64.getDecoder().decode(sign);
        byte[] pubKeyBytes = Base64.getDecoder().decode(base64PubKey);
        return this.verify(digestBytes, signBytes, pubKeyBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verify(byte[] data, byte[] sign, byte[] publicKey, byte[] id) {
        boolean verifyResult;
        Assert.notNull(data, "data must be not null !", new Object[0]);
        Assert.notNull(sign, "sign must be not null !", new Object[0]);
        Assert.notNull(publicKey, "publicKey must be not null !", new Object[0]);
        this.lock.lock();
        SM2Signer signer = this.getSigner();
        try {
            ECPublicKeyParameters param = this.decodePublicKeyParams(publicKey);
            if (id != null) {
                param = new ParametersWithID((CipherParameters)param, id);
            }
            signer.init(false, (CipherParameters)param);
            signer.update(data, 0, data.length);
            verifyResult = signer.verifySignature(sign);
        }
        finally {
            this.lock.unlock();
        }
        return verifyResult;
    }

    public ECPrivateKeyParameters decodePrivateKeyParams(byte[] privateKey) {
        return KeyUtil.decodePrivateKeyParams(privateKey);
    }

    public ECPublicKeyParameters decodePublicKeyParams(byte[] publicKey) {
        return KeyUtil.decodePublicKeyParams(publicKey);
    }

    public SM2 usePlainEncoding() {
        return this.setEncoding((DSAEncoding)PlainDSAEncoding.INSTANCE);
    }

    public SM2 setEncoding(DSAEncoding encoding) {
        this.encoding = encoding;
        this.signer = null;
        return this;
    }

    public SM2 setDigest(Digest digest) {
        this.digest = digest;
        this.engine = null;
        this.signer = null;
        return this;
    }

    public SM2 setMode(SM2Engine.Mode mode) {
        this.mode = mode;
        this.engine = null;
        return this;
    }

    private SM2Engine getEngine() {
        if (null == this.engine) {
            Assert.notNull(this.digest, "digest must be not null !", new Object[0]);
            this.engine = new SM2Engine(this.digest, this.mode);
        }
        this.digest.reset();
        return this.engine;
    }

    private SM2Signer getSigner() {
        if (null == this.signer) {
            Assert.notNull(this.digest, "digest must be not null !", new Object[0]);
            this.signer = new SM2Signer(this.encoding, this.digest);
        }
        this.digest.reset();
        return this.signer;
    }
}

