/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.fintech.core.crypto;

import com.kingdee.fintech.core.common.Assert;
import com.kingdee.fintech.core.common.KdCryptoException;
import com.kingdee.fintech.core.common.KdIOException;
import com.kingdee.fintech.core.common.SMConstant;
import com.kingdee.fintech.core.util.ArrayUtil;
import com.kingdee.fintech.core.util.BCUtil;
import com.kingdee.fintech.core.util.HexUtil;
import com.kingdee.fintech.core.util.StrUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;

public class SM3 {
    private static final long serialVersionUID = 1L;
    public static final String ALGORITHM_NAME = "SM3";
    private MessageDigest digest;
    protected byte[] salt;
    protected int saltPosition;
    protected int digestCount;

    public static SM3 create() {
        return new SM3();
    }

    public SM3() {
        this(ALGORITHM_NAME);
    }

    public SM3(String algorithm) {
        this(algorithm, null);
    }

    public SM3(String algorithm, Provider provider) {
        this.init(algorithm, provider);
    }

    public SM3 init(String algorithm, Provider provider) {
        if (null == provider) {
            this.digest = BCUtil.createMessageDigest(algorithm);
        } else {
            try {
                this.digest = MessageDigest.getInstance(algorithm, provider);
            }
            catch (NoSuchAlgorithmException e) {
                throw new KdCryptoException(e);
            }
        }
        return this;
    }

    public SM3(byte[] salt) {
        this(salt, 0, 1);
    }

    public SM3(byte[] salt, int digestCount) {
        this(salt, 0, digestCount);
    }

    public SM3(byte[] salt, int saltPosition, int digestCount) {
        this();
        this.salt = salt;
        this.saltPosition = saltPosition;
        this.digestCount = digestCount;
    }

    public SM3 setSalt(byte[] salt) {
        this.salt = salt;
        return this;
    }

    public SM3 setSaltPosition(int saltPosition) {
        this.saltPosition = saltPosition;
        return this;
    }

    public SM3 setDigestCount(int digestCount) {
        this.digestCount = digestCount;
        return this;
    }

    public SM3 reset() {
        this.digest.reset();
        return this;
    }

    public byte[] digest(String data, String charsetName) {
        return this.digest(data, BCUtil.charset(charsetName));
    }

    public byte[] digest(String data, Charset charset) {
        return this.digest(StrUtil.bytes(data, charset));
    }

    public byte[] digest(String data) {
        return this.digest(data, SMConstant.DEFAULT_CHARSET);
    }

    public String digestHex(String data, String charsetName) {
        return this.digestHex(data, BCUtil.charset(charsetName));
    }

    public String digestHex(String data, Charset charset) {
        return HexUtil.encodeHexStr(this.digest(data, charset));
    }

    public String digestHex(String data) {
        return this.digestHex(data, "UTF-8");
    }

    public byte[] digest(File file) throws KdCryptoException, IOException {
        byte[] var3;
        try (BufferedInputStream in = SM3.getInputStream(file);){
            var3 = this.digest(in);
        }
        return var3;
    }

    public String digestHex(File file) throws IOException {
        return HexUtil.encodeHexStr(this.digest(file));
    }

    public byte[] digest(byte[] data) {
        byte[] result;
        if (this.saltPosition <= 0) {
            result = this.doDigest(this.salt, data);
        } else if (this.saltPosition >= data.length) {
            result = this.doDigest(data, this.salt);
        } else if (ArrayUtil.isNotEmpty(this.salt)) {
            this.digest.update(data, 0, this.saltPosition);
            this.digest.update(this.salt);
            this.digest.update(data, this.saltPosition, data.length - this.saltPosition);
            result = this.digest.digest();
        } else {
            result = this.doDigest(new byte[][]{data});
        }
        return this.resetAndRepeatDigest(result);
    }

    public String digestHex(byte[] data) {
        return HexUtil.encodeHexStr(this.digest(data));
    }

    public byte[] digest(InputStream data) {
        return this.digest(data, 8192);
    }

    public String digestHex(InputStream data) {
        return HexUtil.encodeHexStr(this.digest(data));
    }

    public byte[] digest(InputStream data, int bufferLength) throws KdIOException {
        byte[] result;
        if (bufferLength < 1) {
            bufferLength = 8192;
        }
        try {
            result = ArrayUtil.isEmpty(this.salt) ? this.digestWithoutSalt(data, bufferLength) : this.digestWithSalt(data, bufferLength);
        }
        catch (IOException var5) {
            throw new KdIOException(var5);
        }
        return this.resetAndRepeatDigest(result);
    }

    public String digestHex(InputStream data, int bufferLength) {
        return HexUtil.encodeHexStr(this.digest(data, bufferLength));
    }

    public MessageDigest getDigest() {
        return this.digest;
    }

    public int getDigestLength() {
        return this.digest.getDigestLength();
    }

    private byte[] digestWithoutSalt(InputStream data, int bufferLength) throws IOException {
        int read;
        byte[] buffer = new byte[bufferLength];
        while ((read = data.read(buffer, 0, bufferLength)) > -1) {
            this.digest.update(buffer, 0, read);
        }
        return this.digest.digest();
    }

    private byte[] digestWithSalt(InputStream data, int bufferLength) throws IOException {
        int read;
        if (this.saltPosition <= 0) {
            this.digest.update(this.salt);
        }
        byte[] buffer = new byte[bufferLength];
        int total = 0;
        while ((read = data.read(buffer, 0, bufferLength)) > -1) {
            if (this.saltPosition > 0 && (total += read) >= this.saltPosition) {
                if (total != this.saltPosition) {
                    this.digest.update(buffer, 0, total - this.saltPosition);
                }
                this.digest.update(this.salt);
                this.digest.update(buffer, total - this.saltPosition, read);
                continue;
            }
            this.digest.update(buffer, 0, read);
        }
        if (total < this.saltPosition) {
            this.digest.update(this.salt);
        }
        return this.digest.digest();
    }

    private byte[] doDigest(byte[] ... datas) {
        byte[][] var2 = datas;
        int var3 = datas.length;
        for (int var4 = 0; var4 < var3; ++var4) {
            byte[] data = var2[var4];
            if (null == data) continue;
            this.digest.update(data);
        }
        return this.digest.digest();
    }

    private byte[] resetAndRepeatDigest(byte[] digestData) {
        int digestCount = Math.max(1, this.digestCount);
        this.reset();
        for (int i = 0; i < digestCount - 1; ++i) {
            digestData = this.doDigest(new byte[][]{digestData});
            this.reset();
        }
        return digestData;
    }

    private static BufferedInputStream getInputStream(File file) throws KdIOException {
        return SM3.toBuffered(SM3.toStream(file));
    }

    private static FileInputStream toStream(File file) {
        try {
            return new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new KdIOException(e);
        }
    }

    private static BufferedInputStream toBuffered(InputStream in) {
        Assert.notNull(in, "InputStream must be not null!", new Object[0]);
        return in instanceof BufferedInputStream ? (BufferedInputStream)in : new BufferedInputStream(in);
    }
}

