/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.fintech.core.crypto;

import com.kingdee.fintech.core.crypto.symmetric.SM4Crypto;
import com.kingdee.fintech.core.util.ArrayUtil;
import com.kingdee.fintech.core.util.KeyUtil;
import com.kingdee.fintech.core.util.StrUtil;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;

public class SM4
extends SM4Crypto {
    public static final String ALGORITHM_NAME = "SM4";

    public SM4() {
        super(ALGORITHM_NAME);
    }

    public SM4(byte[] key) {
        super(ALGORITHM_NAME, key);
    }

    public SM4(String mode, String padding) {
        this(mode, padding, (byte[])null);
    }

    public SM4(String mode, String padding, byte[] key) {
        this(mode, padding, key, (byte[])null);
    }

    public SM4(String mode, String padding, byte[] key, byte[] iv) {
        this(mode, padding, KeyUtil.generateKey(ALGORITHM_NAME, key), ArrayUtil.isEmpty(iv) ? null : new IvParameterSpec(iv));
    }

    public SM4(String mode, String padding, SecretKey key) {
        this(mode, padding, key, (IvParameterSpec)null);
    }

    public SM4(String mode, String padding, SecretKey key, IvParameterSpec iv) {
        super(StrUtil.format("SM4/{}/{}", new Object[]{mode, padding}), key, iv);
    }
}

