/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.fintech.core.crypto.symmetric;

import com.kingdee.fintech.core.common.Assert;
import com.kingdee.fintech.core.common.KdCryptoException;
import com.kingdee.fintech.core.common.KdIOException;
import com.kingdee.fintech.core.crypto.symmetric.CipherMode;
import com.kingdee.fintech.core.crypto.symmetric.SM4Decryptor;
import com.kingdee.fintech.core.crypto.symmetric.SM4Encryptor;
import com.kingdee.fintech.core.util.ArrayUtil;
import com.kingdee.fintech.core.util.BCUtil;
import com.kingdee.fintech.core.util.HexUtil;
import com.kingdee.fintech.core.util.IOUtil;
import com.kingdee.fintech.core.util.KeyUtil;
import com.kingdee.fintech.core.util.StrUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;

public class SM4Crypto
implements SM4Encryptor,
SM4Decryptor,
Serializable {
    private SecretKey secretKey;
    private Cipher cipher;
    private AlgorithmParameterSpec params;
    private boolean isZeroPadding;
    private final Lock lock = new ReentrantLock();

    public SM4Crypto(String algorithm) {
        this(algorithm, (byte[])null);
    }

    public SM4Crypto(String algorithm, byte[] key) {
        this(algorithm, KeyUtil.generateKey(algorithm, key));
    }

    public SM4Crypto(String algorithm, SecretKey key) {
        this(algorithm, key, null);
    }

    public SM4Crypto(String algorithm, SecretKey key, AlgorithmParameterSpec paramsSpec) {
        this.init(algorithm, key, paramsSpec);
    }

    public SM4Crypto init(String algorithm, SecretKey key, AlgorithmParameterSpec paramsSpec) {
        Assert.notBlank(algorithm, "'algorithm' must be not blank !", new Object[0]);
        this.secretKey = key;
        if (null != paramsSpec) {
            this.params = paramsSpec;
        }
        if (algorithm.contains("ZeroPadding")) {
            algorithm = StrUtil.replace(algorithm, "ZeroPadding", "NoPadding");
            this.isZeroPadding = true;
        }
        this.cipher = BCUtil.createCipher(algorithm);
        return this;
    }

    public SecretKey getSecretKey() {
        return this.secretKey;
    }

    public Cipher getCipher() {
        return this.cipher;
    }

    public SM4Crypto setParams(AlgorithmParameterSpec params) {
        this.params = params;
        return this;
    }

    public AlgorithmParameterSpec getParams() {
        return this.params;
    }

    public SM4Crypto setIv(IvParameterSpec iv) {
        this.setParams(iv);
        return this;
    }

    public SM4Crypto setIv(byte[] iv) {
        this.setIv(new IvParameterSpec(iv));
        return this;
    }

    public byte[] update(byte[] data) {
        byte[] bytes;
        this.lock.lock();
        try {
            bytes = this.cipher.update(this.paddingDataWithZero(data, this.cipher.getBlockSize()));
        }
        catch (Exception ex) {
            throw new KdCryptoException(ex);
        }
        finally {
            this.lock.unlock();
        }
        return bytes;
    }

    public String updateHex(byte[] data) {
        return HexUtil.encodeHexStr(this.update(data));
    }

    @Override
    public byte[] encrypt(byte[] data, SecretKey secretKey, AlgorithmParameterSpec params) {
        byte[] bytes;
        this.lock.lock();
        try {
            Cipher cipher = this.initCipher(CipherMode.encrypt, secretKey, params);
            bytes = cipher.doFinal(this.paddingDataWithZero(data, cipher.getBlockSize()));
        }
        catch (Exception ex) {
            throw new KdCryptoException(ex);
        }
        finally {
            this.lock.unlock();
        }
        return bytes;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void encrypt(InputStream data, OutputStream out, SecretKey secretKey, AlgorithmParameterSpec params, boolean isClose) throws KdIOException {
        this.lock.lock();
        CipherOutputStream cipherOutputStream = null;
        try {
            int remainLength;
            int blockSize;
            Cipher cipher = this.initCipher(CipherMode.encrypt, secretKey, params);
            cipherOutputStream = new CipherOutputStream(out, cipher);
            long length = IOUtil.copy(data, cipherOutputStream);
            if (this.isZeroPadding && (blockSize = cipher.getBlockSize()) > 0 && (remainLength = (int)(length % (long)blockSize)) > 0) {
                cipherOutputStream.write(new byte[blockSize - remainLength]);
                cipherOutputStream.flush();
            }
        }
        catch (KdIOException ex) {
            try {
                throw ex;
                catch (Exception ex2) {
                    throw new KdCryptoException(ex2);
                }
            }
            catch (Throwable throwable) {
                this.lock.unlock();
                IOUtil.close(cipherOutputStream);
                if (!isClose) throw throwable;
                IOUtil.close(data);
                throw throwable;
            }
        }
        this.lock.unlock();
        IOUtil.close(cipherOutputStream);
        if (!isClose) return;
        IOUtil.close(data);
    }

    @Override
    public byte[] decrypt(byte[] bytes, SecretKey secretKey, AlgorithmParameterSpec params) {
        byte[] decryptData;
        int blockSize;
        this.lock.lock();
        try {
            Cipher cipher = this.initCipher(CipherMode.decrypt, secretKey, params);
            blockSize = cipher.getBlockSize();
            decryptData = cipher.doFinal(bytes);
        }
        catch (Exception ex) {
            throw new KdCryptoException(ex);
        }
        finally {
            this.lock.unlock();
        }
        return this.removePadding(decryptData, blockSize);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void decrypt(InputStream data, OutputStream out, SecretKey secretKey, AlgorithmParameterSpec params, boolean isClose) throws KdIOException {
        CipherInputStream cipherInputStream;
        block7: {
            int blockSize;
            this.lock.lock();
            cipherInputStream = null;
            Cipher cipher = this.initCipher(CipherMode.decrypt, secretKey, params);
            cipherInputStream = new CipherInputStream(data, cipher);
            if (!this.isZeroPadding || (blockSize = cipher.getBlockSize()) <= 0) break block7;
            SM4Crypto.copyForZeroPadding(cipherInputStream, out, blockSize);
            this.lock.unlock();
            IOUtil.close(cipherInputStream);
            if (!isClose) return;
            IOUtil.close(data);
            return;
        }
        try {
            IOUtil.copy(cipherInputStream, out);
        }
        catch (IOException ex) {
            try {
                throw new KdIOException(ex);
                catch (KdIOException ex2) {
                    throw ex2;
                }
                catch (Exception ex3) {
                    throw new KdCryptoException(ex3);
                }
            }
            catch (Throwable throwable) {
                this.lock.unlock();
                IOUtil.close(cipherInputStream);
                if (!isClose) throw throwable;
                IOUtil.close(data);
                throw throwable;
            }
        }
        this.lock.unlock();
        IOUtil.close(cipherInputStream);
        if (!isClose) return;
        IOUtil.close(data);
        return;
    }

    private Cipher initCipher(CipherMode mode, SecretKey secretKey, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        Cipher cipher = this.cipher;
        SecretKey secKey = secretKey;
        AlgorithmParameterSpec parameterSpec = params;
        if (secretKey == null) {
            secKey = this.getSecretKey();
        }
        if (params == null) {
            parameterSpec = this.getParams();
        }
        if (null == parameterSpec) {
            cipher.init(mode.getValue(), secKey);
        } else {
            cipher.init(mode.getValue(), (Key)secKey, parameterSpec);
        }
        this.cipher = cipher;
        return this.cipher;
    }

    private Cipher initCipher(CipherMode mode, SecretKey secretKey) throws InvalidKeyException, InvalidAlgorithmParameterException {
        return this.initCipher(mode, secretKey, null);
    }

    private byte[] paddingDataWithZero(byte[] data, int blockSize) {
        int length;
        int remainLength;
        if (this.isZeroPadding && (remainLength = (length = data.length) % blockSize) > 0) {
            return ArrayUtil.resize(data, length + blockSize - remainLength);
        }
        return data;
    }

    private byte[] removePadding(byte[] data, int blockSize) {
        int length;
        int remainLength;
        if (this.isZeroPadding && blockSize > 0 && (remainLength = (length = data.length) % blockSize) == 0) {
            int i;
            for (i = length - 1; i >= 0 && 0 == data[i]; --i) {
            }
            return ArrayUtil.resize(data, i + 1);
        }
        return data;
    }

    private static void copyForZeroPadding(CipherInputStream in, OutputStream out, int blockSize) throws IOException {
        int readSize;
        int n = 1;
        if (8192 > blockSize) {
            n = Math.max(n, 8192 / blockSize);
        }
        int bufSize = blockSize * n;
        byte[] preBuffer = new byte[bufSize];
        byte[] buffer = new byte[bufSize];
        boolean isFirst = true;
        int preReadSize = 0;
        while ((readSize = in.read(buffer)) != -1) {
            if (isFirst) {
                isFirst = false;
            } else {
                out.write(preBuffer, 0, preReadSize);
            }
            ArrayUtil.copy(buffer, preBuffer, readSize);
            preReadSize = readSize;
        }
        for (readSize = preReadSize - 1; readSize >= 0 && 0 == preBuffer[readSize]; --readSize) {
        }
        out.write(preBuffer, 0, readSize + 1);
        out.flush();
    }
}

