/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.fintech.core.crypto.symmetric;

import com.kingdee.fintech.core.common.SMConstant;
import com.kingdee.fintech.core.util.KeyUtil;
import com.kingdee.fintech.core.util.SecureUtil;
import com.kingdee.fintech.core.util.StrUtil;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.SecretKey;

public interface SM4Decryptor {
    public byte[] decrypt(byte[] var1, SecretKey var2, AlgorithmParameterSpec var3);

    default public byte[] decrypt(String data, String key, String iv, Charset charset) {
        SecretKey secretKey = KeyUtil.generateKey("SM4", StrUtil.bytes(key, charset));
        AlgorithmParameterSpec params = SecureUtil.getIvParameterSpec(StrUtil.bytes(iv, charset));
        return this.decrypt(SecureUtil.decode(data), secretKey, params);
    }

    default public byte[] decrypt(String data, String key, String iv, String charset) {
        return this.decrypt(data, key, iv, Charset.forName(charset));
    }

    default public String decryptStr(byte[] bytes, byte[] key, byte[] iv, Charset charset) {
        SecretKey secretKey = KeyUtil.generateKey("SM4", key);
        AlgorithmParameterSpec params = SecureUtil.getIvParameterSpec(iv);
        return StrUtil.str(this.decrypt(bytes, secretKey, params), charset);
    }

    default public String decryptStr(String data, String key, String iv, Charset charset) {
        return StrUtil.str(this.decrypt(data, key, iv, charset), charset);
    }

    default public String decryptStr(String data, String key, String iv) {
        return StrUtil.str(this.decrypt(data, key, iv, StandardCharsets.UTF_8), StandardCharsets.UTF_8);
    }

    default public String decryptStr(byte[] bytes) {
        return this.decryptStr(bytes, null, null, SMConstant.DEFAULT_CHARSET);
    }

    default public String decryptStr(String data) {
        return this.decryptStr(data, null, null, SMConstant.DEFAULT_CHARSET);
    }
}

