/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.fintech.core.crypto.symmetric;

import com.kingdee.fintech.core.common.SMConstant;
import com.kingdee.fintech.core.crypto.Base64;
import com.kingdee.fintech.core.util.HexUtil;
import com.kingdee.fintech.core.util.KeyUtil;
import com.kingdee.fintech.core.util.SecureUtil;
import com.kingdee.fintech.core.util.StrUtil;
import java.nio.charset.Charset;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.SecretKey;

public interface SM4Encryptor {
    public byte[] encrypt(byte[] var1, SecretKey var2, AlgorithmParameterSpec var3);

    default public byte[] encrypt(String data, String key, String iv, Charset charset) {
        SecretKey secretKey = KeyUtil.generateKey("SM4", StrUtil.bytes(key, charset));
        AlgorithmParameterSpec params = SecureUtil.getIvParameterSpec(StrUtil.bytes(iv, charset));
        return this.encrypt(StrUtil.bytes(data, charset), secretKey, params);
    }

    default public byte[] encrypt(String data, String key, String iv, String charset) {
        return this.encrypt(data, key, iv, Charset.forName(charset));
    }

    default public byte[] encrypt(String data, String key, String iv) {
        return this.encrypt(data, key, iv, SMConstant.DEFAULT_CHARSET);
    }

    default public String encryptHex(byte[] data, byte[] key, byte[] iv) {
        SecretKey secretKey = KeyUtil.generateKey("SM4", key);
        AlgorithmParameterSpec params = SecureUtil.getIvParameterSpec(iv);
        return HexUtil.encodeHexStr(this.encrypt(data, secretKey, params));
    }

    default public String encryptHex(byte[] data, byte[] key) {
        return this.encryptHex(data, key, null);
    }

    default public String encryptHex(String data, String key, String iv, String charset) {
        return HexUtil.encodeHexStr(this.encrypt(data, key, iv, charset));
    }

    default public String encryptHex(String data, String key, String charset) {
        return this.encryptHex(data, key, null, charset);
    }

    default public String encryptHex(String data, Charset charset) {
        return HexUtil.encodeHexStr(this.encrypt(data, null, null, charset));
    }

    default public String encryptHex(String data) {
        return this.encryptHex(data, SMConstant.DEFAULT_CHARSET);
    }

    default public String encryptBase64(byte[] data, byte[] key, byte[] iv) {
        AlgorithmParameterSpec params = SecureUtil.getIvParameterSpec(iv);
        SecretKey secretKey = KeyUtil.generateKey("SM4", key);
        return Base64.getEncoder().encodeToString(this.encrypt(data, secretKey, params));
    }

    default public String encryptBase64(String data, String key, String iv, Charset charset) {
        return Base64.getEncoder().encodeToString(this.encrypt(data, key, iv, charset));
    }

    default public String encryptBase64(String data, String key, String iv, String charset) {
        return this.encryptBase64(data, key, iv, Charset.forName(charset));
    }

    default public String encryptBase64(String data, String key, Charset charset) {
        return this.encryptBase64(data, key, null, charset);
    }

    default public String encryptBase64(String data) {
        return this.encryptBase64(data, null, null, SMConstant.DEFAULT_CHARSET);
    }

    default public String encryptBase64(String data, String key, String iv) {
        return this.encryptBase64(data, key, iv, SMConstant.DEFAULT_CHARSET);
    }
}

