/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.fintech.core.test;

import com.kingdee.fintech.core.common.SMConstant;
import com.kingdee.fintech.core.crypto.Base64;
import com.kingdee.fintech.core.crypto.SM2;
import com.kingdee.fintech.core.crypto.SM2KeyPair;
import com.kingdee.fintech.core.crypto.SM3;
import com.kingdee.fintech.core.crypto.SM4;
import com.kingdee.fintech.core.util.HexUtil;
import com.kingdee.fintech.core.util.KeyUtil;
import com.kingdee.fintech.core.util.SecureUtil;
import com.kingdee.fintech.core.util.StrUtil;
import java.nio.charset.StandardCharsets;
import javax.crypto.SecretKey;

public class Sm2Test {
    public static void main(String[] args) {
        Sm2Test.test();
    }

    public static void sm2Encrypt() {
        SM2KeyPair pair = KeyUtil.generateSm2Keys();
        SM2 sm2 = new SM2();
        String data = "\u5982\u679c\u4f60\u4f7f\u7528\u7684\u662fSM4\u7b97\u6cd5\uff0c\u4f60\u76f4\u63a5\u4f7f\u7528PKCS7\u586b\u5145\u5373\u53ef\uff0c\u4e4b\u524d\u6211\u9047\u5230\u8fc7JAVA\u7684API\u91cc\u5199\u7740\u4f7f\u7528PKCS5\uff0c\u4f46\u5b9e\u9645\u8f93\u51fa\u7ed3\u679c\u4e3aPKCS7";
        String publicKey = pair.getPublicKey();
        System.out.println("publicKey:" + publicKey);
        String privateKey = pair.getPrivateKey();
        System.out.println("privateKey:" + privateKey);
        byte[] cipherText = sm2.encrypt(StrUtil.bytes(data, SMConstant.DEFAULT_CHARSET), SecureUtil.decode(publicKey));
        System.out.println("cipherText:" + Base64.getEncoder().encode(cipherText).toString());
        System.out.println("cipherText:" + new String(Base64.getEncoder().encode(cipherText), SMConstant.DEFAULT_CHARSET));
        byte[] plainText = sm2.decrypt(cipherText, SecureUtil.decode(privateKey));
        String pt = StrUtil.str(plainText, SMConstant.DEFAULT_CHARSET);
        System.out.println("plainText:" + pt);
        System.out.println("eq:" + data.equals(pt));
    }

    public static void sm2Sign() {
        SM2KeyPair pair = KeyUtil.generateSm2Keys();
        SM2 sm2 = new SM2();
        String data = "\u5982\u679c\u4f60\u4f7f\u7528\u7684\u662fSM4\u7b97\u6cd5\uff0c\u4f60\u76f4\u63a5\u4f7f\u7528PKCS7\u586b\u5145\u5373\u53ef\uff0c\u4e4b\u524d\u6211\u9047\u5230\u8fc7JAVA\u7684API\u91cc\u5199\u7740\u4f7f\u7528PKCS5\uff0c\u4f46\u5b9e\u9645\u8f93\u51fa\u7ed3\u679c\u4e3aPKCS7";
        String publicKey = pair.getPublicKey();
        System.out.println("publicKey:" + publicKey);
        String privateKey = pair.getPrivateKey();
        System.out.println("privateKey:" + privateKey);
        byte[] sign = sm2.sign(StrUtil.bytes(data, SMConstant.DEFAULT_CHARSET), SecureUtil.decode(privateKey));
        String signStr = HexUtil.encodeHexStr(sign);
        System.out.println("signStr:" + signStr);
        boolean verifyBoan = sm2.verify(StrUtil.bytes(data, SMConstant.DEFAULT_CHARSET), SecureUtil.decode(signStr), SecureUtil.decode(publicKey));
        System.out.println("verify:" + verifyBoan);
    }

    public static void sm3() {
        String data = "\u5982\u679c\u4f60\u4f7f\u7528\u7684\u662fSM4\u7b97\u6cd5\uff0c\u4f60\u76f4\u63a5\u4f7f\u7528PKCS7\u586b\u5145\u5373\u53ef\uff0c\u4e4b\u524d\u6211\u9047\u5230\u8fc7JAVA\u7684API\u91cc\u5199\u7740\u4f7f\u7528PKCS5\uff0c\u4f46\u5b9e\u9645\u8f93\u51fa\u7ed3\u679c\u4e3aPKCS7";
        String data1 = "\u5982\u679c\u4f60\u4f7f\u7528\u7684\u662fSM4\u7b97\u6cd5\uff0c\u4f60\u76f4\u63a5\u4f7f\u7528PKCS7\u586b\u5145\u5373\u53ef\uff0c\u4e4b\u524d\u6211\u9047\u5230\u8fc7JAVA\u7684API\u91cc\u5199\u7740\u4f7f\u7528PKCS5\uff0c\u4f46\u5b9e\u9645\u8f93\u51fa\u7ed3\u679c\u4e3aPKCS7";
        SM3 sm3 = new SM3();
        String d1 = sm3.digestHex(data);
        String d2 = sm3.digestHex(data1);
        System.out.println("d1:" + d1);
        System.out.println("d2:" + d2);
    }

    public static void sm4() {
        String data = "\u5982\u679c\u4f60\u4f7f\u7528\u7684\u662fSM4\u7b97\u6cd5\uff0c\u4f60\u76f4\u63a5\u4f7f\u7528PKCS7\u586b\u5145\u5373\u53ef\uff0c\u4e4b\u524d\u6211\u9047\u5230\u8fc7JAVA\u7684API\u91cc\u5199\u7740\u4f7f\u7528PKCS5\uff0c\u4f46\u5b9e\u9645\u8f93\u51fa\u7ed3\u679c\u4e3aPKCS7 ";
        SM4 sm4 = new SM4("GCM", "NoPadding");
        String iv = "135453135131";
        SecretKey key = KeyUtil.generateKey("SM4");
        System.out.println("key:" + HexUtil.encodeHexStr(key.getEncoded()));
        String encryptHex = sm4.encryptHex(data.getBytes(StandardCharsets.UTF_8), key.getEncoded(), iv.getBytes(StandardCharsets.UTF_8));
        System.out.println("encryptHex:" + encryptHex);
        String s1 = sm4.decryptStr(SecureUtil.decode(encryptHex), key.getEncoded(), iv.getBytes(StandardCharsets.UTF_8), StandardCharsets.UTF_8);
        System.out.println("decryptStr:" + s1);
    }

    public static void test() {
        String data = "\u5982\u679c\u4f60\u4f7f\u7528\u7684\u662fSM4\u7b97\u6cd5\uff0c\u4f60\u76f4\u63a5\u4f7f\u7528PKCS7\u586b\u5145\u5373\u53ef\uff0c\u4e4b\u524d\u6211\u9047\u5230\u8fc7JAVA\u7684API\u91cc\u5199\u7740\u4f7f\u7528PKCS5\uff0c\u4f46\u5b9e\u9645\u8f93\u51fa\u7ed3\u679c\u4e3aPKCS7 ";
        byte[] bytes = data.getBytes(StandardCharsets.UTF_8);
        String s1 = HexUtil.encodeHexStr(bytes);
        String s2 = HexUtil.byteToHex(bytes);
        System.out.println("s1:" + s1);
        System.out.println("s2:" + s2);
    }
}

