/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.fintech.core.util;

import java.lang.reflect.Array;
import java.util.Arrays;

public class ArrayUtil {
    public static boolean isEmpty(Object[] array) {
        return ArrayUtil.getLength(array) == 0;
    }

    public static <T> boolean isNotEmpty(T[] array) {
        return null != array && array.length != 0;
    }

    public static boolean isEmpty(byte[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isNotEmpty(byte[] array) {
        return !ArrayUtil.isEmpty(array);
    }

    public static int getLength(Object array) {
        return array == null ? 0 : Array.getLength(array);
    }

    public static boolean isArray(Object obj) {
        return null != obj && obj.getClass().isArray();
    }

    public static String toString(Object obj) {
        if (null == obj) {
            return null;
        }
        if (obj instanceof long[]) {
            return Arrays.toString((long[])obj);
        }
        if (obj instanceof int[]) {
            return Arrays.toString((int[])obj);
        }
        if (obj instanceof short[]) {
            return Arrays.toString((short[])obj);
        }
        if (obj instanceof char[]) {
            return Arrays.toString((char[])obj);
        }
        if (obj instanceof byte[]) {
            return Arrays.toString((byte[])obj);
        }
        if (obj instanceof boolean[]) {
            return Arrays.toString((boolean[])obj);
        }
        if (obj instanceof float[]) {
            return Arrays.toString((float[])obj);
        }
        if (obj instanceof double[]) {
            return Arrays.toString((double[])obj);
        }
        if (ArrayUtil.isArray(obj)) {
            try {
                return Arrays.deepToString((Object[])obj);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return obj.toString();
    }

    public static <T> boolean hasNull(T ... objects) {
        if (ArrayUtil.isNotEmpty(objects)) {
            T[] array = objects;
            int len = objects.length;
            for (int i = 0; i < len; ++i) {
                T element = array[i];
                if (null != element) continue;
                return true;
            }
        }
        return false;
    }

    public static Object copy(Object src, int srcPos, Object dest, int destPos, int length) {
        System.arraycopy(src, srcPos, dest, destPos, length);
        return dest;
    }

    public static Object copy(Object src, Object dest, int length) {
        System.arraycopy(src, 0, dest, 0, length);
        return dest;
    }

    public static byte[] resize(byte[] bytes, int newSize) {
        if (newSize < 0) {
            return bytes;
        }
        byte[] newArray = new byte[newSize];
        if (newSize > 0 && ArrayUtil.isNotEmpty(bytes)) {
            System.arraycopy(bytes, 0, newArray, 0, Math.min(bytes.length, newSize));
        }
        return newArray;
    }
}

