/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.fintech.core.util;

import com.kingdee.fintech.core.util.ArrayUtil;
import com.kingdee.fintech.core.util.StrUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.List;

public class ExceptionUtil {
    public static String getMessage(Throwable e) {
        if (null == e) {
            return "null";
        }
        return StrUtil.format("{}: {}", e.getClass().getSimpleName(), e.getMessage());
    }

    public static String getSimpleMessage(Throwable e) {
        return null == e ? "null" : e.getMessage();
    }

    public static RuntimeException wrapRuntime(Throwable throwable) {
        if (throwable instanceof RuntimeException) {
            return (RuntimeException)throwable;
        }
        return new RuntimeException(throwable);
    }

    public static RuntimeException wrapRuntime(String message) {
        return new RuntimeException(message);
    }

    public static Throwable unwrap(Throwable wrapped) {
        Throwable unwrapped = wrapped;
        while (true) {
            if (unwrapped instanceof InvocationTargetException) {
                unwrapped = ((InvocationTargetException)unwrapped).getTargetException();
                continue;
            }
            if (!(unwrapped instanceof UndeclaredThrowableException)) break;
            unwrapped = ((UndeclaredThrowableException)unwrapped).getUndeclaredThrowable();
        }
        return unwrapped;
    }

    public static StackTraceElement[] getStackElements() {
        return Thread.currentThread().getStackTrace();
    }

    public static StackTraceElement getStackElement(int i) {
        return Thread.currentThread().getStackTrace()[i];
    }

    public static boolean isCausedBy(Throwable throwable, Class<? extends Exception> ... causeClasses) {
        return null != ExceptionUtil.getCausedBy(throwable, causeClasses);
    }

    public static Throwable getCausedBy(Throwable throwable, Class<? extends Exception> ... causeClasses) {
        for (Throwable cause = throwable; cause != null; cause = cause.getCause()) {
            for (Class<? extends Exception> causeClass : causeClasses) {
                if (!causeClass.isInstance(cause)) continue;
                return cause;
            }
        }
        return null;
    }

    public static boolean isFromOrSuppressedThrowable(Throwable throwable, Class<? extends Throwable> exceptionClass) {
        return ExceptionUtil.convertFromOrSuppressedThrowable(throwable, exceptionClass, true) != null;
    }

    public static boolean isFromOrSuppressedThrowable(Throwable throwable, Class<? extends Throwable> exceptionClass, boolean checkCause) {
        return ExceptionUtil.convertFromOrSuppressedThrowable(throwable, exceptionClass, checkCause) != null;
    }

    public static <T extends Throwable> T convertFromOrSuppressedThrowable(Throwable throwable, Class<T> exceptionClass) {
        return ExceptionUtil.convertFromOrSuppressedThrowable(throwable, exceptionClass, true);
    }

    public static <T extends Throwable> T convertFromOrSuppressedThrowable(Throwable throwable, Class<T> exceptionClass, boolean checkCause) {
        Throwable cause;
        if (throwable == null || exceptionClass == null) {
            return null;
        }
        if (exceptionClass.isAssignableFrom(throwable.getClass())) {
            return (T)throwable;
        }
        if (checkCause && (cause = throwable.getCause()) != null && exceptionClass.isAssignableFrom(cause.getClass())) {
            return (T)cause;
        }
        Throwable[] throwables = throwable.getSuppressed();
        if (ArrayUtil.isNotEmpty(throwables)) {
            for (Throwable throwable1 : throwables) {
                if (!exceptionClass.isAssignableFrom(throwable1.getClass())) continue;
                return (T)throwable1;
            }
        }
        return null;
    }

    public static List<Throwable> getThrowableList(Throwable throwable) {
        ArrayList<Throwable> list = new ArrayList<Throwable>();
        while (throwable != null && !list.contains(throwable)) {
            list.add(throwable);
            throwable = throwable.getCause();
        }
        return list;
    }

    public static Throwable getRootCause(Throwable throwable) {
        List<Throwable> list = ExceptionUtil.getThrowableList(throwable);
        return list.size() < 1 ? null : list.get(list.size() - 1);
    }

    public static String getRootCauseMessage(Throwable th) {
        return ExceptionUtil.getMessage(ExceptionUtil.getRootCause(th));
    }
}

