/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.fintech.core.util;

import com.kingdee.fintech.core.common.HexException;
import com.kingdee.fintech.core.crypto.Base64;
import com.kingdee.fintech.core.util.StrUtil;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.regex.Pattern;

public class HexUtil {
    public static final Pattern HEX = Pattern.compile("^[a-fA-F0-9]+$");
    private static final char[] DIGITS_LOWER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final char[] DIGITS_UPPER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static boolean isHexNumber(String value) {
        int index;
        int n = index = value.startsWith("-") ? 1 : 0;
        if (!(value.startsWith("0x", index) || value.startsWith("0X", index) || value.startsWith("#", index))) {
            return false;
        }
        try {
            Long.decode(value);
            return true;
        }
        catch (NumberFormatException var3) {
            return false;
        }
    }

    public static char[] encodeHex(byte[] data) {
        return HexUtil.encodeHex(data, true);
    }

    public static char[] encodeHex(String str, Charset charset) {
        return HexUtil.encodeHex(StrUtil.bytes(str, charset), true);
    }

    public static char[] encodeHex(byte[] data, boolean toLowerCase) {
        return HexUtil.encodeHex(data, toLowerCase ? DIGITS_LOWER : DIGITS_UPPER);
    }

    public static String encodeHexStr(byte[] data) {
        return HexUtil.encodeHexStr(data, true);
    }

    public static String encodeHexStr(String data, Charset charset) {
        return HexUtil.encodeHexStr(StrUtil.bytes(data, charset), true);
    }

    public static String encodeHexStr(String data) {
        return HexUtil.encodeHexStr(data, StandardCharsets.UTF_8);
    }

    public static String encodeHexStr(byte[] data, boolean toLowerCase) {
        return HexUtil.encodeHexStr(data, toLowerCase ? DIGITS_LOWER : DIGITS_UPPER);
    }

    public static String decodeHexStr(String hexStr) {
        return HexUtil.decodeHexStr(hexStr, StandardCharsets.UTF_8);
    }

    public static String decodeHexStr(String hexStr, Charset charset) {
        return StrUtil.isEmpty(hexStr) ? hexStr : StrUtil.str(HexUtil.decodeHex(hexStr), charset);
    }

    public static String decodeHexStr(char[] hexData, Charset charset) {
        return StrUtil.str(HexUtil.decodeHex(hexData), charset);
    }

    public static byte[] decodeHex(String hexStr) {
        return HexUtil.decodeHex((CharSequence)hexStr);
    }

    public static byte[] decodeHex(char[] hexData) {
        return HexUtil.decodeHex(String.valueOf(hexData));
    }

    public static byte[] decodeHex(CharSequence hexDataSeq) {
        if (StrUtil.isEmpty(hexDataSeq)) {
            return null;
        }
        String hexData = StrUtil.cleanBlank(hexDataSeq);
        int len = hexData.length();
        if ((len & 1) != 0) {
            hexData = "0" + hexData;
            len = hexData.length();
        }
        byte[] out = new byte[len >> 1];
        int i = 0;
        int j = 0;
        while (j < len) {
            int f = HexUtil.toDigit(hexData.charAt(j), j) << 4;
            f |= HexUtil.toDigit(hexData.charAt(++j), j);
            ++j;
            out[i] = (byte)(f & 0xFF);
            ++i;
        }
        return out;
    }

    public static String toUnicodeHex(int value) {
        StringBuilder builder = new StringBuilder(6);
        builder.append("\\u");
        String hex = HexUtil.toHex(value);
        int len = hex.length();
        if (len < 4) {
            builder.append("0000", 0, 4 - len);
        }
        builder.append(hex);
        return builder.toString();
    }

    public static String toUnicodeHex(char ch) {
        return "\\u" + DIGITS_LOWER[ch >> 12 & 0xF] + DIGITS_LOWER[ch >> 8 & 0xF] + DIGITS_LOWER[ch >> 4 & 0xF] + DIGITS_LOWER[ch & 0xF];
    }

    public static String toHex(int value) {
        return Integer.toHexString(value);
    }

    public static int hexToInt(String value) {
        return Integer.parseInt(value, 16);
    }

    public static String toHex(long value) {
        return Long.toHexString(value);
    }

    public static long hexToLong(String value) {
        return Long.parseLong(value, 16);
    }

    public static void appendHex(StringBuilder builder, byte b, boolean toLowerCase) {
        char[] toDigits = toLowerCase ? DIGITS_LOWER : DIGITS_UPPER;
        int high = (b & 0xF0) >>> 4;
        int low = b & 0xF;
        builder.append(toDigits[high]);
        builder.append(toDigits[low]);
    }

    public static BigInteger toBigInteger(String hexStr) {
        return null == hexStr ? null : new BigInteger(hexStr, 16);
    }

    public static String format(String hexStr) {
        int length = hexStr.length();
        StringBuilder builder = new StringBuilder(length + length / 2);
        builder.append(hexStr.charAt(0)).append(hexStr.charAt(1));
        for (int i = 2; i < length - 1; i += 2) {
            builder.append(' ').append(hexStr.charAt(i)).append(hexStr.charAt(i + 1));
        }
        return builder.toString();
    }

    private static String encodeHexStr(byte[] data, char[] toDigits) {
        return new String(HexUtil.encodeHex(data, toDigits));
    }

    private static char[] encodeHex(byte[] data, char[] toDigits) {
        int len = data.length;
        char[] out = new char[len << 1];
        int var5 = 0;
        for (int i = 0; i < len; ++i) {
            out[var5++] = toDigits[(0xF0 & data[i]) >>> 4];
            out[var5++] = toDigits[0xF & data[i]];
        }
        return out;
    }

    private static int toDigit(char ch, int index) {
        int digit = Character.digit(ch, 16);
        if (digit < 0) {
            throw new HexException("Illegal hexadecimal character %s at index %s", Character.valueOf(ch), index);
        }
        return digit;
    }

    public static byte[] decode(String key) {
        return HexUtil.isHex(key) ? HexUtil.decodeHex(key) : Base64.getDecoder().decode(key);
    }

    public static boolean isHex(CharSequence value) {
        return StrUtil.isMatch(HEX, value);
    }

    public static String byteToHex(byte[] data) {
        StringBuilder builder = new StringBuilder();
        for (byte b : data) {
            builder.append(String.format("%02x", b));
        }
        return builder.toString();
    }
}

