/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.fintech.core.util;

import com.kingdee.fintech.core.common.Assert;
import com.kingdee.fintech.core.common.KdIOException;
import com.kingdee.fintech.core.util.StrUtil;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;

public class IOUtil {
    public static byte[] readBytes(InputStream in) throws KdIOException {
        return IOUtil.readBytes(in, true);
    }

    public static byte[] readBytes(InputStream in, boolean isClose) throws KdIOException {
        byte[] result;
        if (!(in instanceof FileInputStream)) {
            return IOUtil.readBytes(in, isClose);
        }
        try {
            int available = in.available();
            result = new byte[available];
            int readLength = in.read(result);
            if (readLength != available) {
                throw new IOException(StrUtil.format("File length is [{}] but read [{}]!", available, readLength));
            }
        }
        catch (IOException var8) {
            throw new KdIOException(var8);
        }
        finally {
            if (isClose) {
                IOUtil.close(in);
            }
        }
        return result;
    }

    public static byte[] readBytes(InputStream in, int length) throws KdIOException {
        int readLength;
        if (null == in) {
            return null;
        }
        if (length <= 0) {
            return new byte[0];
        }
        byte[] b = new byte[length];
        try {
            readLength = in.read(b);
        }
        catch (IOException var5) {
            throw new KdIOException(var5);
        }
        if (readLength > 0 && readLength < length) {
            byte[] b2 = new byte[readLength];
            System.arraycopy(b, 0, b2, 0, readLength);
            return b2;
        }
        return b;
    }

    public static long copy(InputStream in, OutputStream out) throws IOException {
        return IOUtil.copy(in, out, 8192, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long copy(FileInputStream in, FileOutputStream out) throws IOException {
        long lenth;
        Assert.notNull(in, "FileInputStream is null!", new Object[0]);
        Assert.notNull(out, "FileOutputStream is null!", new Object[0]);
        FileChannel inChannel = null;
        FileChannel outChannel = null;
        try {
            inChannel = in.getChannel();
            outChannel = out.getChannel();
            lenth = inChannel.transferTo(0L, inChannel.size(), outChannel);
        }
        catch (Throwable throwable) {
            IOUtil.close(outChannel);
            IOUtil.close(inChannel);
            throw throwable;
        }
        IOUtil.close(outChannel);
        IOUtil.close(inChannel);
        return lenth;
    }

    public static long copy(InputStream in, OutputStream out, int bufferSize, long count) throws IOException {
        return IOUtil.doCopy(in, out, new byte[IOUtil.bufferSize(bufferSize, count)], count);
    }

    private static long doCopy(InputStream source, OutputStream target, byte[] buffer, long count) throws IOException {
        int read;
        long numToRead = count > 0L ? count : Long.MAX_VALUE;
        long total = 0L;
        while (numToRead > 0L && (read = source.read(buffer, 0, IOUtil.bufferSize(buffer.length, numToRead))) >= 0) {
            target.write(buffer, 0, read);
            numToRead -= (long)read;
            total += (long)read;
        }
        return total;
    }

    private static int bufferSize(long bufferSize, long count) {
        return (int)Math.min(bufferSize, count);
    }

    public static void close(Closeable closeable) {
        if (null != closeable) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

