/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.fintech.core.util;

import com.kingdee.fintech.core.common.Assert;
import com.kingdee.fintech.core.common.KdCryptoException;
import com.kingdee.fintech.core.common.KdIOException;
import com.kingdee.fintech.core.common.SMConstant;
import com.kingdee.fintech.core.crypto.BCProvider;
import com.kingdee.fintech.core.crypto.SM2KeyPair;
import com.kingdee.fintech.core.util.ArrayUtil;
import com.kingdee.fintech.core.util.HexUtil;
import com.kingdee.fintech.core.util.SecureUtil;
import com.kingdee.fintech.core.util.StrUtil;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.sec.ECPrivateKey;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import org.bouncycastle.jcajce.spec.OpenSSHPrivateKeySpec;
import org.bouncycastle.jcajce.spec.OpenSSHPublicKeySpec;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.math.ec.FixedPointCombMultiplier;
import org.bouncycastle.util.BigIntegers;

public class KeyUtil {
    public static final SM2KeyPair generateSm2Keys() {
        KeyPair pair = KeyUtil.generateKeyPair("SM2");
        PublicKey publicKey = pair.getPublic();
        PrivateKey privateKey = pair.getPrivate();
        SM2KeyPair keyPair = new SM2KeyPair(SecureUtil.getPublicKeyBase64(publicKey), SecureUtil.getPrivateKeyBase64(privateKey));
        System.out.println("publicKey:" + keyPair.getPublicKey());
        System.out.println("privateKey:" + keyPair.getPrivateKey());
        return keyPair;
    }

    public static KeyPair generateKeyPair(String algorithm) {
        int keySize = 4096;
        if ("ECIES".equalsIgnoreCase(algorithm)) {
            keySize = 256;
        }
        return KeyUtil.generateKeyPair(algorithm, keySize, null);
    }

    public static KeyPair generateKeyPair(String algorithm, int keySize, byte[] seed) {
        if ("SM2".equalsIgnoreCase(algorithm)) {
            ECGenParameterSpec sm2p256v1 = new ECGenParameterSpec("sm2p256v1");
            return KeyUtil.generateKeyPair(algorithm, keySize, seed, sm2p256v1);
        }
        return KeyUtil.generateKeyPair(algorithm, keySize, seed, (AlgorithmParameterSpec[])null);
    }

    public static KeyPair generateKeyPair(String algorithm, int keySize, byte[] seed, AlgorithmParameterSpec ... params) {
        return KeyUtil.generateKeyPair(algorithm, keySize, KeyUtil.createSecureRandom(seed), params);
    }

    public static KeyPair generateKeyPair(String algorithm, int keySize, SecureRandom random, AlgorithmParameterSpec ... params) {
        algorithm = KeyUtil.getAlgorithmAfterWith(algorithm);
        KeyPairGenerator keyPairGen = KeyUtil.getKeyPairGenerator(algorithm);
        if (keySize > 0) {
            if ("EC".equalsIgnoreCase(algorithm) && keySize > 256) {
                keySize = 256;
            }
            if (null != random) {
                keyPairGen.initialize(keySize, random);
            } else {
                keyPairGen.initialize(keySize);
            }
        }
        if (ArrayUtil.isNotEmpty(params)) {
            AlgorithmParameterSpec[] specs = params;
            int length = params.length;
            for (int i = 0; i < length; ++i) {
                AlgorithmParameterSpec param = specs[i];
                if (null == param) continue;
                try {
                    if (null != random) {
                        keyPairGen.initialize(param, random);
                        continue;
                    }
                    keyPairGen.initialize(param);
                    continue;
                }
                catch (InvalidAlgorithmParameterException e) {
                    throw new KdCryptoException(e);
                }
            }
        }
        return keyPairGen.generateKeyPair();
    }

    public static String getAlgorithmAfterWith(String algorithm) {
        Assert.notNull(algorithm, "algorithm must be not null !", new Object[0]);
        if (StrUtil.startsWithIgnoreCase(algorithm, "ECIESWith")) {
            return "EC";
        }
        int indexOfWith = StrUtil.lastIndexOfIgnoreCase(algorithm, "with");
        if (indexOfWith > 0) {
            algorithm = StrUtil.subSuf(algorithm, indexOfWith + "with".length());
        }
        if ("ECDSA".equalsIgnoreCase(algorithm) || "SM2".equalsIgnoreCase(algorithm) || "ECIES".equalsIgnoreCase(algorithm)) {
            algorithm = "EC";
        }
        return algorithm;
    }

    public static KeyPairGenerator getKeyPairGenerator(String algorithm) {
        Provider provider = BCProvider.INSTANCE.getProvider();
        try {
            KeyPairGenerator keyPairGen = null == provider ? KeyPairGenerator.getInstance(KeyUtil.getMainAlgorithm(algorithm)) : KeyPairGenerator.getInstance(KeyUtil.getMainAlgorithm(algorithm), provider);
            return keyPairGen;
        }
        catch (NoSuchAlgorithmException e) {
            throw new KdCryptoException(e);
        }
    }

    public static KeyFactory getKeyFactory(String algorithm) {
        Provider provider = BCProvider.INSTANCE.getProvider();
        try {
            KeyFactory keyFactory = null == provider ? KeyFactory.getInstance(KeyUtil.getMainAlgorithm(algorithm)) : KeyFactory.getInstance(KeyUtil.getMainAlgorithm(algorithm), provider);
            return keyFactory;
        }
        catch (NoSuchAlgorithmException e) {
            throw new KdCryptoException(e);
        }
    }

    public static String getMainAlgorithm(String algorithm) {
        Assert.notBlank(algorithm, "Algorithm must be not blank!", new Object[0]);
        int slashIndex = algorithm.indexOf(47);
        return slashIndex > 0 ? algorithm.substring(0, slashIndex) : algorithm;
    }

    public static PrivateKey generatePrivateKey(String algorithm, byte[] key) {
        return null == key ? null : KeyUtil.generatePrivateKey(algorithm, new PKCS8EncodedKeySpec(key));
    }

    public static PrivateKey generatePrivateKey(String algorithm, KeySpec keySpec) {
        if (null == keySpec) {
            return null;
        }
        algorithm = KeyUtil.getAlgorithmAfterWith(algorithm);
        try {
            return KeyUtil.getKeyFactory(algorithm).generatePrivate(keySpec);
        }
        catch (Exception e) {
            throw new KdCryptoException(e);
        }
    }

    public static PublicKey generatePublicKey(String algorithm, byte[] key) {
        return null == key ? null : KeyUtil.generatePublicKey(algorithm, new X509EncodedKeySpec(key));
    }

    public static PublicKey generatePublicKey(String algorithm, KeySpec keySpec) {
        if (null == keySpec) {
            return null;
        }
        algorithm = KeyUtil.getAlgorithmAfterWith(algorithm);
        try {
            return KeyUtil.getKeyFactory(algorithm).generatePublic(keySpec);
        }
        catch (Exception e) {
            throw new KdCryptoException(e);
        }
    }

    public static SecureRandom createSecureRandom(byte[] seed) {
        return null == seed ? new SecureRandom() : new SecureRandom(seed);
    }

    public static SecretKey generateKey(String algorithm) {
        return KeyUtil.generateKey(algorithm, -1);
    }

    public static SecretKey generateKey(String algorithm, int keySize) {
        return KeyUtil.generateKey(algorithm, keySize, null);
    }

    public static SecretKey generateKey(String algorithm, int keySize, SecureRandom random) {
        algorithm = KeyUtil.getMainAlgorithm(algorithm);
        KeyGenerator keyGenerator = KeyUtil.getKeyGenerator(algorithm);
        if (keySize <= 0 && "AES".equals(algorithm)) {
            keySize = 128;
        }
        if (keySize > 0) {
            if (null == random) {
                keyGenerator.init(keySize);
            } else {
                keyGenerator.init(keySize, random);
            }
        }
        return keyGenerator.generateKey();
    }

    public static KeyGenerator getKeyGenerator(String algorithm) {
        Provider provider = BCProvider.INSTANCE.getProvider();
        try {
            KeyGenerator generator = null == provider ? KeyGenerator.getInstance(KeyUtil.getMainAlgorithm(algorithm)) : KeyGenerator.getInstance(KeyUtil.getMainAlgorithm(algorithm), provider);
            return generator;
        }
        catch (NoSuchAlgorithmException e) {
            throw new KdCryptoException(e);
        }
    }

    public static SecretKey generateKey(String algorithm, byte[] key) {
        Assert.notBlank(algorithm, "Algorithm is blank!", new Object[0]);
        SecretKey secretKey = null;
        if (algorithm.startsWith("SM4")) {
            secretKey = null == key ? KeyUtil.generateKey(algorithm) : new SecretKeySpec(key, algorithm);
        }
        return secretKey;
    }

    public static AsymmetricKeyParameter toParams(Key key) {
        if (key instanceof PrivateKey) {
            return KeyUtil.toPrivateParams((PrivateKey)key);
        }
        return key instanceof PublicKey ? KeyUtil.toPublicParams((PublicKey)key) : null;
    }

    public static ECPublicKeyParameters getPublicParams(ECPrivateKeyParameters privateKeyParameters) {
        ECDomainParameters domainParameters = privateKeyParameters.getParameters();
        ECPoint q = new FixedPointCombMultiplier().multiply(domainParameters.getG(), privateKeyParameters.getD());
        return new ECPublicKeyParameters(q, domainParameters);
    }

    public static ECPublicKeyParameters toSm2PublicParams(byte[] q) {
        return KeyUtil.toPublicParams(q, SMConstant.SM2_DOMAIN_PARAMS);
    }

    public static ECPublicKeyParameters toSm2PublicParams(String q) {
        return KeyUtil.toPublicParams(q, SMConstant.SM2_DOMAIN_PARAMS);
    }

    public static ECPublicKeyParameters toSm2PublicParams(String x, String y) {
        return KeyUtil.toPublicParams(x, y, SMConstant.SM2_DOMAIN_PARAMS);
    }

    public static ECPublicKeyParameters toSm2PublicParams(byte[] xBytes, byte[] yBytes) {
        return KeyUtil.toPublicParams(xBytes, yBytes, SMConstant.SM2_DOMAIN_PARAMS);
    }

    public static ECPublicKeyParameters toPublicParams(String x, String y, ECDomainParameters domainParameters) {
        return KeyUtil.toPublicParams(HexUtil.decode(x), HexUtil.decode(y), domainParameters);
    }

    public static ECPublicKeyParameters toPublicParams(byte[] xBytes, byte[] yBytes, ECDomainParameters domainParameters) {
        return null != xBytes && null != yBytes ? KeyUtil.toPublicParams(BigIntegers.fromUnsignedByteArray((byte[])xBytes), BigIntegers.fromUnsignedByteArray((byte[])yBytes), domainParameters) : null;
    }

    public static ECPublicKeyParameters toPublicParams(BigInteger x, BigInteger y, ECDomainParameters domainParameters) {
        if (null != x && null != y) {
            ECCurve curve = domainParameters.getCurve();
            return KeyUtil.toPublicParams(curve.createPoint(x, y), domainParameters);
        }
        return null;
    }

    public static ECPublicKeyParameters toPublicParams(String pointEncoded, ECDomainParameters domainParameters) {
        ECCurve curve = domainParameters.getCurve();
        return KeyUtil.toPublicParams(curve.decodePoint(HexUtil.decode(pointEncoded)), domainParameters);
    }

    public static ECPublicKeyParameters toPublicParams(byte[] pointEncoded, ECDomainParameters domainParameters) {
        ECCurve curve = domainParameters.getCurve();
        return KeyUtil.toPublicParams(curve.decodePoint(pointEncoded), domainParameters);
    }

    public static ECPublicKeyParameters toPublicParams(ECPoint point, ECDomainParameters domainParameters) {
        return new ECPublicKeyParameters(point, domainParameters);
    }

    public static ECPublicKeyParameters toPublicParams(PublicKey publicKey) {
        if (null == publicKey) {
            return null;
        }
        try {
            return (ECPublicKeyParameters)ECUtil.generatePublicKeyParameter((PublicKey)publicKey);
        }
        catch (InvalidKeyException var2) {
            throw new KdCryptoException(var2);
        }
    }

    public static ECPrivateKeyParameters toSm2PrivateParams(String d) {
        return KeyUtil.toPrivateParams(d, SMConstant.SM2_DOMAIN_PARAMS);
    }

    public static ECPrivateKeyParameters toSm2PrivateParams(byte[] d) {
        return KeyUtil.toPrivateParams(d, SMConstant.SM2_DOMAIN_PARAMS);
    }

    public static ECPrivateKeyParameters toSm2PrivateParams(BigInteger d) {
        return KeyUtil.toPrivateParams(d, SMConstant.SM2_DOMAIN_PARAMS);
    }

    public static ECPrivateKeyParameters toPrivateParams(String d, ECDomainParameters domainParameters) {
        return KeyUtil.toPrivateParams(BigIntegers.fromUnsignedByteArray((byte[])HexUtil.decode(d)), domainParameters);
    }

    public static ECPrivateKeyParameters toPrivateParams(byte[] d, ECDomainParameters domainParameters) {
        return KeyUtil.toPrivateParams(BigIntegers.fromUnsignedByteArray((byte[])d), domainParameters);
    }

    public static ECPrivateKeyParameters toPrivateParams(BigInteger d, ECDomainParameters domainParameters) {
        return null == d ? null : new ECPrivateKeyParameters(d, domainParameters);
    }

    public static ECPrivateKeyParameters toPrivateParams(PrivateKey privateKey) {
        if (null == privateKey) {
            return null;
        }
        try {
            return (ECPrivateKeyParameters)ECUtil.generatePrivateKeyParameter((PrivateKey)privateKey);
        }
        catch (InvalidKeyException var2) {
            throw new KdCryptoException(var2);
        }
    }

    public static PrivateKey toSm2PrivateKey(ECPrivateKey privateKey) {
        try {
            PrivateKeyInfo info = new PrivateKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, (ASN1Encodable)SMConstant.ID_SM2_PUBLIC_KEY_PARAM), (ASN1Encodable)privateKey);
            return KeyUtil.generatePrivateKey("SM2", info.getEncoded());
        }
        catch (IOException var2) {
            throw new KdIOException(var2);
        }
    }

    public static KeySpec createOpenSSHPrivateKeySpec(byte[] key) {
        return new OpenSSHPrivateKeySpec(key);
    }

    public static KeySpec createOpenSSHPublicKeySpec(byte[] key) {
        return new OpenSSHPublicKeySpec(key);
    }

    public static ECPrivateKeyParameters decodePrivateKeyParams(byte[] privateKeyBytes) {
        try {
            return KeyUtil.toSm2PrivateParams(privateKeyBytes);
        }
        catch (Exception e) {
            PrivateKey privateKey;
            try {
                privateKey = KeyUtil.generatePrivateKey("sm2", privateKeyBytes);
            }
            catch (Exception e1) {
                privateKey = KeyUtil.generatePrivateKey("sm2", KeyUtil.createOpenSSHPrivateKeySpec(privateKeyBytes));
            }
            return KeyUtil.toPrivateParams(privateKey);
        }
    }

    public static ECPublicKeyParameters decodePublicKeyParams(byte[] publicKeyBytes) {
        try {
            return KeyUtil.toSm2PublicParams(publicKeyBytes);
        }
        catch (Exception var4) {
            PublicKey publicKey;
            try {
                publicKey = KeyUtil.generatePublicKey("sm2", publicKeyBytes);
            }
            catch (Exception var3) {
                publicKey = KeyUtil.generatePublicKey("sm2", KeyUtil.createOpenSSHPublicKeySpec(publicKeyBytes));
            }
            return KeyUtil.toPublicParams(publicKey);
        }
    }
}

