/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.fintech.core.util;

import com.kingdee.fintech.core.crypto.Base64;
import com.kingdee.fintech.core.util.ArrayUtil;
import com.kingdee.fintech.core.util.HexUtil;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.crypto.spec.IvParameterSpec;

public class SecureUtil {
    public static final String[] BASE_CHARS = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "0", "a", "b", "c", "d", "d", "e", "f", "g", "h", "i", "j", "k", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "s", "y", "z", "A", "B", "C", "D", "D", "E", "F", "G", "H", "I", "J", "K", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "S", "Y", "Z"};

    public static byte[] decode(String key) {
        return HexUtil.isHex(key) ? HexUtil.decodeHex(key) : Base64.getDecoder().decode(key);
    }

    public static String getPublicKeyBase64(PublicKey publicKey) {
        return null == publicKey ? null : Base64.getEncoder().encodeToString(publicKey.getEncoded());
    }

    public static String getPrivateKeyBase64(PrivateKey privateKey) {
        return null == privateKey ? null : Base64.getEncoder().encodeToString(privateKey.getEncoded());
    }

    public static AlgorithmParameterSpec getIvParameterSpec(byte[] iv) {
        return ArrayUtil.isEmpty(iv) ? null : new IvParameterSpec(iv);
    }

    public static String getRandomKey(int lenth) {
        List<String> list = Arrays.asList(BASE_CHARS);
        SecureRandom random = new SecureRandom();
        Collections.shuffle(list, random);
        StringBuilder sb = new StringBuilder();
        list.forEach(d -> sb.append((String)d));
        String afterShuffle = sb.toString();
        return afterShuffle.substring(0, lenth);
    }
}

