/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.fintech.core.util;

import com.kingdee.fintech.core.util.ArrayUtil;
import com.kingdee.fintech.core.util.StrFormatter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.regex.Pattern;

public class StrUtil {
    public static final char C_BACKSLASH = '\\';
    public static final String EMPTY_JSON = "{}";
    public static final String NULL = "null";
    private static final SecureRandom DEFAULT_NUMBER_GENERATOR = new SecureRandom();
    private static final char[] DEFAULT_ALPHABET = "_-0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
    public static final String SPACE = " ";
    public static final String EMPTY = "";
    public static final String SPLIT_IV = "$";

    public static String cleanBlank(CharSequence str) {
        return StrUtil.filter(str, c -> !StrUtil.isBlankChar(c.charValue()));
    }

    public static String filter(CharSequence str, Predicate<Character> filter) {
        if (str != null && filter != null) {
            int len = str.length();
            StringBuilder sb = new StringBuilder(len);
            for (int i = 0; i < len; ++i) {
                char c = str.charAt(i);
                if (!filter.test(Character.valueOf(c))) continue;
                sb.append(c);
            }
            return sb.toString();
        }
        return StrUtil.str(str);
    }

    public static String str(CharSequence cs) {
        return null == cs ? null : cs.toString();
    }

    public static byte[] bytes(CharSequence str, Charset charset) {
        if (str == null) {
            return null;
        }
        return null == charset ? str.toString().getBytes() : str.toString().getBytes(charset);
    }

    public static String format(CharSequence template, Object ... params) {
        if (null == template) {
            return NULL;
        }
        if (ArrayUtil.isEmpty(params) || template.length() == 0) {
            return template.toString();
        }
        return StrFormatter.format(template.toString(), params);
    }

    public static boolean contains(CharSequence str, CharSequence searchStr) {
        return null != str && null != searchStr ? str.toString().contains(searchStr) : false;
    }

    public static boolean isEmpty(CharSequence str) {
        return str == null || str.length() == 0;
    }

    public static boolean isBlankChar(char c) {
        return StrUtil.isBlankChar((int)c);
    }

    public static boolean isBlankChar(int c) {
        return Character.isWhitespace(c) || Character.isSpaceChar(c) || c == 65279 || c == 8234 || c == 0;
    }

    public static String format(String strPattern, Object ... argArray) {
        return StrUtil.format(strPattern, EMPTY_JSON, argArray);
    }

    public static String format(String formatStr, String placeHolder, Object ... argArray) {
        if (!(StrUtil.isBlank(formatStr) || StrUtil.isBlank(placeHolder) || ArrayUtil.isEmpty(argArray))) {
            int formatStrLen = formatStr.length();
            int placeHolderLen = placeHolder.length();
            StringBuilder strBuilder = new StringBuilder(formatStrLen + 50);
            int position = 0;
            for (int argIndex = 0; argIndex < argArray.length; ++argIndex) {
                int delimIndex = formatStr.indexOf(placeHolder, position);
                if (delimIndex == -1) {
                    if (position == 0) {
                        return formatStr;
                    }
                    strBuilder.append(formatStr, position, formatStrLen);
                    return strBuilder.toString();
                }
                if (delimIndex > 0 && formatStr.charAt(delimIndex - 1) == '\\') {
                    if (delimIndex > 1 && formatStr.charAt(delimIndex - 2) == '\\') {
                        strBuilder.append(formatStr, position, delimIndex - 1);
                        strBuilder.append(StrUtil.utf8Str(argArray[argIndex]));
                        position = delimIndex + placeHolderLen;
                        continue;
                    }
                    --argIndex;
                    strBuilder.append(formatStr, position, delimIndex - 1);
                    strBuilder.append(placeHolder.charAt(0));
                    position = delimIndex + 1;
                    continue;
                }
                strBuilder.append(formatStr, position, delimIndex);
                strBuilder.append(StrUtil.utf8Str(argArray[argIndex]));
                position = delimIndex + placeHolderLen;
            }
            strBuilder.append(formatStr, position, formatStrLen);
            return strBuilder.toString();
        }
        return formatStr;
    }

    public static boolean isMatch(Pattern pattern, CharSequence content) {
        return content != null && pattern != null ? pattern.matcher(content).matches() : false;
    }

    public static String subSuf(CharSequence string, int fromIndex) {
        return StrUtil.isEmpty(string) ? null : StrUtil.sub(string, fromIndex, string.length());
    }

    public static String sub(CharSequence str, int fromIndexInclude, int toIndexExclude) {
        if (StrUtil.isEmpty(str)) {
            return StrUtil.str(str);
        }
        int len = str.length();
        if (fromIndexInclude < 0) {
            if ((fromIndexInclude += len) < 0) {
                fromIndexInclude = 0;
            }
        } else if (fromIndexInclude > len) {
            fromIndexInclude = len;
        }
        if (toIndexExclude < 0) {
            if ((toIndexExclude += len) < 0) {
                toIndexExclude = len;
            }
        } else if (toIndexExclude > len) {
            toIndexExclude = len;
        }
        if (toIndexExclude < fromIndexInclude) {
            int tmp = fromIndexInclude;
            fromIndexInclude = toIndexExclude;
            toIndexExclude = tmp;
        }
        return fromIndexInclude == toIndexExclude ? EMPTY : str.toString().substring(fromIndexInclude, toIndexExclude);
    }

    public static String replace(String text, String searchString, String replacement) {
        return StrUtil.replace(text, searchString, replacement, -1);
    }

    public static String replaceIgnoreCase(String text, String searchString, String replacement) {
        return StrUtil.replaceIgnoreCase(text, searchString, replacement, -1);
    }

    public static String replaceIgnoreCase(String text, String searchString, String replacement, int max) {
        return StrUtil.replace(text, searchString, replacement, max, true);
    }

    public static String replace(String text, String searchString, String replacement, int max) {
        return StrUtil.replace(text, searchString, replacement, max, false);
    }

    private static String replace(String text, String searchString, String replacement, int max, boolean ignoreCase) {
        if (!StrUtil.isEmpty(text) && !StrUtil.isEmpty(searchString) && replacement != null && max != 0) {
            int start;
            int end;
            String searchText = text;
            if (ignoreCase) {
                searchText = text.toLowerCase();
                searchString = searchString.toLowerCase();
            }
            if ((end = searchText.indexOf(searchString, start = 0)) == -1) {
                return text;
            }
            int replLength = searchString.length();
            int increase = replacement.length() - replLength;
            int n = increase = increase < 0 ? 0 : increase;
            StringBuilder buf = new StringBuilder(text.length() + (increase *= max < 0 ? 16 : (max > 64 ? 64 : max)));
            while (end != -1) {
                buf.append(text, start, end).append(replacement);
                start = end + replLength;
                if (--max == 0) break;
                end = searchText.indexOf(searchString, start);
            }
            buf.append(text, start, text.length());
            return buf.toString();
        }
        return text;
    }

    public static boolean startsWithIgnoreCase(CharSequence str, CharSequence prefix) {
        return StrUtil.startsWith(str, prefix, true);
    }

    private static boolean startsWith(CharSequence str, CharSequence prefix, boolean ignoreCase) {
        if (str != null && prefix != null) {
            return prefix.length() > str.length() ? false : StrUtil.regionMatches(str, ignoreCase, 0, prefix, 0, prefix.length());
        }
        return str == null && prefix == null;
    }

    public static boolean endsWithIgnoreCase(CharSequence str, CharSequence suffix) {
        return StrUtil.endsWith(str, suffix, true);
    }

    public static int lastIndexOfIgnoreCase(CharSequence str, CharSequence searchStr) {
        return str != null && searchStr != null ? StrUtil.lastIndexOfIgnoreCase(str, searchStr, str.length()) : -1;
    }

    public static int lastIndexOfIgnoreCase(CharSequence str, CharSequence searchStr, int startPos) {
        if (str != null && searchStr != null) {
            if (startPos > str.length() - searchStr.length()) {
                startPos = str.length() - searchStr.length();
            }
            if (startPos < 0) {
                return -1;
            }
            if (searchStr.length() == 0) {
                return startPos;
            }
            for (int i = startPos; i >= 0; --i) {
                if (!StrUtil.regionMatches(str, true, i, searchStr, 0, searchStr.length())) continue;
                return i;
            }
            return -1;
        }
        return -1;
    }

    private static boolean endsWith(CharSequence str, CharSequence suffix, boolean ignoreCase) {
        if (str != null && suffix != null) {
            if (suffix.length() > str.length()) {
                return false;
            }
            int strOffset = str.length() - suffix.length();
            return StrUtil.regionMatches(str, ignoreCase, strOffset, suffix, 0, suffix.length());
        }
        return str == null && suffix == null;
    }

    public static boolean regionMatches(CharSequence cs, boolean ignoreCase, int thisStart, CharSequence substring, int start, int length) {
        if (cs instanceof String && substring instanceof String) {
            return ((String)cs).regionMatches(ignoreCase, thisStart, (String)substring, start, length);
        }
        int index1 = thisStart;
        int index2 = start;
        int tmpLen = length;
        int srcLen = cs.length() - thisStart;
        int otherLen = substring.length() - start;
        if (thisStart >= 0 && start >= 0 && length >= 0) {
            if (srcLen >= length && otherLen >= length) {
                while (tmpLen-- > 0) {
                    char c2;
                    char c1;
                    if ((c1 = cs.charAt(index1++)) == (c2 = substring.charAt(index2++))) continue;
                    if (!ignoreCase) {
                        return false;
                    }
                    if (Character.toUpperCase(c1) == Character.toUpperCase(c2) || Character.toLowerCase(c1) == Character.toLowerCase(c2)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public static boolean isBlank(CharSequence cs) {
        int strLen;
        if (cs != null && (strLen = cs.length()) != 0) {
            for (int i = 0; i < strLen; ++i) {
                if (Character.isWhitespace(cs.charAt(i))) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isNotBlank(CharSequence cs) {
        return !StrUtil.isBlank(cs);
    }

    public static String uuid() {
        return UUID.randomUUID().toString().replaceAll("-", EMPTY);
    }

    public static String utf8Str(Object obj) {
        return StrUtil.str(obj, StandardCharsets.UTF_8);
    }

    public static String str(Object obj, Charset charset) {
        if (null == obj) {
            return null;
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof byte[]) {
            return new String((byte[])obj, charset);
        }
        if (ArrayUtil.isArray(obj)) {
            return ArrayUtil.toString(obj);
        }
        return obj.toString();
    }

    public static byte[] utf8Bytes(String str) {
        try {
            return str.getBytes(StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String randomId(int size) {
        char[] alphabet = DEFAULT_ALPHABET;
        if (size <= 0) {
            throw new IllegalArgumentException("Size must be greater than zero.");
        }
        int mask = (2 << (int)Math.floor(Math.log(alphabet.length - 1) / Math.log(2.0))) - 1;
        int step = (int)Math.ceil(1.6 * (double)mask * (double)size / (double)alphabet.length);
        StringBuilder idBuilder = new StringBuilder();
        block0: while (true) {
            byte[] bytes = new byte[step];
            DEFAULT_NUMBER_GENERATOR.nextBytes(bytes);
            int i = 0;
            while (true) {
                if (i >= step) continue block0;
                int alphabetIndex = bytes[i] & mask;
                if (alphabetIndex < alphabet.length) {
                    idBuilder.append(alphabet[alphabetIndex]);
                    if (idBuilder.length() == size) {
                        return idBuilder.toString();
                    }
                }
                ++i;
            }
            break;
        }
    }
}

