/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.fintech.client;

import com.kingdee.fintech.client.KdClient;
import com.kingdee.fintech.core.util.StrUtil;
import com.kingdee.fintech.request.base.KdRequest;
import com.kingdee.fintech.request.info.DomainApiInfo;
import com.kingdee.fintech.request.info.RequestInfo;
import com.kingdee.fintech.response.api.BaseData;
import com.kingdee.fintech.response.api.GwKdResponse;
import com.kingdee.fintech.response.api.KdResponse;
import com.kingdee.fintech.support.app.AppConfig;
import com.kingdee.fintech.support.client.ClientSupport;
import com.kingdee.fintech.support.http.DefaultHttpSender;
import com.kingdee.fintech.support.http.HttpClientConfig;
import com.kingdee.fintech.support.http.HttpResult;
import com.kingdee.fintech.support.http.HttpSender;
import com.kingdee.fintech.support.security.SecurityInstances;
import com.kingdee.fintech.support.security.SecurityService;
import com.kingdee.fintech.util.JacksonUtils;
import java.util.Map;

public class DefaultKdClient
implements KdClient {
    private AppConfig appConfig;
    private String domain;
    private HttpClientConfig httpClientConfig;
    private HttpSender httpSender = new DefaultHttpSender();

    public DefaultKdClient(AppConfig appConfig) {
        this.appConfig = appConfig;
        this.domain = appConfig.getDomain();
        this.httpClientConfig = new HttpClientConfig.Builder().build();
    }

    public DefaultKdClient(AppConfig appConfig, HttpClientConfig httpClientConfig) {
        this.appConfig = appConfig;
        this.httpClientConfig = httpClientConfig;
        this.domain = appConfig.getDomain();
    }

    public DefaultKdClient(AppConfig appConfig, HttpClientConfig httpClientConfig, HttpSender httpSender) {
        this.appConfig = appConfig;
        this.httpClientConfig = httpClientConfig;
        this.domain = appConfig.getDomain();
        this.httpSender = httpSender;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public void setHttpSender(HttpSender httpSender) {
        this.httpSender = httpSender;
    }

    @Override
    public <R> KdResponse<R> execute(KdRequest<RequestInfo<R>> kdRequest) throws Exception {
        Map<String, String> parameters;
        String[] encryptPair;
        String strToSign;
        String sign;
        Map<String, String> headers;
        String jsonParams = kdRequest.getJsonParams();
        String requestId = kdRequest.getRequestId();
        String timestamp = kdRequest.getTimestamp();
        RequestInfo<RequestInfo<R>> requestInfo = kdRequest.getRequestInfo();
        String serviceId = requestInfo.getServiceId();
        SecurityService securityService = SecurityInstances.getSecurityService(this.appConfig.getVersion());
        if (securityService == null) {
            throw new Exception("\u672a\u914d\u7f6e\u6216\u9519\u8bef\u7684\u7248\u672c\u53f7" + (StrUtil.isBlank((CharSequence)this.appConfig.getVersion()) ? "" : "\u3010" + this.appConfig.getVersion() + "\u3011"));
        }
        String url = requestInfo instanceof DomainApiInfo ? ((DomainApiInfo)requestInfo).getDomain() + requestInfo.getPath() : this.domain + requestInfo.getPath();
        HttpResult result = this.httpSender.doPost(url, headers = ClientSupport.createHeaders(this.appConfig, sign = securityService.sign(strToSign = ClientSupport.createSignStr(this.appConfig, (encryptPair = securityService.encrypt(jsonParams, this.appConfig))[0], serviceId, timestamp, encryptPair[1]), this.appConfig), serviceId, timestamp, encryptPair[1]), parameters = ClientSupport.createRequestParams(this.appConfig, requestId, serviceId, timestamp, encryptPair[0], sign, encryptPair[1]), this.httpClientConfig);
        if (result == null || result.getStatusCode() != 200) {
            KdResponse kdResponse = new KdResponse();
            kdResponse.setStatus("-1");
            kdResponse.setMsg(result == null ? "\u54cd\u5e94\u4e3a\u7a7a" : "\u54cd\u5e94\u5f02\u5e38\uff0cHttp Status\u3010" + result.getStatusCode() + "\u3011");
            return kdResponse;
        }
        if (StrUtil.isBlank((CharSequence)result.getBody())) {
            return ClientSupport.parseKdResponse(result.getHeaders(), null);
        }
        GwKdResponse gwKdResponse = JacksonUtils.readValue(result.getBody(), GwKdResponse.class);
        KdResponse<RequestInfo<R>> parsedResponse = new KdResponse<RequestInfo<R>>(gwKdResponse.getStatus(), gwKdResponse.getMsg(), gwKdResponse.getRequestId());
        parsedResponse.setHeaders(ClientSupport.filterKdHeaders(result.getHeaders()));
        BaseData baseData = gwKdResponse.getData();
        if (baseData == null) {
            return parsedResponse;
        }
        String localStrToSign = ClientSupport.createSignStr4Response(baseData.getResult(), baseData.getTimestamp(), baseData.getOtp(), baseData.getVersion());
        boolean flag = securityService.verify(localStrToSign, baseData.getSign(), this.appConfig);
        if (!flag) {
            throw new IllegalStateException("\u8fd4\u56de\u9a8c\u7b7e\u4e0d\u901a\u8fc7, \u8bf7\u4e0d\u8981\u7ee7\u7eed\u4e1a\u52a1\u6d41\u7a0b\u3002");
        }
        String encryptData = baseData.getResult();
        String decryptData = securityService.decrypt(encryptData, this.appConfig, baseData.getOtp());
        parsedResponse.setSrcData(decryptData);
        parsedResponse.setData(JacksonUtils.readValue(decryptData, requestInfo.getResponseClass()));
        return parsedResponse;
    }
}

