/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.fintech.client;

import com.kingdee.fintech.client.KdNapiClient;
import com.kingdee.fintech.core.util.StrUtil;
import com.kingdee.fintech.response.napi.GwNotifyResponse;
import com.kingdee.fintech.response.napi.NotifyData;
import com.kingdee.fintech.response.napi.NotifyResponse;
import com.kingdee.fintech.support.app.AppConfig;
import com.kingdee.fintech.support.client.ClientSupport;
import com.kingdee.fintech.support.security.SecurityInstances;
import com.kingdee.fintech.support.security.SecurityService;
import javax.servlet.http.HttpServletRequest;

public class DefaultKdNapiClient
implements KdNapiClient {
    private AppConfig appConfig;

    public DefaultKdNapiClient(AppConfig appConfig) {
        this.appConfig = appConfig;
    }

    @Override
    public NotifyResponse notify(HttpServletRequest request) throws Exception {
        GwNotifyResponse gwNotifyResponse = ClientSupport.getOriginalNotifyResp(request);
        NotifyData notifyData = gwNotifyResponse.getData();
        SecurityService securityService = SecurityInstances.getSecurityService(notifyData.getVersion());
        if (securityService == null) {
            throw new Exception("\u672a\u914d\u7f6e\u6216\u9519\u8bef\u7684\u7248\u672c\u53f7" + (StrUtil.isBlank((CharSequence)notifyData.getVersion()) ? "" : "\u3010" + notifyData.getVersion() + "\u3011"));
        }
        String kdGwSign = notifyData.getSign();
        String localSignStr = ClientSupport.createSignStr4Napi(notifyData.getResult(), gwNotifyResponse.getNotifyId(), notifyData.getTimestamp(), notifyData.getOtp(), notifyData.getVersion());
        boolean flag = securityService.verify(localSignStr, kdGwSign, this.appConfig);
        if (!flag) {
            throw new IllegalStateException("\u8fd4\u56de\u9a8c\u7b7e\u4e0d\u901a\u8fc7, \u8bf7\u4e0d\u8981\u7ee7\u7eed\u4e1a\u52a1\u6d41\u7a0b\u3002");
        }
        String bizContent = securityService.decrypt(notifyData.getResult(), this.appConfig, notifyData.getOtp());
        NotifyResponse notifyResponse = new NotifyResponse();
        notifyResponse.setBizContent(bizContent);
        notifyResponse.setNotifyId(gwNotifyResponse.getNotifyId());
        notifyResponse.setTimestamp(gwNotifyResponse.getTimestamp());
        notifyResponse.setHeaders(ClientSupport.getRequestHeaders(request));
        return notifyResponse;
    }
}

