/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.fintech.support.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.kingdee.fintech.constant.Constants;
import com.kingdee.fintech.core.util.StrUtil;
import com.kingdee.fintech.response.api.KdResponse;
import com.kingdee.fintech.response.napi.GwNotifyResponse;
import com.kingdee.fintech.support.app.AppConfig;
import com.kingdee.fintech.util.JacksonUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;

public class ClientSupport {
    public static String createSignStr(AppConfig appConfig, String bizContent, String serviceId, String timestamp, String otp) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("biz-content").append("=").append(bizContent).append("&").append("kdgw-app-id").append("=").append(appConfig.getAppId()).append("&").append("kdgw-service-id").append("=").append(serviceId);
        if (StrUtil.isNotBlank((CharSequence)otp)) {
            sb.append("&").append("kdgw-security-otp").append("=").append(otp);
        }
        sb.append("&").append("kdgw-request-timestamp").append("=").append(timestamp).append("&").append("kdgw-security-version").append("=").append(appConfig.getVersion());
        return sb.toString();
    }

    public static String createSignStr4Napi(String bizContent, String notifyId, String timestamp, String otp, String version) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("biz-content").append("=").append(bizContent);
        if (StrUtil.isNotBlank((CharSequence)otp)) {
            sb.append("&").append("kdgw-security-otp").append("=").append(otp);
        }
        sb.append("&").append("kdgw-request-timestamp").append("=").append(timestamp).append("&").append("kdgw-notify-id").append("=").append(notifyId).append("&").append("kdgw-security-version").append("=").append(version);
        return sb.toString();
    }

    public static String createSignStr4Response(String bizContent, String timestamp, String otp, String version) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("biz-content").append("=").append(bizContent);
        if (StrUtil.isNotBlank((CharSequence)otp)) {
            sb.append("&").append("kdgw-security-otp").append("=").append(otp);
        }
        sb.append("&").append("kdgw-response-timestamp").append("=").append(timestamp).append("&").append("kdgw-security-version").append("=").append(version);
        return sb.toString();
    }

    public static Map<String, String> createHeaders(AppConfig appConfig, String sign, String serviceId, String timestamp, String otp) {
        HashMap<String, String> headers = new HashMap<String, String>(Constants.INIT_SIZE);
        headers.put("kdgw-app-id", appConfig.getAppId());
        headers.put("kdgw-security-sign", sign);
        headers.put("kdgw-service-id", serviceId);
        headers.put("kdgw-request-timestamp", timestamp);
        headers.put("kdgw-security-version", appConfig.getVersion());
        if (StrUtil.isNotBlank((CharSequence)otp)) {
            headers.put("kdgw-security-otp", otp);
        }
        return headers;
    }

    public static Map<String, String> createRequestParams(AppConfig appConfig, String requestId, String serviceId, String timestamp, String data, String sign, String otp) {
        HashMap<String, String> requestParams = new HashMap<String, String>(Constants.INIT_SIZE);
        requestParams.put("appId", appConfig.getAppId());
        requestParams.put("version", appConfig.getVersion());
        requestParams.put("serviceId", serviceId);
        requestParams.put("timestamp", timestamp);
        requestParams.put("data", data);
        requestParams.put("sign", sign);
        requestParams.put("requestId", requestId);
        if (StrUtil.isNotBlank((CharSequence)otp)) {
            requestParams.put("otp", otp);
        }
        return requestParams;
    }

    public static <T> KdResponse<T> parseKdResponse(Map<String, String> headers, String bizContent) throws Exception {
        KdResponse response = StrUtil.isNotBlank((CharSequence)bizContent) ? (KdResponse)JacksonUtils.readValue(bizContent, new TypeReference<KdResponse<T>>(){}) : (KdResponse)JacksonUtils.readValue("{}", new TypeReference<KdResponse<T>>(){});
        Map<String, String> resHeader = ClientSupport.filterKdHeaders(headers);
        response.setHeaders(resHeader);
        return response;
    }

    public static Map<String, String> filterKdHeaders(Map<String, String> allHeaders) {
        if (allHeaders == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> resHeader = new HashMap<String, String>(Constants.INIT_SIZE);
        for (Map.Entry<String, String> entry : allHeaders.entrySet()) {
            if (!entry.getKey().startsWith("kdgw")) continue;
            resHeader.put(entry.getKey(), entry.getValue());
        }
        return resHeader;
    }

    public static GwNotifyResponse getOriginalNotifyResp(HttpServletRequest request) throws IOException {
        String body = ClientSupport.getBodyString(request);
        return JacksonUtils.readValue(body, new TypeReference<GwNotifyResponse>(){});
    }

    public static Map<String, String> getRequestHeaders(HttpServletRequest request) {
        HashMap<String, String> kdHeaders = new HashMap<String, String>(Constants.INIT_SIZE);
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            if (!headerName.startsWith("kdgw")) continue;
            kdHeaders.put(headerName, request.getHeader(headerName));
        }
        return kdHeaders;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getBodyString(HttpServletRequest request) throws IOException {
        StringBuilder sb = new StringBuilder();
        ServletInputStream inputStream = null;
        BufferedReader reader = null;
        try {
            String line;
            inputStream = request.getInputStream();
            reader = new BufferedReader(new InputStreamReader((InputStream)inputStream, Charset.forName("UTF-8")));
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (reader != null) {
                reader.close();
            }
        }
        return sb.toString().trim();
    }
}

