/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.fintech.support.http;

import com.kingdee.fintech.constant.Constants;

public class HttpClientConfig {
    private Integer connectionRequestTimeout;
    private Integer connectTimeout;
    private Integer socketTimeout;
    private Integer maxTotal;
    private Integer defaultMaxPerRoute;
    private String proxyHost;
    private Integer proxyPort;
    private String scheme;

    public Integer getConnectionRequestTimeout() {
        return this.connectionRequestTimeout;
    }

    public Integer getConnectTimeout() {
        return this.connectTimeout;
    }

    public Integer getSocketTimeout() {
        return this.socketTimeout;
    }

    public Integer getMaxTotal() {
        return this.maxTotal;
    }

    public Integer getDefaultMaxPerRoute() {
        return this.defaultMaxPerRoute;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public Integer getProxyPort() {
        return this.proxyPort;
    }

    public String getScheme() {
        return this.scheme;
    }

    private HttpClientConfig(Builder builder) {
        this.connectionRequestTimeout = builder.connectionRequestTimeout;
        this.connectTimeout = builder.connectTimeout;
        this.socketTimeout = builder.socketTimeout;
        this.maxTotal = builder.maxTotal;
        this.defaultMaxPerRoute = builder.defaultMaxPerRoute;
        this.proxyHost = builder.proxyHost;
        this.proxyPort = builder.proxyPort;
        this.scheme = builder.scheme;
    }

    public static class Builder {
        private Integer connectionRequestTimeout = Constants.HTTPCLIENT_REQUEST_TIMEOUT;
        private Integer connectTimeout = Constants.HTTPCLIENT_CONNECTION_TIMEOUT;
        private Integer socketTimeout = Constants.HTTPCLIENT_SOCKET_TIMEOUT;
        private Integer maxTotal = Constants.HTTPCLIENT_MAX_TOTAL;
        private Integer defaultMaxPerRoute = Constants.HTTPCLIENT_DEFAULT_MAX_PER_ROUTE;
        private String proxyHost;
        private Integer proxyPort;
        private String scheme;

        public Builder connectionRequestTimeout(Integer val) {
            this.connectionRequestTimeout = val;
            return this;
        }

        public Builder connectTimeout(Integer val) {
            this.connectTimeout = val;
            return this;
        }

        public Builder socketTimeout(Integer val) {
            this.socketTimeout = val;
            return this;
        }

        public Builder maxTotal(Integer val) {
            this.maxTotal = val;
            return this;
        }

        public Builder defaultMaxPerRoute(Integer val) {
            this.defaultMaxPerRoute = val;
            return this;
        }

        public Builder proxyHost(String val) {
            this.proxyHost = val;
            return this;
        }

        public Builder proxyPort(Integer val) {
            this.proxyPort = val;
            return this;
        }

        public Builder scheme(String val) {
            this.scheme = val;
            return this;
        }

        public HttpClientConfig build() {
            return new HttpClientConfig(this);
        }
    }
}

