/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.fintech.support.http;

import com.kingdee.fintech.constant.Constants;
import com.kingdee.fintech.core.util.StrUtil;
import com.kingdee.fintech.support.http.HttpClientConfig;
import com.kingdee.fintech.support.http.HttpResult;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;

public class HttpExecutor {
    private CloseableHttpClient httpClient;
    private volatile boolean initialized = false;
    private volatile boolean started = false;
    private static final HttpExecutor INSTANCE = new HttpExecutor();

    public static HttpExecutor getInstance() {
        return INSTANCE;
    }

    public void start(HttpClientConfig config) {
        this.started = true;
        this.init(config);
    }

    public void close() throws IOException {
        if (this.httpClient != null) {
            this.httpClient.close();
        }
        this.initialized = false;
    }

    public CloseableHttpResponse doInternalGet(String url, Map<String, String> headers, Map<String, String> queries, HttpClientConfig config) throws Exception {
        URIBuilder uriBuilder = new URIBuilder(url);
        if (queries != null) {
            for (Map.Entry<String, String> entry : queries.entrySet()) {
                uriBuilder.setParameter(entry.getKey(), entry.getValue());
            }
        }
        HttpGet httpGet = new HttpGet(uriBuilder.build());
        this.setHeaderInfo(headers, (HttpUriRequest)httpGet);
        return this.doInternalExecute((HttpRequestBase)httpGet, config);
    }

    public CloseableHttpResponse doInternalPost(String url, Map<String, String> headers, Map<String, String> params, HttpClientConfig config) throws Exception {
        HttpPost httpPost = new HttpPost(url);
        this.setHeaderInfo(headers, (HttpUriRequest)httpPost);
        this.setParametersInfo(params, (HttpEntityEnclosingRequestBase)httpPost);
        return this.doInternalExecute((HttpRequestBase)httpPost, config);
    }

    public CloseableHttpResponse doInternalJsonPost(String url, Map<String, String> headers, String json, HttpClientConfig config) throws Exception {
        HttpPost httpPost = new HttpPost(url);
        this.setHeaderInfo(headers, (HttpUriRequest)httpPost);
        this.setJsonEntity(json, httpPost);
        return this.doInternalExecute((HttpRequestBase)httpPost, config);
    }

    public static HttpResult getHttpResult(CloseableHttpResponse response) throws IOException {
        HttpResult var2;
        if (response == null) {
            return null;
        }
        try {
            HttpResult httpResult = new HttpResult();
            if (response != null && response.getStatusLine() != null && response.getStatusLine().getStatusCode() == 200) {
                HttpExecutor.setHeaders(response, httpResult);
                httpResult.setStatusCode(response.getStatusLine().getStatusCode());
                if (response.getEntity() != null) {
                    httpResult.setBody(HttpExecutor.getResultStr(response.getEntity(), "UTF-8"));
                }
            } else {
                httpResult.setStatusCode(response.getStatusLine().getStatusCode());
                if (response != null && response.getEntity() != null) {
                    httpResult.setBody(HttpExecutor.getResultStr(response.getEntity(), "UTF-8"));
                }
            }
            var2 = httpResult;
        }
        finally {
            try {
                response.close();
            }
            catch (Exception exception) {}
        }
        return var2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getResultStr(HttpEntity entity, String charsetName) throws IOException {
        InputStream inStream = null;
        BufferedReader in = null;
        InputStreamReader isr = null;
        try {
            inStream = entity.getContent();
            if (inStream != null) {
                String var7;
                String line;
                isr = new InputStreamReader(inStream, charsetName);
                in = new BufferedReader(isr);
                StringBuilder builder = new StringBuilder();
                while ((line = in.readLine()) != null) {
                    builder.append(line);
                }
                String string = var7 = builder.toString();
                return string;
            }
        }
        catch (IOException var12) {
            var12.printStackTrace();
            String string = null;
            return string;
        }
        catch (UnsupportedOperationException var13) {
            var13.printStackTrace();
            String string = null;
            return string;
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (isr != null) {
                isr.close();
            }
            if (inStream != null) {
                inStream.close();
            }
        }
        return null;
    }

    private String changeInputStream(InputStream inputStream, String encode) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        byte[] data = new byte[1024];
        String result = "";
        if (inputStream != null) {
            try {
                while (true) {
                    int len;
                    if ((len = inputStream.read(data)) == -1) {
                        result = new String(outputStream.toByteArray(), encode);
                        break;
                    }
                    outputStream.write(data, 0, len);
                }
            }
            catch (IOException var8) {
                var8.printStackTrace();
            }
        }
        return result;
    }

    private static void setHeaders(CloseableHttpResponse response, HttpResult httpResult) {
        Header[] allHeaders = response.getAllHeaders();
        if (allHeaders != null) {
            HashMap<String, String> headers = new HashMap<String, String>(Constants.INIT_SIZE);
            Header[] var4 = allHeaders;
            int var5 = allHeaders.length;
            for (int var6 = 0; var6 < var5; ++var6) {
                Header header = var4[var6];
                headers.put(header.getName(), header.getValue());
            }
            httpResult.setHeaders(headers);
        }
    }

    private HttpExecutor() {
    }

    private void init(HttpClientConfig config) {
        if (!this.initialized) {
            if (config == null) {
                throw new IllegalArgumentException("Please setup httpClientConfig.");
            }
            HttpHost proxy = null;
            if (StrUtil.isNotBlank((CharSequence)config.getProxyHost()) && config.getProxyPort() != null) {
                String scheme = StrUtil.isBlank((CharSequence)config.getScheme()) ? "http" : config.getScheme();
                proxy = new HttpHost(config.getProxyHost(), config.getProxyPort().intValue(), scheme);
            }
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(config.getConnectTimeout().intValue()).setSocketTimeout(config.getSocketTimeout().intValue()).setConnectionRequestTimeout(config.getConnectionRequestTimeout().intValue()).setProxy(proxy).build();
            PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager();
            connManager.setMaxTotal(config.getMaxTotal().intValue());
            connManager.setDefaultMaxPerRoute(config.getDefaultMaxPerRoute().intValue());
            this.httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connManager).setDefaultRequestConfig(requestConfig).build();
            this.initialized = true;
        }
    }

    private CloseableHttpResponse doInternalExecute(HttpRequestBase httpMethod, HttpClientConfig config) throws Exception {
        if (!this.started) {
            this.start(config);
        }
        return this.httpClient.execute((HttpUriRequest)httpMethod);
    }

    private void setHeaderInfo(Map<String, String> headers, HttpUriRequest httpUriRequest) {
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                httpUriRequest.setHeader(entry.getKey(), entry.getValue());
            }
        }
    }

    private void setParametersInfo(Map<String, String> parameters, HttpEntityEnclosingRequestBase requestBase) throws UnsupportedEncodingException {
        if (parameters != null) {
            ArrayList<BasicNameValuePair> nameValuePairList = new ArrayList<BasicNameValuePair>();
            for (Map.Entry<String, String> entry : parameters.entrySet()) {
                nameValuePairList.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
            }
            requestBase.setEntity((HttpEntity)new UrlEncodedFormEntity(nameValuePairList, "UTF-8"));
        }
    }

    private void setJsonEntity(String json, HttpPost httpPost) throws UnsupportedEncodingException {
        httpPost.setHeader("Content-Type", "application/json;charset=UTF-8");
        StringEntity se = new StringEntity(json);
        se.setContentEncoding("UTF-8");
        se.setContentType("application/json");
        httpPost.setEntity((HttpEntity)se);
    }
}

