/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.fintech.support.security;

import com.kingdee.fintech.constant.Version;
import com.kingdee.fintech.core.util.StrUtil;
import com.kingdee.fintech.support.security.SecurityService;
import com.kingdee.fintech.support.security.StandsV5SecurityServiceImpl;
import java.util.HashMap;
import java.util.Map;

public class SecurityInstances {
    private static final Map<String, SecurityService> SECURITY_SERVICE_MAP = new HashMap<String, SecurityService>(4);

    public static SecurityService getSecurityService(String version) {
        if (version == null) {
            return null;
        }
        return SECURITY_SERVICE_MAP.get(version);
    }

    public static Boolean register(String ver, SecurityService impl) {
        if (StrUtil.isBlank((CharSequence)ver) || SECURITY_SERVICE_MAP.containsKey(ver)) {
            return Boolean.FALSE;
        }
        SECURITY_SERVICE_MAP.put(ver, impl);
        return Boolean.TRUE;
    }

    static {
        SECURITY_SERVICE_MAP.put(Version.V5.getVer(), new StandsV5SecurityServiceImpl());
    }
}

