/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.fintech.support.security;

import com.kingdee.fintech.core.crypto.SM2;
import com.kingdee.fintech.core.crypto.SM3;
import com.kingdee.fintech.core.crypto.SM4;
import com.kingdee.fintech.core.util.StrUtil;
import com.kingdee.fintech.support.app.AppConfig;
import com.kingdee.fintech.support.security.SecurityService;

public class StandsV5SecurityServiceImpl
implements SecurityService {
    @Override
    public String[] encrypt(String srcData, AppConfig appConfig) throws Exception {
        String otp = StrUtil.randomId((int)16);
        String iv = StrUtil.randomId((int)16);
        SM4 sm4 = new SM4("GCM", "NoPadding");
        String encryptedData = sm4.encryptBase64(srcData, otp, iv);
        SM2 sm2 = new SM2();
        String cipherOtp = sm2.encrypt(otp, appConfig.getKdPublicKey());
        return new String[]{iv + "$" + encryptedData, cipherOtp};
    }

    @Override
    public String decrypt(String encryptData, AppConfig appConfig, String envelopKey) throws Exception {
        SM2 sm2 = new SM2();
        String otp = sm2.decrypt(envelopKey, appConfig.getAppPrivateKey());
        int idxOfIv = encryptData.indexOf("$");
        String iv = encryptData.substring(0, idxOfIv);
        String bizEncryptData = encryptData.substring(idxOfIv + 1);
        SM4 sm4 = new SM4("GCM", "NoPadding");
        return sm4.decryptStr(bizEncryptData, otp, iv);
    }

    @Override
    public String sign(String strToSign, AppConfig appConfig) throws Exception {
        String digestHex = new SM3().digestHex(strToSign);
        return new SM2().sign(digestHex, appConfig.getAppPrivateKey());
    }

    @Override
    public boolean verify(String strToSign, String sign, AppConfig appConfig) throws Exception {
        String digestHex = new SM3().digestHex(strToSign);
        return new SM2().verify(digestHex, sign, appConfig.getKdPublicKey());
    }
}

