/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.fintech.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import java.io.IOException;
import java.util.Date;
import org.apache.http.client.utils.DateUtils;

public class JacksonUtils {
    private static final ObjectMapper OBJECT_MAPPER = JacksonUtils.initObjectMapper(new ObjectMapper());

    public static String toJson(Object object) {
        if (JacksonUtils.isCharSequence(object).booleanValue()) {
            return (String)object;
        }
        try {
            return JacksonUtils.getObjectMapper().writeValueAsString(object);
        }
        catch (JsonProcessingException var2) {
            throw new RuntimeException(var2);
        }
    }

    public static <T> T readValue(String json, Class<T> clazz) throws JsonProcessingException {
        return (T)JacksonUtils.getObjectMapper().readValue(json, clazz);
    }

    public static <T> T readValue(String json, TypeReference<T> valueTypeRef) throws JsonProcessingException {
        return (T)JacksonUtils.getObjectMapper().readValue(json, valueTypeRef);
    }

    public static ObjectMapper getObjectMapper() {
        return OBJECT_MAPPER;
    }

    public static ObjectMapper initObjectMapper(ObjectMapper objectMapper) {
        if (objectMapper == null) {
            objectMapper = new ObjectMapper();
        }
        return JacksonUtils.doInitObjectMapper(objectMapper);
    }

    private static ObjectMapper doInitObjectMapper(ObjectMapper objectMapper) {
        objectMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        objectMapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        objectMapper.configure(JsonParser.Feature.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER, true);
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(MapperFeature.PROPAGATE_TRANSIENT_MARKER, true);
        return JacksonUtils.registerModule(objectMapper);
    }

    private static ObjectMapper registerModule(ObjectMapper objectMapper) {
        SimpleModule simpleModule = new SimpleModule();
        simpleModule.addDeserializer(Date.class, (JsonDeserializer)new JsonDeserializer<Date>(){

            public Date deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
                String[] dateFormatArray = new String[]{"yyyy-MM-dd", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'"};
                return DateUtils.parseDate((String)jsonParser.getText(), (String[])dateFormatArray);
            }
        });
        simpleModule.addSerializer(Long.class, (JsonSerializer)ToStringSerializer.instance);
        objectMapper.registerModule((Module)simpleModule);
        return objectMapper;
    }

    public static Boolean isCharSequence(Object object) {
        return object != null && object.getClass() != null ? CharSequence.class.isAssignableFrom(object.getClass()) : Boolean.FALSE.booleanValue();
    }

    public static Object parse(String json) {
        Object object = null;
        try {
            object = JacksonUtils.getObjectMapper().readValue(json, Object.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return object;
    }
}

