/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.fintech.util;

import com.kingdee.fintech.client.DefaultKdClient;
import com.kingdee.fintech.client.DefaultKdNapiClient;
import com.kingdee.fintech.support.app.AppConfig;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class KdSdkConfig {
    public static String DEFAULT_CONFIG_FILE = "kdft_sdk_config.properties";

    public static DefaultKdClient getDefaultClient() throws Exception {
        return new DefaultKdClient(KdSdkConfig.getDefaultAppConfig());
    }

    public static DefaultKdNapiClient getDefaultNapiClient() throws Exception {
        return new DefaultKdNapiClient(KdSdkConfig.getDefaultAppConfig());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AppConfig getDefaultAppConfig() throws Exception {
        InputStream inputStream = KdSdkConfig.class.getClassLoader().getResourceAsStream(DEFAULT_CONFIG_FILE);
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
            AppConfig appConfig = new AppConfig();
            appConfig.setAppId(properties.getProperty("kingdee.fintech.appId"));
            appConfig.setKdPublicKey(properties.getProperty("kingdee.fintech.kdPublicKey"));
            appConfig.setAppPublicKey(properties.getProperty("kingdee.fintech.appPublicKey"));
            appConfig.setAppPrivateKey(properties.getProperty("kingdee.fintech.appPrivateKey"));
            appConfig.setAppPassword(properties.getProperty("kingdee.fintech.appPassword"));
            appConfig.setVersion(properties.getProperty("kingdee.fintech.version"));
            appConfig.setDomain(properties.getProperty("kingdee.fintech.domain"));
            AppConfig appConfig2 = appConfig;
            return appConfig2;
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException var10) {
                var10.printStackTrace();
            }
        }
    }
}

