/*
 * Decompiled with CFR 0.152.
 */
package com.zstax.sqzl.sdk;

import com.zstax.sqzl.sdk.SQZL;
import com.zstax.sqzl.sdk.common.APIDescriptor;
import com.zstax.sqzl.sdk.common.SQZLConstant;
import com.zstax.sqzl.sdk.common.SQZLOperation;
import com.zstax.sqzl.sdk.model.BaseReqParam;
import com.zstax.sqzl.sdk.model.BaseSBReqParam;
import com.zstax.sqzl.sdk.model.shenbao.CxsTY;
import com.zstax.sqzl.sdk.model.shenbao.CxsTYRtn;
import com.zstax.sqzl.sdk.model.shenbao.YhsCJ;
import com.zstax.sqzl.sdk.model.shenbao.YhsCJRtn;
import com.zstax.sqzl.sdk.model.shenbao.YhsCJRtn_GZ;
import com.zstax.sqzl.sdk.model.shenbao.YhsCJRtn_ZF;
import com.zstax.sqzl.sdk.model.shenbao.YhsCJ_GZ;
import com.zstax.sqzl.sdk.model.shenbao.YhsCJ_ZF;
import com.zstax.sqzl.sdk.model.shenbao.yhs.YhscjCjxxb;
import com.zstax.sqzl.sdk.util.StrUtil;
import java.util.ArrayList;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SQZLClient
implements SQZL {
    Log log = LogFactory.getLog(SQZLClient.class);
    public final int secretKeyLen = 32;
    protected String appId;
    protected String appKey;
    protected String secretKey;
    protected BaseReqParam baseReqParam;
    protected SQZLOperation operation;

    public SQZLClient(BaseReqParam baseReqParam) {
        this(SQZLConstant.APP_ID, SQZLConstant.APP_KEY, baseReqParam);
    }

    public SQZLClient(String appId, String appKey, BaseReqParam baseReqParam) {
        this(appId, appKey, baseReqParam, (String)null);
    }

    public SQZLClient(String appId, String appKey, BaseReqParam baseReqParam, String secretKey) {
        this(appId, appKey, secretKey, baseReqParam, null);
    }

    public SQZLClient(String appId, String appKey, BaseReqParam baseReqParam, SQZLOperation operation) {
        this(appId, appKey, null, baseReqParam, operation);
    }

    public SQZLClient(String appId, String appKey, String secretKey, BaseReqParam baseReqParam, SQZLOperation operation) {
        if (StrUtil.isEmpty(appId) || StrUtil.isEmpty(appKey)) {
            throw new RuntimeException("\u65e0\u6548\u7684\u5e94\u7528id\uff08appId\uff09\u6216\u5e94\u7528key\uff08appKey\uff09");
        }
        this.appId = appId;
        this.appKey = appKey;
        this.secretKey = this.buildSecretKey(secretKey);
        this.baseReqParam = baseReqParam;
        this.operation = operation = Optional.ofNullable(operation).orElse(new SQZLOperation(appId, appKey, this.secretKey));
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    @Override
    public YhsCJRtn shenbaoYhsCJ(YhsCJ yhsCJ) {
        return (YhsCJRtn)this.operation.operation(this.buildReqParam(yhsCJ), APIDescriptor.SB_JY_YHS_CJ);
    }

    @Override
    public YhsCJRtn_GZ shenbaoYhsCJGZ(YhsCJ_GZ yhsCJ_gz) {
        return (YhsCJRtn_GZ)this.operation.operation(this.buildReqParam(yhsCJ_gz), APIDescriptor.SB_JY_YHS_CJ_GZ);
    }

    @Override
    public YhsCJRtn_ZF shenbaoYhsCJZF(YhsCJ_ZF yhsCJ_zf) {
        return (YhsCJRtn_ZF)this.operation.operation(this.buildReqParam(yhsCJ_zf), APIDescriptor.SB_JY_YHS_CJ_ZF);
    }

    @Override
    public CxsTYRtn shenbaoCxsTY(CxsTY cxsTY) {
        return (CxsTYRtn)this.operation.operation(this.buildReqParam(cxsTY), APIDescriptor.SB_JY_CXS_TY);
    }

    @Override
    public CxsTYRtn shenbaoCxsTYGZ(CxsTY cxsTY) {
        return (CxsTYRtn)this.operation.operation(this.buildReqParam(cxsTY), APIDescriptor.SB_JY_CXS_TY_GZ);
    }

    private String buildSecretKey(String secretKey) {
        if (StrUtil.isNotEmpty(secretKey)) {
            if (secretKey.length() != 32) {
                this.log.error((Object)"\u3010\u65e0\u6548\u5bc6\u94a5\u3011\u5bc6\u94a5\u957f\u5ea6\u5fc5\u987b\u4e3a:32");
                throw new RuntimeException("\u65e0\u6548\u5bc6\u94a5");
            }
        } else {
            secretKey = UUID.randomUUID().toString().replace("-", "");
        }
        return secretKey;
    }

    private BaseReqParam buildReqParam(Object data) {
        if (data != null) {
            this.baseReqParam.setTaxData(data);
        }
        return this.baseReqParam;
    }

    public static void main(String[] args) {
        BaseSBReqParam sbReqParam = new BaseSBReqParam();
        sbReqParam.setNsrmc("\u7533\u62a5\u4f01\u4e1a\u7684\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7");
        sbReqParam.setNsrsbh("\u7533\u62a5\u4f01\u4e1a\u7684\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7");
        sbReqParam.setSkssqq("skssqq");
        sbReqParam.setSkssqz("skssqz");
        SQZLClient client = new SQZLClient(sbReqParam);
        ArrayList<YhscjCjxxb> cjxxbList = new ArrayList<YhscjCjxxb>();
        YhscjCjxxb cjxxb1 = new YhscjCjxxb();
        cjxxb1.setHdbl("hdbl");
        cjxxb1.setJmse("jmse");
        YhscjCjxxb cjxxb2 = new YhscjCjxxb();
        cjxxb2.setJsjehjs("jsjehjs");
        cjxxb2.setNsqxDm("nsqxDm");
        cjxxb2.setYjse("Yjse");
        cjxxbList.add(cjxxb1);
        cjxxbList.add(cjxxb2);
        YhsCJ yhsCJ = new YhsCJ();
        yhsCJ.setCjxxGrid(cjxxbList);
        YhsCJRtn rtn = client.shenbaoYhsCJ(yhsCJ);
        System.out.println(rtn);
    }
}

