/*
 * Decompiled with CFR 0.152.
 */
package com.zstax.sqzl.sdk.common;

import com.alibaba.fastjson.JSON;
import com.zstax.sqzl.sdk.common.APIDescriptor;
import com.zstax.sqzl.sdk.common.SQZLConstant;
import com.zstax.sqzl.sdk.model.BaseReqParam;
import com.zstax.sqzl.sdk.model.DZSJReqParam;
import com.zstax.sqzl.sdk.model.DZSJResParam;
import com.zstax.sqzl.sdk.util.Base64Util;
import com.zstax.sqzl.sdk.util.CertUtil;
import com.zstax.sqzl.sdk.util.HttpUtil;
import com.zstax.sqzl.sdk.util.StrUtil;
import com.zstax.sqzl.sdk.util.sm2.SM2Util;
import com.zstax.sqzl.sdk.util.sm3.SM3Util;
import com.zstax.sqzl.sdk.util.sm4.SM4Util;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.math.ec.ECPoint;

public class SQZLOperation {
    Log log = LogFactory.getLog(SQZLOperation.class);
    protected String appId;
    protected String appKey;
    protected String secretKey;
    protected String uniqueKey;

    public SQZLOperation(String appId, String appKey, String secretKey) {
        this.appId = appId;
        this.appKey = appKey;
        this.secretKey = secretKey;
        this.uniqueKey = UUID.randomUUID().toString().replace("-", "");
    }

    public Object operation(BaseReqParam data, APIDescriptor descriptor) {
        DZSJReqParam req = this.buildReqParam(data);
        this.log.info((Object)("\u3010\u8bf7\u6c42\u6570\u636e\u3011" + JSON.toJSONString((Object)req)));
        String result = this.sendReq(req, descriptor);
        this.log.info((Object)("\u3010\u8fd4\u56de\u7ed3\u679c\u3011" + result));
        if (StrUtil.isNotEmpty(result)) {
            DZSJResParam res = (DZSJResParam)JSON.parseObject((String)result, DZSJResParam.class);
            if ("200".equals(res.getCode())) {
                if (this.getUniqueKey().equals(res.getUniqueKey())) {
                    try {
                        String decryptData = SM4Util.decryptData(res.getData().toString(), this.secretKey);
                        return JSON.parseObject((String)decryptData, descriptor.rtnCls);
                    }
                    catch (Exception e) {
                        this.log.error((Object)"\u3010\u89e3\u5bc6\u3011\u89e3\u5bc6\u8fd4\u56de\u7ed3\u679c\u51fa\u9519");
                        e.printStackTrace();
                    }
                } else {
                    this.log.error((Object)("\u3010\u8fd4\u56de\u7ed3\u679c\u3011\u6807\u8bc6\u7b26\u65e0\u6548\uff08\u5f53\u524d\uff1a" + this.getUniqueKey() + "\u8fd4\u56de\uff1a" + res.getUniqueKey() + "\uff09"));
                }
            } else {
                this.log.error((Object)("\u3010\u8fd4\u56de\u7ed3\u679c\u3011\u8bf7\u6c42\u5931\u8d25:" + res.getMsg() + "(" + res.getCode() + ")"));
            }
        } else {
            this.log.error((Object)"\u3010\u8fd4\u56de\u7ed3\u679c\u3011\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
        }
        throw new RuntimeException("\u8fd4\u56de\u7ed3\u679c\u5904\u7406\u5f02\u5e38");
    }

    protected String sendReq(DZSJReqParam req, APIDescriptor descriptor) {
        String result;
        Map reqParamMap = (Map)JSON.parseObject((String)JSON.toJSONString((Object)req), Map.class);
        String url = SQZLConstant.DZSJ_REQ_PATH + descriptor.url;
        if (StrUtil.isEmpty(url)) {
            this.log.error((Object)"\u5f53\u524d\u63a5\u53e3\u5c1a\u672a\u5f00\u653e\uff0c\u656c\u8bf7\u671f\u5f85\uff01");
            return null;
        }
        switch (descriptor.hm) {
            case GET: {
                result = HttpUtil.sendGet(url, reqParamMap);
                break;
            }
            case POST: {
                result = HttpUtil.sendPost(url, reqParamMap);
                break;
            }
            default: {
                this.log.error((Object)"\u3010\u8bf7\u6c42\u65b9\u5f0f\u3011\u4e0d\u652f\u6301\u7684\u8bf7\u6c42\u65b9\u5f0f\uff08\u76ee\u524d\u53ea\u652f\u6301GET\u6216\u8005POST\uff09");
                throw new RuntimeException("\u8bf7\u6c42\u65b9\u5f0f\u5f02\u5e38");
            }
        }
        return result;
    }

    protected DZSJReqParam buildReqParam(BaseReqParam data) {
        DZSJReqParam req = new DZSJReqParam();
        req.setData(this.encryptData(data));
        req.setAppId(this.appId);
        req.setUniqueKey(this.uniqueKey);
        req.setSecretKey(this.encryptSecretKey());
        req.setTime(LocalDateTime.now().toEpochSecond(ZoneOffset.of("+8")));
        req.setToken(this.buildSign(req));
        return req;
    }

    public String getUniqueKey() {
        return this.uniqueKey;
    }

    protected final String buildSign(DZSJReqParam req) {
        String sb = this.appKey + req.getTime() + req.getUniqueKey() + req.getData();
        return SM3Util.encrypt(sb);
    }

    protected final String encryptSecretKey() {
        SM2Util sm2 = new SM2Util();
        ECPoint ecPoint = sm2.importPublicKey(CertUtil.getPublicKey());
        byte[] encrypt = sm2.encrypt(this.secretKey, ecPoint);
        return Base64Util.encodeToString(encrypt);
    }

    protected final String encryptData(Object data) {
        String encryptData;
        String dataStr = JSON.toJSONString((Object)data);
        try {
            encryptData = SM4Util.encryptData(dataStr, this.secretKey);
        }
        catch (Exception e) {
            this.log.error((Object)"\u3010\u52a0\u5bc6\u5f02\u5e38\u3011\u6570\u636e\u52a0\u5bc6\uff08SM4\uff09\u9519\u8bef");
            throw new RuntimeException("\u52a0\u5bc6\u5f02\u5e38:" + e.getMessage());
        }
        return encryptData;
    }
}

