/*
 * Decompiled with CFR 0.152.
 */
package com.zstax.sqzl.sdk.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class CertUtil {
    private static final String PUBLIC_CERT_PATH = "cert/publicKey.pem";

    public static InputStream getPublicKey() {
        return CertUtil.getCertInputStream(PUBLIC_CERT_PATH);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] getCertByte(String path) {
        InputStream is = CertUtil.getCertInputStream(path);
        try {
            byte[] byArray = CertUtil.inputStream2Bytes(is);
            return byArray;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private static InputStream getCertInputStream(String path) {
        return CertUtil.class.getClassLoader().getResourceAsStream(path);
    }

    private static byte[] inputStream2Bytes(InputStream is) throws IOException {
        int ch;
        ByteArrayOutputStream bytestream = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((ch = is.read(buffer)) != -1) {
            bytestream.write(buffer, 0, ch);
        }
        byte[] data = bytestream.toByteArray();
        bytestream.close();
        return data;
    }
}

