/*
 * Decompiled with CFR 0.152.
 */
package com.zstax.sqzl.sdk.util;

import com.alibaba.fastjson.JSON;
import com.zstax.sqzl.sdk.common.HttpMethod;
import com.zstax.sqzl.sdk.util.StrUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.net.ssl.SSLContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.util.EntityUtils;

public class HttpUtil {
    private static final Log log = LogFactory.getLog(HttpUtil.class);

    public static String sendGet(String url) {
        return HttpUtil.sendGet(url, null);
    }

    public static String sendGet(String url, Map<String, Object> paramMap) {
        Map<String, String> headerMap = HttpUtil.buildDefaultHeader(null);
        return HttpUtil.sendGet(url, paramMap, headerMap);
    }

    public static String sendGet(String url, Map<String, Object> paramMap, Map<String, String> headerMap) {
        return HttpUtil.sendRequest(url, paramMap, headerMap, HttpMethod.GET);
    }

    public static String sendPost(String url, Map<String, Object> paramMap) {
        Map<String, String> headerMap = HttpUtil.buildDefaultHeader(null);
        return HttpUtil.sendPost(url, paramMap, headerMap);
    }

    public static String sendPost(String url, String paramsJson) {
        Map<String, String> headerMap = HttpUtil.buildDefaultHeader(null);
        Map paramMap = (Map)JSON.parseObject((String)paramsJson, Map.class);
        return HttpUtil.sendPost(url, paramMap, headerMap);
    }

    public static String sendPost(String url, Map<String, Object> paramMap, Map<String, String> headerMap) {
        return HttpUtil.sendRequest(url, paramMap, headerMap, HttpMethod.POST);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String sendRequest(String url, Map<String, Object> paramMap, Map<String, String> headerMap, HttpMethod way) {
        HttpRequestBase httpRequest = HttpUtil.buildRequest(url, paramMap, way);
        if (headerMap != null && headerMap.size() > 0) {
            headerMap.forEach((arg_0, arg_1) -> ((HttpRequestBase)httpRequest).setHeader(arg_0, arg_1));
        }
        try (CloseableHttpClient httpClient = url.startsWith("https") ? HttpUtil.createSSLClientDefault() : HttpClients.createDefault();
             CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpRequest);){
            if (response == null) return null;
            if (response.getStatusLine().getStatusCode() != 200) return null;
            HttpEntity entity = response.getEntity();
            String string = EntityUtils.toString((HttpEntity)entity);
            return string;
        }
        catch (IOException e) {
            log.error((Object)("\u8bf7\u6c42\uff1a" + url + "\uff08" + (Object)((Object)way) + "\uff09\u53d1\u9001\u5931\u8d25\uff01"));
            e.printStackTrace();
        }
        return null;
    }

    private static HttpRequestBase buildRequest(String url, Map<String, Object> paramMap, HttpMethod way) {
        HttpPost httpRequest;
        switch (way) {
            case GET: {
                String param = HttpUtil.buildGetParam(paramMap);
                if (StrUtil.isNotEmpty(param)) {
                    url = url + "?" + param;
                }
                httpRequest = new HttpGet(url);
                break;
            }
            case POST: {
                httpRequest = new HttpPost(url);
                StringEntity entity = HttpUtil.buildPostParam(paramMap);
                if (entity == null) break;
                httpRequest.setEntity((HttpEntity)entity);
                break;
            }
            default: {
                throw new RuntimeException("\u76ee\u524d\u53ea\u652f\u6301GET\u6216\u8005POST\u8bf7\u6c42\u65b9\u5f0f\uff01");
            }
        }
        return httpRequest;
    }

    private static CloseableHttpClient createSSLClientDefault() {
        try {
            SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, (org.apache.http.ssl.TrustStrategy)((TrustStrategy)(chain, authType) -> true)).build();
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext);
            return HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            e.printStackTrace();
            return HttpClients.createDefault();
        }
    }

    private static String buildGetParam(Map<String, Object> paramMap) {
        StringBuffer content = new StringBuffer("");
        if (paramMap != null && paramMap.size() > 0) {
            for (String key : paramMap.keySet()) {
                try {
                    if (paramMap.get(key) == null) continue;
                    content.append("&" + key + "=" + URLEncoder.encode(paramMap.get(key).toString(), "utf-8"));
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
        }
        if (StrUtil.isNotEmpty(content)) {
            content.deleteCharAt(0);
        }
        return content.toString();
    }

    private static StringEntity buildPostParam(Map<String, Object> paramMap) {
        if (paramMap != null && paramMap.size() > 0) {
            return new StringEntity(JSON.toJSONString(paramMap), StandardCharsets.UTF_8);
        }
        return null;
    }

    private static Map<String, String> buildDefaultHeader(String contentType) {
        contentType = Optional.ofNullable(contentType).orElse("application/json;charset=UTF-8");
        HashMap<String, String> headerMap = new HashMap<String, String>(2);
        headerMap.put("Content-Type", contentType);
        return headerMap;
    }
}

