/*
 * Decompiled with CFR 0.152.
 */
package com.zstax.sqzl.sdk.util.sm2;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Arrays;
import org.bouncycastle.crypto.DerivationParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.ExtendedDigest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.digests.ShortenedDigest;
import org.bouncycastle.crypto.generators.KDF1BytesGenerator;
import org.bouncycastle.crypto.params.ISO18033KDFParameters;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;

public class SM2Util {
    public static final BigInteger p = new BigInteger("FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFF", 16);
    public static final BigInteger a = new BigInteger("FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFC", 16);
    public static final BigInteger b = new BigInteger("28E9FA9E9D9F5E344D5A9E4BCF6509A7F39789F515AB8F92DDBCBD414D940E93", 16);
    public static final BigInteger xg = new BigInteger("32C4AE2C1F1981195F9904466A39C9948FE30BBFF2660BE1715A4589334C74C7", 16);
    public static final BigInteger yg = new BigInteger("BC3736A2F4F6779C59BDCEE36B692153D0A9877CC62A474002DF32E52139F0A0", 16);
    public static final BigInteger n = new BigInteger("FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFF7203DF6B21C6052B53BBF40939D54123", 16);
    private static SecureRandom random = new SecureRandom();
    private ECCurve.Fp curve = new ECCurve.Fp(p, a, b);
    private ECPoint G = this.curve.createPoint(xg, yg);

    public BigInteger random(BigInteger max) {
        BigInteger r = new BigInteger(256, random);
        while (r.compareTo(max) >= 0) {
            r = new BigInteger(128, random);
        }
        return r;
    }

    private boolean allZero(byte[] buffer) {
        for (int i = 0; i < buffer.length; ++i) {
            if (buffer[i] == 0) continue;
            return false;
        }
        return true;
    }

    public byte[] encrypt(String input, ECPoint publicKey) {
        byte[] inputBuffer = input.getBytes();
        BigInteger k = this.random(n);
        ECPoint C1 = this.G.multiply(k);
        byte[] C1Buffer = C1.getEncoded(false);
        ECPoint kpb = publicKey.multiply(k).normalize();
        byte[] kpbBytes = kpb.getEncoded(false);
        KDF1BytesGenerator kdf = new KDF1BytesGenerator((Digest)new ShortenedDigest((ExtendedDigest)new SHA256Digest(), 20));
        byte[] t = new byte[inputBuffer.length];
        kdf.init((DerivationParameters)new ISO18033KDFParameters(kpbBytes));
        kdf.generateBytes(t, 0, t.length);
        if (this.allZero(t)) {
            System.err.println("all zero");
        }
        byte[] C2 = new byte[inputBuffer.length];
        for (int i = 0; i < inputBuffer.length; ++i) {
            C2[i] = (byte)(inputBuffer[i] ^ t[i]);
        }
        byte[] C3 = this.calculateHash(kpb.getXCoord().toBigInteger(), inputBuffer, kpb.getYCoord().toBigInteger());
        byte[] encryptResult = new byte[C1Buffer.length + C2.length + C3.length];
        System.arraycopy(C1Buffer, 0, encryptResult, 0, C1Buffer.length);
        System.arraycopy(C2, 0, encryptResult, C1Buffer.length, C2.length);
        System.arraycopy(C3, 0, encryptResult, C1Buffer.length + C2.length, C3.length);
        return encryptResult;
    }

    public String decrypt(byte[] encryptData, BigInteger privateKey) {
        byte[] C1Byte = new byte[65];
        System.arraycopy(encryptData, 0, C1Byte, 0, C1Byte.length);
        ECPoint C1 = this.curve.decodePoint(C1Byte).normalize();
        ECPoint dBC1 = C1.multiply(privateKey).normalize();
        byte[] dBC1Bytes = dBC1.getEncoded(false);
        KDF1BytesGenerator kdf = new KDF1BytesGenerator((Digest)new ShortenedDigest((ExtendedDigest)new SHA256Digest(), 20));
        int klen = encryptData.length - 65 - 20;
        System.out.println("klen = " + klen);
        byte[] t = new byte[klen];
        kdf.init((DerivationParameters)new ISO18033KDFParameters(dBC1Bytes));
        kdf.generateBytes(t, 0, t.length);
        if (this.allZero(t)) {
            System.err.println("all zero");
        }
        byte[] M = new byte[klen];
        for (int i = 0; i < M.length; ++i) {
            M[i] = (byte)(encryptData[C1Byte.length + i] ^ t[i]);
        }
        byte[] C3 = new byte[20];
        System.arraycopy(encryptData, encryptData.length - 20, C3, 0, 20);
        byte[] u = this.calculateHash(dBC1.getXCoord().toBigInteger(), M, dBC1.getYCoord().toBigInteger());
        if (Arrays.equals(u, C3)) {
            System.out.println("\u89e3\u5bc6\u6210\u529f");
            return new String(M);
        }
        System.err.println("\u89e3\u5bc6\u9a8c\u8bc1\u5931\u8d25");
        return null;
    }

    private byte[] calculateHash(BigInteger x2, byte[] M, BigInteger y2) {
        ShortenedDigest digest = new ShortenedDigest((ExtendedDigest)new SHA256Digest(), 20);
        byte[] buf = x2.toByteArray();
        digest.update(buf, 0, buf.length);
        digest.update(M, 0, M.length);
        buf = y2.toByteArray();
        digest.update(buf, 0, buf.length);
        buf = new byte[20];
        digest.doFinal(buf, 0);
        return buf;
    }

    private boolean between(BigInteger param, BigInteger min, BigInteger max) {
        return param.compareTo(min) >= 0 && param.compareTo(max) < 0;
    }

    public ECPoint importPublicKey(InputStream is) {
        try {
            int size;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[16];
            while ((size = is.read(buffer)) != -1) {
                baos.write(buffer, 0, size);
            }
            return this.curve.decodePoint(baos.toByteArray());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) {
        SM2Util sm2Util = new SM2Util();
        BigInteger d = sm2Util.random(n.subtract(new BigInteger("1")));
        System.out.println(d);
    }
}

