/*
 * Decompiled with CFR 0.152.
 */
package com.zstax.sqzl.sdk.util.sm4;

import com.zstax.sqzl.sdk.util.Base64Util;
import com.zstax.sqzl.sdk.util.sm4.SM4;
import com.zstax.sqzl.sdk.util.sm4.SM4_Context;
import java.nio.charset.StandardCharsets;

public class SM4Util {
    public static String encryptData(String plainText, String secretKey) throws Exception {
        return Base64Util.encodeToString(SM4Util.encryptData_ECB(plainText.getBytes(StandardCharsets.UTF_8), secretKey));
    }

    public static String decryptData(String cipherText, String secretKey) throws Exception {
        return new String(SM4Util.decryptData_ECB(Base64Util.decode(cipherText.getBytes(StandardCharsets.UTF_8)), secretKey), StandardCharsets.UTF_8);
    }

    public static byte[] encryptData_ECB(byte[] plainContent, String secretKey) throws Exception {
        byte[] keyBytes = secretKey.getBytes("utf-8");
        return SM4Util.encryptData_ECB(plainContent, keyBytes);
    }

    public static byte[] encryptData_ECB(byte[] plainContent, byte[] keyBytes) throws Exception {
        SM4_Context ctx = new SM4_Context();
        ctx.isPadding = true;
        ctx.mode = 1;
        SM4 sm4 = new SM4();
        sm4.sm4_setkey_enc(ctx, keyBytes);
        byte[] encrypted = sm4.sm4_crypt_ecb(ctx, plainContent);
        return encrypted;
    }

    public static byte[] decryptData_ECB(byte[] cipherContent, String secretKey) throws Exception {
        byte[] keyBytes = secretKey.getBytes("utf-8");
        return SM4Util.decryptData_ECB(cipherContent, keyBytes);
    }

    public static byte[] decryptData_ECB(byte[] cipherContent, byte[] keyBytes) throws Exception {
        SM4_Context ctx = new SM4_Context();
        ctx.isPadding = true;
        ctx.mode = 0;
        SM4 sm4 = new SM4();
        sm4.sm4_setkey_dec(ctx, keyBytes);
        byte[] decrypted = sm4.sm4_crypt_ecb(ctx, cipherContent);
        return decrypted;
    }
}

