/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.aicc.core;

import com.google.common.hash.Hashing;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.ai.aicc.core.Utils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class AWSV4Utils {
    private static final Log logger = LogFactory.getLog(AWSV4Utils.class);
    private static final String SERVICE = "bedrock";
    private static final Pattern ENCODED_CHARACTERS_PATTERN;

    public static Map<String, String> authHeader(String url, String ak, String sk, String payload) {
        String regex = "https?://([a-z0-9.-]+)\\.([a-z0-9-]+-[a-z0-9]+)\\.amazonaws\\.com:[0-9]+?(/[^\\s]+)";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(url);
        if (!matcher.find()) {
            logger.info("aws\u5730\u5740\u6b63\u5219\u5339\u914d\u9519\u8bef:{}", (Object)url);
            throw new KDBizException("aws\u5730\u5740\u6b63\u5219\u5339\u914d\u9519\u8bef");
        }
        String region = matcher.group(2);
        String host = String.format("%s.%s.amazonaws.com", matcher.group(1), region);
        String uri = matcher.group(3);
        String canonicalUri = AWSV4Utils.urlEncode(uri, true);
        logger.info("(url:{})aws\u5730\u5740\u6b63\u5219\u5339\u914d\u63d0\u53d6\uff1aregion:{} , host:{},uri:{}", new Object[]{url, region, host, uri});
        Date currentDate = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
        String dateString = dateFormat.format(currentDate);
        String awsDate = AWSV4Utils.getAwsDate(currentDate);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("Host", host);
        headers.put("X-Amz-Content-Sha256", Hashing.sha256().hashString((CharSequence)payload, StandardCharsets.UTF_8).toString());
        headers.put("X-Amz-Date", awsDate);
        TreeMap<String, String> sortedMap = new TreeMap<String, String>(headers);
        String signedHeadersString = sortedMap.keySet().stream().map(String::toLowerCase).sorted().collect(Collectors.joining(";"));
        String canonicalRequest = AWSV4Utils.buildCanonicalRequest("POST", canonicalUri, "", sortedMap, signedHeadersString, payload);
        String algorithm = "AWS4-HMAC-SHA256";
        String credentialScope = dateString + '/' + region + '/' + SERVICE + "/aws4_request";
        String string2Sign = algorithm + '\n' + awsDate + '\n' + credentialScope + '\n' + Hashing.sha256().hashString((CharSequence)canonicalRequest, StandardCharsets.UTF_8);
        String signature = AWSV4Utils.calculateSignature(string2Sign, sk, dateString, region, SERVICE);
        sortedMap.put("Authorization", "AWS4-HMAC-SHA256 Credential=" + ak + "/" + credentialScope + ", SignedHeaders=" + signedHeadersString + ", Signature=" + signature);
        return sortedMap;
    }

    private static String extractPart(String address, String regex) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(address);
        if (matcher.find()) {
            return matcher.group();
        }
        return "";
    }

    private static String extractURI(String address) {
        Pattern pattern = Pattern.compile("https?://[^/]+(/.*)");
        Matcher matcher = pattern.matcher(address);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return "";
    }

    private static String buildCanonicalRequest(String method, String uri, String query, Map<String, String> headers, String signedHeadersString, String payload) {
        StringBuilder canonicalHeadersBuilder = new StringBuilder();
        canonicalHeadersBuilder.append(method).append('\n');
        canonicalHeadersBuilder.append(uri).append('\n');
        canonicalHeadersBuilder.append(query).append('\n');
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            canonicalHeadersBuilder.append(entry.getKey().toLowerCase()).append(':').append(entry.getValue().trim()).append('\n');
        }
        canonicalHeadersBuilder.append('\n');
        canonicalHeadersBuilder.append(signedHeadersString).append('\n');
        canonicalHeadersBuilder.append(Hashing.sha256().hashString((CharSequence)payload, StandardCharsets.UTF_8));
        return canonicalHeadersBuilder.toString();
    }

    private static String calculateSignature(String stringToSign, String secretKey, String dateStamp, String region, String serviceName) {
        try {
            byte[] kSecret = ("AWS4" + secretKey).getBytes(StandardCharsets.UTF_8);
            byte[] kDate = Utils.hmacSHA256(dateStamp, kSecret);
            byte[] kRegion = Utils.hmacSHA256(region, kDate);
            byte[] kService = Utils.hmacSHA256(serviceName, kRegion);
            byte[] signingKey = Utils.hmacSHA256("aws4_request", kService);
            byte[] signature = Utils.hmacSHA256(stringToSign, signingKey);
            return Utils.bytesToHex(signature);
        }
        catch (Exception e) {
            logger.error("\u7b7e\u540d\u8ba1\u7b97\u51fa\u9519", (Throwable)e);
            throw new KDBizException("\u7b7e\u540d\u8ba1\u7b97\u51fa\u9519" + e.getMessage());
        }
    }

    public static String getAwsDate(Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return dateFormat.format(date);
    }

    public static String urlEncode(String value, boolean ignoreSlashes) {
        if (value == null) {
            return "";
        }
        try {
            String encoded = URLEncoder.encode(value, StandardCharsets.UTF_8.toString());
            Matcher matcher = ENCODED_CHARACTERS_PATTERN.matcher(encoded);
            StringBuffer buffer = new StringBuffer(encoded.length());
            while (matcher.find()) {
                String replacement = matcher.group(0);
                if ("+".equals(replacement)) {
                    replacement = "%20";
                } else if ("*".equals(replacement)) {
                    replacement = "%2A";
                } else if ("%7E".equals(replacement)) {
                    replacement = "~";
                } else if (ignoreSlashes && "%2F".equals(replacement)) {
                    replacement = "/";
                }
                matcher.appendReplacement(buffer, replacement);
            }
            matcher.appendTail(buffer);
            return buffer.toString();
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    static {
        StringBuilder pattern = new StringBuilder();
        pattern.append(Pattern.quote("+")).append("|").append(Pattern.quote("*")).append("|").append(Pattern.quote("%7E")).append("|").append(Pattern.quote("%2F"));
        ENCODED_CHARACTERS_PATTERN = Pattern.compile(pattern.toString());
    }
}

