/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.aicc.core;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.ai.aicc.core.BatchQueryService;
import kd.ai.aicc.core.CacheHelper;
import kd.ai.aicc.core.DeployMethod;
import kd.ai.aicc.core.TaskResult;
import kd.ai.aicc.core.dao.TaskDao;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextThreadBinder;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.util.StringUtils;

public class AsyncTaskNotifier {
    private static final Log log = LogFactory.getLog(AsyncTaskNotifier.class);
    public static final String NOTIFIER_THREAD_POOL_NAME = "ai-aicc-notify-threadpool";
    private static final ThreadPool threadPool = ThreadPools.newCachedThreadPool((String)"ai-aicc-notify-threadpool", (int)1, (int)5, (String)"aicc");

    private AsyncTaskNotifier() {
    }

    public static void setAsyncNotifyService(long taskId, Map<String, String> contextMap) {
        if (contextMap != null && StringUtils.isNotEmpty((String)contextMap.get("notify_ms_cloudid")) && StringUtils.isNotEmpty((String)contextMap.get("notify_ms_appid")) && StringUtils.isNotEmpty((String)contextMap.get("notify_ms_service_name")) && StringUtils.isNotEmpty((String)contextMap.get("notify_ms_method_name"))) {
            JSONObject serviceObj = new JSONObject();
            serviceObj.put("notify_ms_cloudid", (Object)contextMap.get("notify_ms_cloudid"));
            serviceObj.put("notify_ms_appid", (Object)contextMap.get("notify_ms_appid"));
            serviceObj.put("notify_ms_service_name", (Object)contextMap.get("notify_ms_service_name"));
            serviceObj.put("notify_ms_method_name", (Object)contextMap.get("notify_ms_method_name"));
            serviceObj.put("notify_ms_trace_id", (Object)RequestContext.get().getTraceId());
            CacheHelper.putString(AsyncTaskNotifier.buildKey(taskId), serviceObj.toJSONString());
            if (DeployMethod.PUBLIC_CLOUND_CLIENT == DeployMethod.getDeployMethod()) {
                BatchQueryService.getInstance().newAsyncTask();
            }
        }
    }

    public static void notifyTaskResult(TaskResult taskResult) {
        if (taskResult == null) {
            return;
        }
        String cacheKey = AsyncTaskNotifier.buildKey(taskResult.getId());
        String msInfoJson = CacheHelper.getString(cacheKey);
        if (StringUtils.isNotEmpty((String)msInfoJson)) {
            JSONObject mserviceInfo = JSON.parseObject((String)msInfoJson);
            ArrayList<TaskResult> data = new ArrayList<TaskResult>(1);
            data.add(taskResult);
            if (taskResult.isStream() && !"data: [DONE]".equals(taskResult.getResult())) {
                AsyncTaskNotifier.notifyResult(data, mserviceInfo);
            } else {
                CacheHelper.removeKey(cacheKey);
                threadPool.execute(() -> AsyncTaskNotifier.notifyResult(data, mserviceInfo));
            }
        }
    }

    private static String buildKey(long taskId) {
        return "task_ms_notify_" + taskId;
    }

    public static void notifyTasks(List<Long> notifyTaskList) {
        threadPool.execute((Runnable)new Notifier(notifyTaskList));
    }

    public static void notifyResult(List<TaskResult> results, JSONObject mserviceInfo) {
        String cloudId = mserviceInfo.getString("notify_ms_cloudid");
        String appId = mserviceInfo.getString("notify_ms_appid");
        String serviceName = mserviceInfo.getString("notify_ms_service_name");
        String methodName = mserviceInfo.getString("notify_ms_method_name");
        String traceId = mserviceInfo.getString("notify_ms_trace_id");
        ArrayList data = new ArrayList(results.size());
        for (TaskResult result : results) {
            HashMap<String, String> resultMap = new HashMap<String, String>();
            resultMap.put("id", String.valueOf(result.getId()));
            resultMap.put("status", result.getStatus());
            resultMap.put("result", result.getResult());
            resultMap.put("errorCode", result.getErrCode());
            resultMap.put("message", result.getErrMsg());
            resultMap.put("stream", String.valueOf(result.isStream()));
            resultMap.put("streamSeqNo", String.valueOf(result.getStreamSeqNO()));
            data.add(resultMap);
        }
        try {
            if (StringUtils.isNotEmpty((String)traceId)) {
                RequestContext rc = RequestContext.get();
                rc.setTraceId(traceId);
                RequestContextThreadBinder.bind((RequestContext)rc);
            }
            DispatchServiceHelper.invokeBizService((String)cloudId, (String)appId, (String)serviceName, (String)methodName, (Object[])new Object[]{data});
        }
        catch (Exception t) {
            log.error(t.getMessage(), (Throwable)t);
        }
    }

    public static class Notifier
    implements Runnable {
        private final List<Long> taskList;

        public Notifier(List<Long> taskList) {
            this.taskList = taskList;
        }

        @Override
        public void run() {
            HashMap<String, List> serviceDataMap = new HashMap<String, List>();
            Iterator<Object> iterator = this.taskList.iterator();
            while (iterator.hasNext()) {
                long l = iterator.next();
                String key = AsyncTaskNotifier.buildKey(l);
                String msInfo = CacheHelper.getString(key);
                if (!StringUtils.isNotEmpty((String)msInfo)) continue;
                CacheHelper.removeKey(key);
                List serviceTaskList = serviceDataMap.computeIfAbsent(msInfo, k -> new ArrayList());
                serviceTaskList.add(l);
            }
            for (Map.Entry entry : serviceDataMap.entrySet()) {
                JSONObject msObj = JSON.parseObject((String)((String)entry.getKey()));
                List taskIdList = (List)entry.getValue();
                long[] idArray = new long[taskIdList.size()];
                int i = 0;
                Iterator iterator2 = taskIdList.iterator();
                while (iterator2.hasNext()) {
                    long id = (Long)iterator2.next();
                    idArray[i++] = id;
                }
                List<TaskResult> results = TaskDao.queryTaskResult(idArray);
                AsyncTaskNotifier.notifyResult(results, msObj);
            }
        }
    }
}

