/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.aicc.core;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.util.HashMap;
import kd.ai.aicc.core.CacheHelper;
import kd.ai.aicc.core.Constant;
import kd.ai.aicc.core.DistributeLocker;
import kd.ai.aicc.core.Utils;
import kd.ai.aicc.core.domain.Instance;
import kd.ai.aicc.core.domain.Task;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.encrypt.Encrypters;
import kd.bos.exception.KDBizException;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;

public class Authorization {
    public static final String BAIDU_TOKEN_URL = "https://aip.baidubce.com/oauth/2.0/token?grant_type=client_credentials";
    public static final String XMINDAI_TOKEN_URL = "https://login.xmindai.cn/api/Common/Verification";

    private Authorization() {
    }

    public static String auth(HttpPost request, Instance instance, Task task, String requestBody) {
        switch (instance.getAuthType()) {
            case API2SIGN: {
                Utils.openApiSign((HttpUriRequest)request, "", instance.getSecretKey(), instance.getProxyUserSecretKey());
                break;
            }
            case OAUTHTOKEN: {
                Utils.oAuth2Token((HttpUriRequest)request, instance.getSecretKey());
                String model = instance.getClientId();
                if (!StringUtils.isNotEmpty((CharSequence)model)) break;
                JSONObject requestJSON = JSON.parseObject((String)requestBody);
                requestJSON.put("model", (Object)model);
                requestBody = requestJSON.toJSONString();
                break;
            }
            case APIKEY: {
                Utils.azureApiKeyToken((HttpUriRequest)request, instance.getSecretKey());
                break;
            }
            case XMINDAI: {
                String apiKey = Authorization.getXmindAIToken(instance, 0);
                Utils.oAuth2Token((HttpUriRequest)request, apiKey);
                break;
            }
            case BAIDU: {
                String accessToken = Authorization.getBaiduAccessToken(instance, 0);
                String url = instance.getUrl();
                url = url.contains("?") ? url + "&access_token=" + accessToken : url + "?access_token=" + accessToken;
                request.setURI(URI.create(url));
                break;
            }
            case AWS_SIGN_V4: {
                Utils.awsSignV4(request, instance, task, requestBody);
                break;
            }
            case TENCENT_HUNYUAN_V1: {
                return Utils.tencentAuthV1((HttpUriRequest)request, instance.getProxyUserSecretKey(), instance.getClientId(), instance.getSecretKey(), requestBody);
            }
            case TENCENT_HUNYUAN_PRO_V3: {
                return Utils.tencentAuthV3((HttpUriRequest)request, instance.getClientId(), instance.getSecretKey(), requestBody);
            }
        }
        return requestBody;
    }

    public static HttpPost createPost(Instance instance, Task task) {
        HttpPost httpPost = new HttpPost(instance.getUrl());
        String requestBody = task.getRequestBody();
        boolean isEncrypted = Encrypters.isEncrypted((String)requestBody);
        if (isEncrypted) {
            requestBody = Encrypters.decode((String)requestBody);
        }
        requestBody = Authorization.auth(httpPost, instance, task, requestBody);
        httpPost.setEntity((HttpEntity)new StringEntity(requestBody, ContentType.APPLICATION_JSON));
        return httpPost;
    }

    public static String getBaiduAccessToken(Instance instance, int tryCount) {
        String accessToken = CacheHelper.getString("BAIDU_ACCESS_TOKEN_" + instance.getId());
        if (accessToken != null) {
            String expireTimeStr = CacheHelper.getString("BAIDU_ACCESS_TOKEN_EXPIRE_TIME_" + instance.getId());
            long expire = Long.parseLong(expireTimeStr == null ? "0" : expireTimeStr);
            if (System.currentTimeMillis() < expire) {
                return accessToken;
            }
            CacheHelper.removeKey("BAIDU_ACCESS_TOKEN_" + instance.getId());
            CacheHelper.removeKey("BAIDU_ACCESS_TOKEN_EXPIRE_TIME_" + instance.getId());
        }
        if (tryCount > 3) {
            throw new KDBizException(Constant.GET_BAIDUTOKEN_ERROR, new Object[0]);
        }
        boolean locked = DistributeLocker.lock("BAIDU_ACCESS_TOKEN_LOCK_" + instance.getId());
        if (locked) {
            try {
                HashMap<String, String> dataMap = new HashMap<String, String>();
                dataMap.put("client_id", instance.getClientId());
                dataMap.put("client_secret", instance.getSecretKey());
                long startTime = System.currentTimeMillis();
                String result = Utils.postByUrlEncodedForm(BAIDU_TOKEN_URL, null, dataMap);
                JSONObject resultObj = JSON.parseObject((String)result);
                if (resultObj.containsKey((Object)"access_token")) {
                    accessToken = resultObj.getString("access_token");
                    long expiresIn = resultObj.getLong("expires_in");
                    long expireTime = startTime + expiresIn;
                    CacheHelper.putString("BAIDU_ACCESS_TOKEN_" + instance.getId(), accessToken);
                    CacheHelper.putString("BAIDU_ACCESS_TOKEN_EXPIRE_TIME_" + instance.getId(), String.valueOf(expireTime));
                    String string = accessToken;
                    return string;
                }
                String errMsg = resultObj.getString("error_description");
                throw new KDBizException(Constant.biaduAuthenticationError(errMsg), new Object[0]);
            }
            finally {
                DistributeLocker.releaseLock("BAIDU_ACCESS_TOKEN_LOCK_" + instance.getId());
            }
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new KDBizException(Constant.internalError(e.getMessage()), new Object[0]);
        }
        return Authorization.getBaiduAccessToken(instance, ++tryCount);
    }

    public static String getXmindAIToken(Instance instance, int tryCount) {
        String accessToken = CacheHelper.getString("XMINDAI_ACCESS_TOKEN");
        if (accessToken != null) {
            String expireTimeStr = CacheHelper.getString("XMINDAI_ACCESS_TOKEN_EXPIRE_TIME");
            long expire = Long.parseLong(expireTimeStr == null ? "0" : expireTimeStr);
            if (System.currentTimeMillis() < expire) {
                return accessToken;
            }
            CacheHelper.removeKey("XMINDAI_ACCESS_TOKEN");
            CacheHelper.removeKey("XMINDAI_ACCESS_TOKEN_EXPIRE_TIME");
        }
        if (tryCount > 3) {
            throw new KDBizException(Constant.GET_BAIDUTOKEN_ERROR, new Object[0]);
        }
        boolean locked = DistributeLocker.lock("XMINDAI_ACCESS_TOKEN_LOCK");
        if (locked) {
            try {
                long startTime = System.currentTimeMillis();
                String fullUrl = null;
                try {
                    fullUrl = "https://login.xmindai.cn/api/Common/Verification?clientId=" + instance.getClientId() + "&clientSecret=" + URLEncoder.encode(instance.getSecretKey(), "utf-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new KDBizException("url encode\u9519\u8bef");
                }
                String result = Utils.doGet(fullUrl, null);
                JSONObject resultObj = JSON.parseObject((String)result);
                if (resultObj.containsKey((Object)"access_Token")) {
                    accessToken = resultObj.getString("access_Token");
                    long expiresIn = resultObj.getLong("expires_in");
                    long expireTime = startTime + expiresIn;
                    CacheHelper.putString("XMINDAI_ACCESS_TOKEN", accessToken);
                    CacheHelper.putString("XMINDAI_ACCESS_TOKEN_EXPIRE_TIME", String.valueOf(expireTime));
                    String string = accessToken;
                    return string;
                }
                String errMsg = resultObj.getString("error_description");
                throw new KDBizException(Constant.xmindAiAuthenticationError(errMsg), new Object[0]);
            }
            finally {
                DistributeLocker.releaseLock("XMINDAI_ACCESS_TOKEN_LOCK");
            }
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new KDBizException(Constant.internalError(e.getMessage()), new Object[0]);
        }
        return Authorization.getXmindAIToken(instance, ++tryCount);
    }
}

