/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.aicc.core;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kd.ai.aicc.core.CacheHelper;
import kd.ai.aicc.core.Constant;
import kd.ai.aicc.core.dao.ServiceDao;
import kd.ai.aicc.core.dao.TenantDao;
import kd.ai.aicc.core.domain.Service;
import kd.ai.aicc.core.domain.Task;
import kd.ai.aicc.core.domain.Tenant;
import kd.bos.context.RequestContext;
import kd.bos.exception.KDBizException;
import kd.bos.util.StringUtils;

public class DataManager {
    private static DataManager dataManager = null;
    private final ConcurrentMap<String, List<Service>> allServicesMap = new ConcurrentHashMap<String, List<Service>>();
    private final ConcurrentMap<String, Long> serviceInstanceLastUpdateTimeMap = new ConcurrentHashMap<String, Long>();
    private final ConcurrentMap<String, Long> tenantLastUpdateTimeMap = new ConcurrentHashMap<String, Long>();
    private final ConcurrentMap<String, List<Tenant>> allTenantsMap = new ConcurrentHashMap<String, List<Tenant>>();
    private final ConcurrentMap<Long, RequestContext> taskRequestContextMap = new ConcurrentHashMap<Long, RequestContext>();

    private DataManager() {
    }

    public static synchronized DataManager getInstance() {
        if (dataManager == null) {
            dataManager = new DataManager();
        }
        return dataManager;
    }

    public void setTaskRequestContext(Task task) {
        this.taskRequestContextMap.put(task.getId(), RequestContext.get());
    }

    public void removeTaskRequestContext(Task task) {
        this.taskRequestContextMap.remove(task.getId());
    }

    public RequestContext getTaskRequestContext(Task task) {
        return (RequestContext)this.taskRequestContextMap.get(task.getId());
    }

    private String getServiceInstanceDataChangedKey(String accountId) {
        return String.format("%s_%s", accountId, "SVR_INST_CGD");
    }

    private String getTenantDataChangedKey(String accountId) {
        return String.format("%s_%s", accountId, "TENANT_CGD");
    }

    public void serviceInstanceDataChanged(String accountId) {
        CacheHelper.putString(this.getServiceInstanceDataChangedKey(accountId), String.valueOf(System.currentTimeMillis()));
    }

    public void serviceInstanceDataChanged() {
        CacheHelper.putString(this.getServiceInstanceDataChangedKey(RequestContext.get().getAccountId()), String.valueOf(System.currentTimeMillis()));
    }

    public void tenantDataChanged(String accountId) {
        CacheHelper.putString(this.getTenantDataChangedKey(accountId), String.valueOf(System.currentTimeMillis()));
    }

    public void tenantDataChanged() {
        CacheHelper.putString(this.getTenantDataChangedKey(RequestContext.get().getAccountId()), String.valueOf(System.currentTimeMillis()));
    }

    public synchronized boolean isServiceInstanceChanged(String accountId) {
        if (!this.allServicesMap.containsKey(accountId)) {
            return true;
        }
        String changeTimeStr = CacheHelper.getString(this.getServiceInstanceDataChangedKey(accountId));
        if (StringUtils.isNotEmpty((String)changeTimeStr)) {
            long changeTime = Long.parseLong(changeTimeStr);
            return changeTime > this.serviceInstanceLastUpdateTimeMap.getOrDefault(accountId, 0L);
        }
        return false;
    }

    public synchronized boolean isTenantChanged(String accountId) {
        if (!this.allTenantsMap.containsKey(accountId)) {
            return true;
        }
        String changeTimeStr = CacheHelper.getString(this.getTenantDataChangedKey(accountId));
        if (StringUtils.isNotEmpty((String)changeTimeStr)) {
            long changeTime = Long.parseLong(changeTimeStr);
            return changeTime > this.tenantLastUpdateTimeMap.getOrDefault(accountId, 0L);
        }
        return false;
    }

    public void init() {
        RequestContext rc = RequestContext.get();
        String accountId = rc.getAccountId();
        this.reloadServiceAndInstanceData(accountId);
        this.reloadTenantData(accountId);
    }

    public synchronized void reloadServiceAndInstanceData(String accountId) {
        this.serviceInstanceLastUpdateTimeMap.put(accountId, System.currentTimeMillis());
        this.allServicesMap.put(accountId, ServiceDao.queryAllServiceAndInstances());
    }

    public Service findService(String accountId, long serviceId) {
        List services = this.allServicesMap.getOrDefault(accountId, Collections.emptyList());
        for (Service service : services) {
            if (service.getId() != serviceId) continue;
            return service;
        }
        return null;
    }

    public Service findServiceByNumber(String accountId, String serviceNumber) {
        if (this.isServiceInstanceChanged(accountId)) {
            this.reloadServiceAndInstanceData(accountId);
        }
        if (serviceNumber == null) {
            throw new KDBizException(Constant.nullError("serviceNumber"), new Object[0]);
        }
        List services = this.allServicesMap.getOrDefault(accountId, Collections.emptyList());
        for (Service service : services) {
            if (!serviceNumber.equalsIgnoreCase(service.getNumber())) continue;
            return service;
        }
        throw new KDBizException(Constant.serviceDataError(serviceNumber), new Object[0]);
    }

    public synchronized void reloadTenantData(String accountId) {
        this.tenantLastUpdateTimeMap.put(accountId, System.currentTimeMillis());
        this.allTenantsMap.put(accountId, TenantDao.queryAllTenant());
    }

    public Tenant findTenantByCqTenantIdAndProdInstId(String accountId, String cqTenantId, String prodInstId) {
        if (this.isTenantChanged(accountId)) {
            this.reloadTenantData(accountId);
        }
        List tenants = this.allTenantsMap.getOrDefault(accountId, Collections.emptyList());
        for (Tenant tenant : tenants) {
            if (!cqTenantId.equalsIgnoreCase(tenant.getCqTenantId()) || !prodInstId.equalsIgnoreCase(tenant.getProdInstId())) continue;
            return tenant;
        }
        return null;
    }

    public Tenant findTenantById(String accountId, long id) {
        if (this.isTenantChanged(accountId)) {
            this.reloadTenantData(accountId);
        }
        List tenants = this.allTenantsMap.getOrDefault(accountId, Collections.emptyList());
        for (Tenant tenant : tenants) {
            if (id != tenant.getId()) continue;
            return tenant;
        }
        return null;
    }
}

